/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.project;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansConfig;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;

public class BeansProjectDescription {
    private IBeansProject project;
    private List configNames;
    private Map configs;
    private Map configSets;

    public BeansProjectDescription(IBeansProject project) {
        this.project = project;
        this.configs = new HashMap();
        this.configNames = new ArrayList();
        this.configSets = new HashMap();
    }

    public void setConfigNames(Collection configNames) {
        this.configNames = new ArrayList(configNames);
        this.configs = new HashMap();
        Iterator iter = this.configNames.iterator();
        while (iter.hasNext()) {
            String configName = (String)iter.next();
            BeansConfig config = new BeansConfig(this.project, configName);
            this.configs.put(configName, config);
        }
    }

    public Collection getConfigNames() {
        return this.configNames;
    }

    public void addConfig(IFile file) {
        this.addConfig(file.getProjectRelativePath().toString());
    }

    public void addConfig(String name) {
        if (name.length() > 0) {
            this.configNames.add(name);
            BeansConfig config = new BeansConfig(this.project, name);
            this.configs.put(name, config);
        }
    }

    public boolean hasConfig(IFile file) {
        return this.configNames.contains(file.getProjectRelativePath().toString());
    }

    public boolean hasConfig(String name) {
        return this.configNames.contains(name);
    }

    public IBeansConfig getConfig(IFile file) {
        String name = file.getProjectRelativePath().toString();
        if (this.configNames.contains(name)) {
            return (IBeansConfig)this.configs.get(name);
        }
        return null;
    }

    public IBeansConfig getConfig(String name) {
        if (this.configNames.contains(name)) {
            return (IBeansConfig)this.configs.get(name);
        }
        return null;
    }

    public Collection getConfigs() {
        return this.configs.values();
    }

    public void removeConfig(IFile file) {
        this.removeConfig(file.getProjectRelativePath().toString());
    }

    public void removeConfig(String name) {
        this.configNames.remove(name);
        this.configs.remove(name);
        Iterator iter = this.configSets.values().iterator();
        while (iter.hasNext()) {
            BeansConfigSet configSet = (BeansConfigSet)iter.next();
            configSet.removeConfig(name);
        }
    }

    public void addConfigSet(IBeansConfigSet configSet) {
        this.configSets.put(configSet.getElementName(), configSet);
    }

    public void setConfigSets(List configSets) {
        this.configSets.clear();
        Iterator iter = configSets.iterator();
        while (iter.hasNext()) {
            IBeansConfigSet configSet = (IBeansConfigSet)iter.next();
            this.configSets.put(configSet.getElementName(), configSet);
        }
    }

    public int getNumberOfConfigSets() {
        return this.configSets.size();
    }

    public Collection getConfigSetNames() {
        return this.configSets.keySet();
    }

    public IBeansConfigSet getConfigSet(String name) {
        return (IBeansConfigSet)this.configSets.get(name);
    }

    public Collection getConfigSets() {
        return this.configSets.values();
    }

    public String toString() {
        return "Configs=" + this.configNames + ", ConfigsSets=" + this.configSets.toString();
    }
}

