/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.parser;

import java.io.IOException;
import java.io.InputStream;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.BeanDefinitionReader;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.ide.eclipse.beans.core.BeanDefinitionException;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.parser.BeansDtdResolver;
import org.springframework.ide.eclipse.beans.core.internal.parser.EventBeanDefinitionParser;
import org.springframework.ide.eclipse.beans.core.internal.parser.IBeanDefinitionEvents;
import org.springframework.ide.eclipse.core.io.FileResourceLoader;
import org.springframework.ide.eclipse.core.io.xml.LineNumberPreservingDOMParser;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class EventBeanDefinitionReader
implements BeanDefinitionReader {
    public static final String DEBUG_OPTION = "org.springframework.ide.eclipse.beans.core/reader/debug";
    public static boolean DEBUG = BeansCorePlugin.isDebug("org.springframework.ide.eclipse.beans.core/reader/debug");
    private BeanDefinitionRegistry beanFactory;
    private IBeanDefinitionEvents eventHandler;
    private ResourceLoader resourceLoader;

    public EventBeanDefinitionReader(BeanDefinitionRegistry beanFactory, IBeanDefinitionEvents eventHandler) {
        this.beanFactory = beanFactory;
        this.eventHandler = eventHandler;
        this.resourceLoader = new FileResourceLoader();
    }

    public BeanDefinitionRegistry getBeanFactory() {
        return this.beanFactory;
    }

    public ClassLoader getBeanClassLoader() {
        return null;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public int loadBeanDefinitions(Resource[] resources) throws BeansException {
        int counter = 0;
        int i = 0;
        while (i < resources.length) {
            counter += this.loadBeanDefinitions(resources[i]);
            ++i;
        }
        return counter;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int loadBeanDefinitions(Resource resource) throws BeansException {
        if (DEBUG) {
            System.out.println("Reading config from " + resource);
        }
        InputStream input = null;
        try {
            try {
                input = resource.getInputStream();
                InputSource inputSource = new InputSource(input);
                inputSource.setSystemId(resource.getDescription());
                LineNumberPreservingDOMParser parser = new LineNumberPreservingDOMParser();
                parser.setFeature("http://xml.org/sax/features/validation", true);
                parser.setFeature("http://apache.org/xml/features/validation/dynamic", true);
                parser.setEntityResolver((EntityResolver)new BeansDtdResolver());
                parser.setErrorHandler((ErrorHandler)new BeansErrorHandler());
                parser.parse(inputSource);
                int n = this.registerBeanDefinitions(parser.getDocument(), resource);
                Object var5_10 = null;
                if (input == null) return n;
                try {
                    input.close();
                    return n;
                }
                catch (IOException e) {
                    BeansCorePlugin.log("Could not close InputStream", e);
                }
                return n;
            }
            catch (SAXException e) {
                throw new BeanDefinitionException(e);
            }
            catch (DOMException e) {
                throw new BeanDefinitionException(e);
            }
            catch (IOException e) {
                throw new BeanDefinitionException(e);
            }
            catch (BeansException e) {
                throw new BeanDefinitionException(e);
            }
        }
        catch (Throwable throwable) {
            Object var5_11 = null;
            if (input == null) throw throwable;
            try {}
            catch (IOException e) {
                BeansCorePlugin.log("Could not close InputStream", e);
                throw throwable;
            }
            input.close();
            throw throwable;
        }
    }

    public int loadBeanDefinitions(String location) throws BeanDefinitionStoreException {
        ResourceLoader resourceLoader = this.getResourceLoader();
        if (resourceLoader == null) {
            throw new BeanDefinitionStoreException("Cannot import bean definitions from location [" + location + "]: no ResourceLoader available");
        }
        if (resourceLoader instanceof ResourcePatternResolver) {
            try {
                Resource[] resources = ((ResourcePatternResolver)resourceLoader).getResources(location);
                int loadCount = this.loadBeanDefinitions(resources);
                return loadCount;
            }
            catch (IOException e) {
                throw new BeanDefinitionStoreException("Could not resolve bean definition resource pattern [" + location + "]", (Throwable)e);
            }
        }
        Resource resource = resourceLoader.getResource(location);
        return this.loadBeanDefinitions(resource);
    }

    public int registerBeanDefinitions(Document doc, Resource resource) throws BeansException {
        EventBeanDefinitionParser parser = new EventBeanDefinitionParser(this.eventHandler);
        return parser.registerBeanDefinitions(this, doc, resource);
    }

    private static class BeansErrorHandler
    implements ErrorHandler {
        BeansErrorHandler() {
        }

        public void error(SAXParseException e) throws SAXException {
            throw e;
        }

        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }

        public void warning(SAXParseException e) throws SAXException {
        }
    }
}

