/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.parser;

import java.io.IOException;
import org.springframework.core.io.ClassPathResource;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class BeansDtdResolver
implements EntityResolver {
    private static final String DTD_NAME = "spring-beans";
    private static final String SEARCH_PACKAGE = "/org/springframework/beans/factory/xml/";

    public InputSource resolveEntity(String publicId, String systemId) throws IOException {
        if (systemId != null && systemId.indexOf(DTD_NAME) > systemId.lastIndexOf("/")) {
            String dtdFile = systemId.substring(systemId.indexOf(DTD_NAME));
            try {
                ClassPathResource resource = new ClassPathResource(SEARCH_PACKAGE + dtdFile, this.getClass());
                InputSource source = new InputSource(resource.getInputStream());
                source.setPublicId(publicId);
                source.setSystemId(systemId);
                return source;
            }
            catch (IOException e) {
                BeansCorePlugin.log("Could not resolve beans DTD [" + systemId + "]: not found in class path", e);
            }
        }
        return null;
    }
}

