/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.Introspector;
import org.springframework.ide.eclipse.beans.core.internal.model.Bean;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeanConstructorArgument;
import org.springframework.ide.eclipse.beans.core.model.IBeanProperty;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.core.beans.DefaultBeanDefinitionRegistry;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.ISourceModelElement;
import org.springframework.util.StringUtils;

public class BeansConfigValidator {
    private static final String PROPERTY_PLACEHOLDER_PREFIX = "${";
    private static final String PROPERTY_PLACEHOLDER_SUFFIX = "}";
    private static final String FACTORY_BEAN_REFERENCE_PREFIX = "&";
    private static final String FACTORY_BEAN_REFERENCE_REGEXP = "[&]";
    public static final String DEBUG_OPTION = "org.springframework.ide.eclipse.beans.core/model/validator/debug";
    public static boolean DEBUG = BeansCorePlugin.isDebug("org.springframework.ide.eclipse.beans.core/model/validator/debug");
    private IProgressMonitor monitor;
    static /* synthetic */ Class class$0;

    public void validate(IBeansConfig config, IProgressMonitor monitor) {
        this.monitor = monitor;
        boolean isValidated = false;
        Iterator configSets = ((IBeansProject)config.getElementParent()).getConfigSets().iterator();
        while (configSets.hasNext()) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            IBeansConfigSet configSet = (IBeansConfigSet)configSets.next();
            if (!configSet.hasConfig(config.getElementName())) continue;
            DefaultBeanDefinitionRegistry registry = new DefaultBeanDefinitionRegistry(null);
            registry.setAllowAliasOverriding(false);
            IBeansProject project = (IBeansProject)configSet.getElementParent();
            Iterator cfgNames = configSet.getConfigs().iterator();
            while (cfgNames.hasNext()) {
                String cfgName = (String)cfgNames.next();
                if (cfgName.equals(config.getElementName())) {
                    this.validateConfig(config, configSet, (BeanDefinitionRegistry)registry);
                    continue;
                }
                IBeansConfig cfg = BeansModelUtils.getConfig(cfgName, (IModelElement)project);
                if (cfg == null) continue;
                BeansModelUtils.registerBeanDefinitions(cfg, (BeanDefinitionRegistry)registry);
            }
            if (!configSet.isIncomplete()) {
                this.validateConfigReferences(config, configSet, (BeanDefinitionRegistry)registry);
            }
            isValidated = true;
        }
        if (!isValidated) {
            DefaultBeanDefinitionRegistry registry = new DefaultBeanDefinitionRegistry(null);
            registry.setAllowAliasOverriding(false);
            this.validateConfig(config, null, (BeanDefinitionRegistry)registry);
            this.validateConfigReferences(config, null, (BeanDefinitionRegistry)registry);
        }
        monitor.worked(1);
    }

    protected void validateConfig(IBeansConfig config, IBeansConfigSet configSet, BeanDefinitionRegistry registry) {
        if (configSet == null) {
            this.monitor.subTask(BeansCorePlugin.getFormattedMessage("BeansConfigValidator.validateConfig", config.getConfigPath()));
            if (DEBUG) {
                System.out.println("Validating config '" + config.getConfigPath() + "'");
            }
        } else {
            this.monitor.subTask(BeansCorePlugin.getFormattedMessage("BeansConfigValidator.validateConfigSet", new String[]{config.getConfigPath(), configSet.getElementName()}));
            if (DEBUG) {
                System.out.println("Validating config '" + config.getConfigPath() + "' in set '" + configSet.getElementName() + "'");
            }
        }
        Iterator beans = config.getBeans().iterator();
        while (beans.hasNext()) {
            IBean bean = (IBean)beans.next();
            this.validateBean(bean, configSet, registry);
        }
    }

    protected void validateBean(IBean bean, IBeansConfigSet configSet, BeanDefinitionRegistry registry) {
        IType type;
        String className;
        if (this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.monitor.subTask(BeansCorePlugin.getFormattedMessage("BeansConfigValidator.validateBean", bean.getElementName()));
        if (configSet != null && !configSet.isAllowBeanDefinitionOverriding() && registry.containsBeanDefinition(bean.getElementName())) {
            BeansModelUtils.createProblemMarker((IModelElement)bean, "Overrides another bean within config set '" + configSet.getElementName() + "'", 2, bean.getElementStartLine(), 2, bean.getElementName(), configSet.getElementName());
        }
        AbstractBeanDefinition bd = (AbstractBeanDefinition)BeansModelUtils.getBeanDefinition(bean);
        AbstractBeanDefinition mergedBd = configSet == null ? (AbstractBeanDefinition)BeansModelUtils.getMergedBeanDefinition(bean, (IModelElement)BeansModelUtils.getConfig((IModelElement)bean)) : (AbstractBeanDefinition)BeansModelUtils.getMergedBeanDefinition(bean, configSet);
        this.validateBeanDefinitionHolder(bean, registry);
        if (bd instanceof RootBeanDefinition) {
            try {
                bd.validate();
            }
            catch (BeanDefinitionValidationException e) {
                BeansModelUtils.createProblemMarker((IModelElement)bean, "Invalid bean definition: " + e.getMessage(), 2, bean.getElementStartLine(), 9, bean.getElementName(), null);
            }
            className = bd.getBeanClassName();
            if (className != null) {
                if (bd.getFactoryBeanName() != null) {
                    BeansModelUtils.createProblemMarker((IModelElement)bean, "If factory bean specified then class attribute is not allowed", 2, bean.getElementStartLine(), 16, bean.getElementName(), null);
                } else {
                    type = BeansModelUtils.getJavaType(bean.getConfig().getConfigFile().getProject(), className);
                    if (type == null) {
                        if (!bean.isAbstract()) {
                            BeansModelUtils.createProblemMarker((IModelElement)bean, "Class '" + className + "' not found", 2, bean.getElementStartLine(), 4, bean.getElementName(), className);
                        }
                    } else if (!bean.isAbstract()) {
                        this.validateConstructorArguments(bean, type, bd.getConstructorArgumentValues());
                    }
                }
            }
        }
        if ((className = mergedBd.getBeanClassName()) != null && (type = BeansModelUtils.getJavaType(bean.getConfig().getConfigFile().getProject(), className)) != null) {
            this.validateProperties(bean, type, bd.getPropertyValues());
            if (bd.getFactoryMethodName() != null && bd.getFactoryBeanName() == null) {
                this.validateFactoryMethod(bean, className, bd.getFactoryMethodName(), true);
            }
        }
        Iterator innerBeans = bean.getInnerBeans().iterator();
        while (innerBeans.hasNext()) {
            IBean innerBean = (IBean)innerBeans.next();
            this.validateBean(innerBean, configSet, registry);
        }
    }

    protected void validateBeanDefinitionHolder(IBean bean, BeanDefinitionRegistry registry) {
        BeanDefinitionHolder bdHolder = ((Bean)bean).getBeanDefinitionHolder();
        try {
            registry.registerBeanDefinition(bdHolder.getBeanName(), bdHolder.getBeanDefinition());
        }
        catch (BeanDefinitionStoreException e) {
            BeansModelUtils.createProblemMarker((IModelElement)bean, e.getMessage(), 2, bean.getElementStartLine(), 2, bean.getElementName(), null);
        }
        if (bdHolder.getAliases() != null) {
            String[] aliases = bdHolder.getAliases();
            int i = 0;
            while (i < aliases.length) {
                String alias = aliases[i];
                try {
                    registry.registerAlias(bdHolder.getBeanName(), alias);
                }
                catch (BeanDefinitionStoreException e) {
                    BeansModelUtils.createProblemMarker((IModelElement)bean, e.getMessage(), 2, bean.getElementStartLine(), 10, bean.getElementName(), alias);
                }
                ++i;
            }
        }
    }

    protected void validateConstructorArguments(IBean bean, IType type, ConstructorArgumentValues argumentValues) {
        this.monitor.subTask(BeansCorePlugin.getFormattedMessage("BeansConfigValidator.validateConstructorArguments", bean.getElementName()));
        AbstractBeanDefinition bd = (AbstractBeanDefinition)BeansModelUtils.getBeanDefinition(bean);
        if (bd.getFactoryBeanName() == null && bd.getFactoryMethodName() == null) {
            int numArguments = argumentValues.getArgumentCount();
            try {
                if (!Introspector.hasConstructor(type, numArguments)) {
                    BeansModelUtils.createProblemMarker((IModelElement)bean, "No public constructor with " + numArguments + (numArguments == 1 ? " argument" : " arguments") + " defined in class '" + type.getFullyQualifiedName() + "'", 2, bean.getElementStartLine(), 6, bean.getElementName(), type.getFullyQualifiedName());
                }
            }
            catch (JavaModelException e) {
                BeansCorePlugin.log(e);
            }
        }
    }

    protected void validateProperties(IBean bean, IType type, MutablePropertyValues propertyValues) {
        this.monitor.subTask(BeansCorePlugin.getFormattedMessage("BeansConfigValidator.validateProperties", bean.getElementName()));
        PropertyValue[] propValues = propertyValues.getPropertyValues();
        int i = 0;
        while (i < propValues.length) {
            if (this.monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            PropertyValue propValue = propValues[i];
            String propertyName = propValue.getName();
            try {
                int pos = this.getNestedPropertySeparatorIndex(propertyName, false);
                if (pos >= 0) {
                    String nestedPropertyName = propertyName.substring(0, pos);
                    PropertyTokenHolder tokens = this.getPropertyNameTokens(nestedPropertyName);
                    String getterName = "get" + StringUtils.capitalize((String)tokens.actualName);
                    IMethod getter = Introspector.findMethod(type, getterName, 0, true, Introspector.STATIC_NO);
                    if (getter == null) {
                        IBeanProperty property = bean.getProperty(propertyName);
                        BeansModelUtils.createProblemMarker((IModelElement)bean, "No getter found for nested property '" + nestedPropertyName + "' in class '" + type.getFullyQualifiedName() + "'", 2, property != null ? property.getElementStartLine() : bean.getElementStartLine(), 15, bean.getElementName(), propertyName);
                    } else {
                        tokens.keys;
                    }
                } else if (!Introspector.hasWritableProperty(type, propertyName)) {
                    IBeanProperty property = bean.getProperty(propertyName);
                    BeansModelUtils.createProblemMarker((IModelElement)bean, "No setter found for property '" + propertyName + "' in class '" + type.getFullyQualifiedName() + "'", 2, property != null ? property.getElementStartLine() : bean.getElementStartLine(), 7, bean.getElementName(), propertyName);
                }
            }
            catch (JavaModelException e) {
                BeansCorePlugin.log(e);
            }
            ++i;
        }
    }

    protected void validateConfigReferences(IBeansConfig config, IBeansConfigSet configSet, BeanDefinitionRegistry registry) {
        IBean bean;
        if (DEBUG) {
            System.out.println("Validating references of bean config '" + config.getConfigPath() + "'");
        }
        this.monitor.subTask(BeansCorePlugin.getFormattedMessage("BeansConfigValidator.validateReferences", config.getConfigPath()));
        Iterator beans = config.getBeans().iterator();
        while (beans.hasNext()) {
            block8: {
                if (this.monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                bean = (IBean)beans.next();
                try {
                    registry.getBeanDefinition(bean.getElementName());
                }
                catch (NoSuchBeanDefinitionException e) {
                    if (e.getBeanName().equals(bean.getElementName())) {
                        BeansModelUtils.createProblemMarker((IModelElement)bean, "Bean name and parent bean name are the same", 2, bean.getElementStartLine(), 5, bean.getElementName(), e.getBeanName());
                    }
                    if (configSet == null || configSet.isIncomplete()) break block8;
                    BeansModelUtils.createProblemMarker((IModelElement)bean, "Parent bean '" + e.getBeanName() + "' not found in config set '" + configSet.getElementName() + "'", 2, bean.getElementStartLine(), 5, bean.getElementName(), e.getBeanName());
                }
            }
            this.validateBeanReferences(bean, registry);
        }
        beans = config.getInnerBeans().iterator();
        while (beans.hasNext()) {
            if (this.monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            bean = (IBean)beans.next();
            this.validateBeanReferences(bean, registry);
        }
    }

    protected void validateBeanReferences(IBean bean, BeanDefinitionRegistry registry) {
        try {
            AbstractBeanDefinition bd = (AbstractBeanDefinition)registry.getBeanDefinition(bean.getElementName());
            ConstructorArgumentValues cargs = bd.getConstructorArgumentValues();
            Iterator iter = cargs.getIndexedArgumentValues().entrySet().iterator();
            block2: while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                int index = (Integer)entry.getKey();
                Iterator cas = bean.getConstructorArguments().iterator();
                while (cas.hasNext()) {
                    IBeanConstructorArgument carg = (IBeanConstructorArgument)cas.next();
                    if (carg.getIndex() != index) continue;
                    ConstructorArgumentValues.ValueHolder valueHolder = (ConstructorArgumentValues.ValueHolder)entry.getValue();
                    if (valueHolder.getValue() == null) continue block2;
                    this.validateBeanReferencesInValue(bean, (IModelElement)carg, valueHolder.getValue(), registry);
                    continue block2;
                }
            }
            iter = cargs.getGenericArgumentValues().iterator();
            block4: while (iter.hasNext()) {
                ConstructorArgumentValues.ValueHolder valueHolder = (ConstructorArgumentValues.ValueHolder)iter.next();
                Iterator cas = bean.getConstructorArguments().iterator();
                while (cas.hasNext()) {
                    IBeanConstructorArgument carg = (IBeanConstructorArgument)cas.next();
                    if (carg.getType() != valueHolder.getType() || carg.getValue() != valueHolder.getValue()) continue;
                    if (valueHolder.getValue() == null) continue block4;
                    this.validateBeanReferencesInValue(bean, (IModelElement)carg, valueHolder.getValue(), registry);
                    continue block4;
                }
            }
            PropertyValue[] props = bd.getPropertyValues().getPropertyValues();
            int i = 0;
            while (i < props.length) {
                PropertyValue prop = props[i];
                Object element = bean.getProperty(prop.getName());
                if (element == null) {
                    element = bean;
                }
                this.validateBeanReferencesInValue(bean, (IModelElement)element, prop.getValue(), registry);
                ++i;
            }
            if (bd.getFactoryBeanName() != null) {
                if (bd.getFactoryMethodName() == null) {
                    BeansModelUtils.createProblemMarker((IModelElement)bean, "A factory bean requires a factory method", 2, bean.getElementStartLine(), 17, bean.getElementName(), bd.getFactoryBeanName());
                } else {
                    this.validateFactoryBean(bean, bd.getFactoryBeanName(), bd.getFactoryMethodName(), registry);
                }
            }
            if (bd.getDependsOn() != null) {
                String[] beanNames = bd.getDependsOn();
                int i2 = 0;
                while (i2 < beanNames.length) {
                    String beanName = beanNames[i2];
                    this.validateDependsOnBean(bean, beanName, registry);
                    ++i2;
                }
            }
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {}
    }

    protected void validateBeanReferencesInValue(IBean bean, IModelElement element, Object value, BeanDefinitionRegistry registry) {
        block16: {
            block20: {
                block19: {
                    block18: {
                        if (!(value instanceof RuntimeBeanReference)) break block18;
                        String beanName = ((RuntimeBeanReference)value).getBeanName();
                        try {
                            registry.getBeanDefinition(beanName);
                        }
                        catch (NoSuchBeanDefinitionException e) {
                            if (this.isPropertyPlaceHolder(beanName)) {
                                BeansModelUtils.createProblemMarker(element, "Referenced bean '" + beanName + "' not found", 1, ((ISourceModelElement)element).getElementStartLine(), 8, element.getElementName(), beanName);
                                break block16;
                            }
                            if (this.isFactoryBeanReference(beanName)) {
                                String tempBeanName = beanName.replaceFirst(FACTORY_BEAN_REFERENCE_REGEXP, "");
                                try {
                                    BeanDefinition def = registry.getBeanDefinition(tempBeanName);
                                    String beanClassName = ((AbstractBeanDefinition)def).getBeanClassName();
                                    if (beanClassName == null) break block16;
                                    IType type = BeansModelUtils.getJavaType(bean.getConfig().getConfigFile().getProject(), beanClassName);
                                    if (type != null) {
                                        try {
                                            String[] interfaces = type.getSuperInterfaceNames();
                                            if (interfaces == null || interfaces.length <= 0) break block16;
                                            List<String> list = Arrays.asList(interfaces);
                                            Class<?> clazz = class$0;
                                            if (clazz == null) {
                                                try {
                                                    clazz = class$0 = Class.forName("org.springframework.beans.factory.FactoryBean");
                                                }
                                                catch (ClassNotFoundException classNotFoundException) {
                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                }
                                            }
                                            if (!list.contains(clazz.getName())) {
                                                BeansModelUtils.createProblemMarker(element, "Referenced factory bean '" + tempBeanName + "' does not implement the FactoryBean interface", 2, ((ISourceModelElement)element).getElementStartLine(), 8, element.getElementName(), beanName);
                                            }
                                            break block16;
                                        }
                                        catch (JavaModelException javaModelException) {
                                            BeansCorePlugin.log(e);
                                        }
                                        break block16;
                                    }
                                    BeansModelUtils.createProblemMarker(element, "Referenced factory bean '" + tempBeanName + "' implementation class not found", 1, ((ISourceModelElement)element).getElementStartLine(), 8, element.getElementName(), beanName);
                                }
                                catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                                    BeansModelUtils.createProblemMarker(element, "Referenced factory bean '" + tempBeanName + "' not found", 1, ((ISourceModelElement)element).getElementStartLine(), 8, element.getElementName(), beanName);
                                }
                                break block16;
                            }
                            BeansModelUtils.createProblemMarker(element, "Referenced bean '" + beanName + "' not found", 1, ((ISourceModelElement)element).getElementStartLine(), 8, element.getElementName(), beanName);
                        }
                        break block16;
                    }
                    if (!(value instanceof List)) break block19;
                    List list = (List)value;
                    int i = 0;
                    while (i < list.size()) {
                        this.validateBeanReferencesInValue(bean, element, list.get(i), registry);
                        ++i;
                    }
                    break block16;
                }
                if (!(value instanceof Set)) break block20;
                Set set = (Set)value;
                Iterator iter = set.iterator();
                while (iter.hasNext()) {
                    this.validateBeanReferencesInValue(bean, element, iter.next(), registry);
                }
                break block16;
            }
            if (!(value instanceof Map)) break block16;
            Map map = (Map)value;
            Iterator iter = map.keySet().iterator();
            while (iter.hasNext()) {
                this.validateBeanReferencesInValue(bean, element, map.get(iter.next()), registry);
            }
        }
    }

    protected void validateFactoryBean(IBean bean, String beanName, String methodName, BeanDefinitionRegistry registry) {
        block5: {
            try {
                AbstractBeanDefinition factoryBd = (AbstractBeanDefinition)registry.getBeanDefinition(beanName);
                if (factoryBd.isAbstract()) {
                    BeansModelUtils.createProblemMarker((IModelElement)bean, "Invalid factory bean '" + beanName + "'", 2, bean.getElementStartLine(), 13, bean.getElementName(), beanName);
                } else if (factoryBd instanceof RootBeanDefinition && factoryBd.getFactoryMethodName() == null) {
                    this.validateFactoryMethod(bean, factoryBd.getBeanClassName(), methodName, false);
                }
            }
            catch (NoSuchBeanDefinitionException e) {
                if (e.getBeanName().equals(bean.getElementName())) break block5;
                BeansModelUtils.createProblemMarker((IModelElement)bean, "Factory bean '" + beanName + "' not found", 2, bean.getElementStartLine(), 12, bean.getElementName(), beanName);
            }
        }
    }

    protected void validateFactoryMethod(IBean bean, String className, String methodName, boolean isStatic) {
        IType type = BeansModelUtils.getJavaType(bean.getConfig().getConfigFile().getProject(), className);
        if (type == null) {
            BeansModelUtils.createProblemMarker((IModelElement)bean, "Factory bean class '" + className + "' not found", 2, bean.getElementStartLine(), 4, bean.getElementName(), className);
        } else {
            try {
                if (Introspector.findMethod(type, methodName, -1, true, isStatic ? Introspector.STATIC_YES : Introspector.STATIC_NO) == null) {
                    BeansModelUtils.createProblemMarker((IModelElement)bean, String.valueOf(isStatic ? "Static" : "Non-static") + " factory method '" + methodName + "' in factory bean class '" + className + "' not found", 2, bean.getElementStartLine(), 14, bean.getElementName(), methodName);
                }
            }
            catch (JavaModelException e) {
                BeansCorePlugin.log(e);
            }
        }
    }

    protected void validateDependsOnBean(IBean bean, String beanName, BeanDefinitionRegistry registry) {
        block2: {
            try {
                registry.getBeanDefinition(beanName);
            }
            catch (NoSuchBeanDefinitionException e) {
                if (e.getBeanName().equals(bean.getElementName())) break block2;
                BeansModelUtils.createProblemMarker((IModelElement)bean, "Depends-on bean '" + beanName + "' not found", 2, bean.getElementStartLine(), 11, bean.getElementName(), beanName);
            }
        }
    }

    private boolean isPropertyPlaceHolder(String property) {
        return property.startsWith(PROPERTY_PLACEHOLDER_PREFIX) && property.endsWith(PROPERTY_PLACEHOLDER_SUFFIX);
    }

    private boolean isFactoryBeanReference(String property) {
        return property.startsWith(FACTORY_BEAN_REFERENCE_PREFIX);
    }

    private int getNestedPropertySeparatorIndex(String propertyPath, boolean last) {
        boolean inKey = false;
        int i = last ? propertyPath.length() - 1 : 0;
        while (last && i >= 0 || i < propertyPath.length()) {
            switch (propertyPath.charAt(i)) {
                case '[': 
                case ']': {
                    inKey = !inKey;
                    break;
                }
                case '.': {
                    if (inKey) break;
                    return i;
                }
            }
            if (last) {
                --i;
                continue;
            }
            ++i;
        }
        return -1;
    }

    private PropertyTokenHolder getPropertyNameTokens(String propertyName) {
        PropertyTokenHolder tokens = new PropertyTokenHolder();
        String actualName = null;
        ArrayList<String> keys = new ArrayList<String>(2);
        int searchIndex = 0;
        while (searchIndex != -1) {
            String key;
            int keyEnd;
            int keyStart = propertyName.indexOf("[", searchIndex);
            searchIndex = -1;
            if (keyStart == -1 || (keyEnd = propertyName.indexOf("]", keyStart + "[".length())) == -1) continue;
            if (actualName == null) {
                actualName = propertyName.substring(0, keyStart);
            }
            if ((key = propertyName.substring(keyStart + "[".length(), keyEnd)).startsWith("'") && key.endsWith("'")) {
                key = key.substring(1, key.length() - 1);
            } else if (key.startsWith("\"") && key.endsWith("\"")) {
                key = key.substring(1, key.length() - 1);
            }
            keys.add(key);
            searchIndex = keyEnd + "]".length();
        }
        tokens.actualName = actualName != null ? actualName : propertyName;
        tokens.canonicalName = tokens.actualName;
        if (!keys.isEmpty()) {
            PropertyTokenHolder propertyTokenHolder = tokens;
            propertyTokenHolder.canonicalName = String.valueOf(propertyTokenHolder.canonicalName) + "[" + StringUtils.collectionToDelimitedString(keys, (String)"][") + "]";
            tokens.keys = keys.toArray(new String[keys.size()]);
        }
        return tokens;
    }

    private static class PropertyTokenHolder {
        private String canonicalName;
        private String actualName;
        private String[] keys;

        PropertyTokenHolder() {
        }
    }
}

