/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model;

import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.core.model.IModelElement;

public class BeanReference {
    public static final int STANDARD_BEAN_TYPE = 1;
    public static final int PARENT_BEAN_TYPE = 2;
    public static final int FACTORY_BEAN_TYPE = 3;
    public static final int DEPENDS_ON_BEAN_TYPE = 4;
    public static final int METHOD_OVERRIDE_BEAN_TYPE = 5;
    public static final int INTERCEPTOR_BEAN_TYPE = 6;
    public static final int INNER_BEAN_TYPE = 7;
    private IModelElement source;
    private IBean target;
    private int type;

    public BeanReference(IModelElement source, IBean target) {
        this(1, source, target);
    }

    public BeanReference(int type, IModelElement source, IBean target) {
        this.type = type;
        this.source = source;
        this.target = target;
    }

    public final int getType() {
        return this.type;
    }

    public final IModelElement getSource() {
        return this.source;
    }

    public final IBean getTarget() {
        return this.target;
    }

    public final String getID() {
        StringBuffer id = new StringBuffer();
        id.append(id);
        id.append('|');
        if (this.source != null) {
            id.append(this.source);
        }
        id.append('|');
        if (this.target != null) {
            id.append(this.target);
        }
        return id.toString();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BeanReference) {
            return ((BeanReference)obj).getType() == this.getType() && ((BeanReference)obj).getSource().equals(this.source) && ((BeanReference)obj).getTarget().equals(this.target);
        }
        return false;
    }

    public final int hashCode() {
        return this.getID().hashCode();
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        text.append(this.type);
        text.append(": ");
        text.append(this.source);
        text.append(" -> ");
        text.append(this.target);
        return text.toString();
    }
}

