/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;

public class BeansCoreUtils {
    public static boolean isBeansConfig(IResource resource) {
        IBeansProject project;
        if (resource instanceof IFile && (project = BeansCorePlugin.getModel().getProject(resource.getProject())) != null) {
            return project.hasConfig((IFile)resource);
        }
        return false;
    }

    public static void createProblemMarker(IResource resource, String message, int severity, int line, int errorCode) {
        BeansCoreUtils.createProblemMarker(resource, message, severity, line, errorCode, null, null);
    }

    public static void createProblemMarker(IResource resource, String message, int severity, int line, int errorCode, String beanID, String errorData) {
        if (resource != null && resource.isAccessible()) {
            try {
                IMarker[] markers = resource.findMarkers("org.springframework.ide.eclipse.beans.core.problemmarker", false, 0);
                int i = 0;
                while (i < markers.length) {
                    String msg;
                    IMarker marker = markers[i];
                    int l = marker.getAttribute("lineNumber", -1);
                    if (l == line && (msg = marker.getAttribute("message", "")).equals(message)) {
                        return;
                    }
                    ++i;
                }
                IMarker marker = resource.createMarker("org.springframework.ide.eclipse.beans.core.problemmarker");
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                attributes.put("message", message);
                attributes.put("severity", new Integer(severity));
                if (line > 0) {
                    attributes.put("lineNumber", new Integer(line));
                }
                if (errorCode != 0) {
                    attributes.put("errorCode", new Integer(errorCode));
                }
                if (beanID != null) {
                    attributes.put("beanID", beanID);
                }
                if (errorData != null) {
                    attributes.put("errorData", errorData);
                }
                marker.setAttributes(attributes);
            }
            catch (CoreException e) {
                BeansCorePlugin.log(e);
            }
        }
    }

    public static void deleteProblemMarkers(IResource resource) {
        if (resource != null && resource.isAccessible()) {
            try {
                resource.deleteMarkers("org.springframework.ide.eclipse.beans.core.problemmarker", false, 0);
            }
            catch (CoreException e) {
                BeansCorePlugin.log(e);
            }
        }
    }
}

