/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModel;
import org.springframework.ide.eclipse.beans.core.model.IBeansModel;

public class BeansCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.springframework.ide.eclipse.beans.core";
    private static final String RESOURCE_NAME = "org.springframework.ide.eclipse.beans.core.messages";
    private static BeansCorePlugin plugin;
    private static final BeansModel BEANS_MODEL;
    private ResourceBundle resourceBundle;

    static {
        BEANS_MODEL = new BeansModel();
    }

    public BeansCorePlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle(RESOURCE_NAME);
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        BEANS_MODEL.startup();
    }

    public void stop(BundleContext context) throws Exception {
        BEANS_MODEL.shutdown();
        super.stop(context);
    }

    public static BeansCorePlugin getDefault() {
        return plugin;
    }

    public static final IBeansModel getModel() {
        return BEANS_MODEL;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        String bundleString;
        ResourceBundle bundle = BeansCorePlugin.getDefault().getResourceBundle();
        if (bundle != null) {
            try {
                bundleString = bundle.getString(key);
            }
            catch (MissingResourceException e) {
                BeansCorePlugin.log(e);
                bundleString = "!" + key + "!";
            }
        } else {
            bundleString = "!" + key + "!";
        }
        return bundleString;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static boolean isDebug(String option) {
        String value = Platform.getDebugOption((String)option);
        return value != null && value.equalsIgnoreCase("true");
    }

    public static void log(IStatus status) {
        BeansCorePlugin.getDefault().getLog().log(status);
    }

    public static void log(String message, Throwable exception) {
        IStatus status = BeansCorePlugin.createErrorStatus(message, exception);
        BeansCorePlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable exception) {
        BeansCorePlugin.getDefault().getLog().log(BeansCorePlugin.createErrorStatus(BeansCorePlugin.getResourceString("Plugin.internal_error"), exception));
    }

    public static IStatus createErrorStatus(String message, Throwable exception) {
        if (message == null) {
            message = "";
        }
        return new Status(4, PLUGIN_ID, 0, message, exception);
    }

    public static String getFormattedMessage(String key, String arg) {
        return BeansCorePlugin.getFormattedMessage(key, new String[]{arg});
    }

    public static String getFormattedMessage(String key, String[] args) {
        return MessageFormat.format(BeansCorePlugin.getResourceString(key), args);
    }
}

