/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.hyperlink;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.StructuredModelManager;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.beans.core.internal.Introspector;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.ui.editor.BeansEditorUtils;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.ExternalBeanHyperlink;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.JavaElementHyperlink;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.NodeElementHyperlink;
import org.springframework.ide.eclipse.core.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class BeansHyperLinkDetector
implements IHyperlinkDetector {
    private IEditorPart editor;

    public BeansHyperLinkDetector(IEditorPart editor) {
        this.editor = editor;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        IRegion hyperlinkRegion;
        IHyperlink hyperLink;
        Attr currentAttr;
        short nodeType;
        if (region == null || textViewer == null) {
            return null;
        }
        IDocument document = textViewer.getDocument();
        Node currentNode = this.getCurrentNode(document, region.getOffset());
        if (currentNode != null && (nodeType = currentNode.getNodeType()) != 10 && nodeType == 1 && (currentAttr = this.getCurrentAttrNode(currentNode, region.getOffset())) != null && this.isLinkableAttr(currentAttr) && (hyperLink = this.createHyperlink(currentAttr, hyperlinkRegion = this.getHyperlinkRegion(currentAttr), document, currentNode, textViewer)) != null) {
            return new IHyperlink[]{hyperLink};
        }
        return null;
    }

    private Attr getCurrentAttrNode(Node node, int offset) {
        if (node instanceof IndexedRegion && ((IndexedRegion)node).contains(offset) && node.hasAttributes()) {
            NamedNodeMap attrs = node.getAttributes();
            int i = 0;
            while (i < attrs.getLength()) {
                IndexedRegion attRegion = (IndexedRegion)attrs.item(i);
                if (attRegion.contains(offset)) {
                    return (Attr)attrs.item(i);
                }
                ++i;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Node getCurrentNode(IDocument document, int offset) {
        IndexedRegion inode;
        block6: {
            inode = null;
            IStructuredModel sModel = null;
            try {
                sModel = StructuredModelManager.getModelManager().getExistingModelForRead(document);
                inode = sModel.getIndexedRegion(offset);
                if (inode == null) {
                    inode = sModel.getIndexedRegion(offset - 1);
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (sModel != null) {
                    sModel.releaseFromRead();
                }
                throw throwable;
            }
            {
                Object var5_7 = null;
                if (sModel == null) break block6;
            }
            sModel.releaseFromRead();
        }
        if (inode instanceof Node) {
            return (Node)inode;
        }
        return null;
    }

    private IRegion getHyperlinkRegion(Node node) {
        Region hyperRegion = null;
        if (node != null) {
            short nodeType = node.getNodeType();
            if (nodeType == 10 || nodeType == 1) {
                IDOMNode docNode = (IDOMNode)node;
                hyperRegion = new Region(docNode.getStartOffset(), docNode.getEndOffset() - docNode.getStartOffset());
            } else if (nodeType == 2) {
                IDOMAttr att = (IDOMAttr)node;
                int regOffset = att.getValueRegionStartOffset();
                int regLength = att.getValueRegionText().length();
                String attValue = att.getValueRegionText();
                if (StringUtils.isQuoted((String)attValue)) {
                    ++regOffset;
                    regLength -= 2;
                }
                hyperRegion = new Region(regOffset, regLength);
            }
        }
        return hyperRegion;
    }

    private boolean isLinkableAttr(Attr attr) {
        String attrName = attr.getName();
        if ("class".equals(attrName)) {
            return true;
        }
        if ("name".equals(attrName) && "property".equals(attr.getOwnerElement().getNodeName())) {
            return true;
        }
        if ("init-method".equals(attrName)) {
            return true;
        }
        if ("destroy-method".equals(attrName)) {
            return true;
        }
        if ("factory-method".equals(attrName)) {
            return true;
        }
        if ("factory-bean".equals(attrName)) {
            return true;
        }
        if ("parent".equals(attrName)) {
            return true;
        }
        if ("depends-on".equals(attrName)) {
            return true;
        }
        return "local".equals(attrName) || "bean".equals(attrName);
    }

    private IHyperlink createHyperlink(Attr attr, IRegion hyperlinkRegion, IDocument document, Node node, ITextViewer textViewer) {
        Object link;
        block25: {
            Element parentNode;
            String target;
            String name;
            block27: {
                NamedNodeMap attributes;
                String parentName;
                block26: {
                    link = null;
                    if (attr == null) break block25;
                    name = attr.getName();
                    target = attr.getNodeValue();
                    parentNode = attr.getOwnerElement();
                    parentName = null;
                    if (parentNode != null) {
                        parentName = parentNode.getNodeName();
                    }
                    if (!"class".equals(name)) break block26;
                    IFile file = ((IFileEditorInput)this.editor.getEditorInput()).getFile();
                    IType type = BeansModelUtils.getJavaType((IProject)file.getProject(), (String)target);
                    if (type != null) {
                        link = new JavaElementHyperlink(hyperlinkRegion, (IJavaElement)type);
                    }
                    break block25;
                }
                if (!"name".equals(name) || !"property".equals(parentName)) break block27;
                Node parentParentNode = parentNode.getParentNode();
                if (!"bean".equals(parentParentNode.getNodeName()) || (attributes = parentParentNode.getAttributes()) == null || attributes.getNamedItem("class") == null) break block25;
                String className = attributes.getNamedItem("class").getNodeValue();
                IFile file = ((IFileEditorInput)this.editor.getEditorInput()).getFile();
                IType type = BeansModelUtils.getJavaType((IProject)file.getProject(), (String)className);
                if (type == null) break block25;
                String methodName = "set" + StringUtils.capitalize((String)target);
                try {
                    IMethod method = Introspector.findMethod((IType)type, (String)methodName, (int)1, (boolean)true, (int)Introspector.STATIC_NO);
                    if (method != null) {
                        link = new JavaElementHyperlink(hyperlinkRegion, (IJavaElement)method);
                    }
                    break block25;
                }
                catch (JavaModelException javaModelException) {}
                break block25;
            }
            if ("init-method".equals(name) || "destroy-method".equals(name)) {
                NamedNodeMap attributes = parentNode.getAttributes();
                if (attributes != null && attributes.getNamedItem("class") != null) {
                    String className = attributes.getNamedItem("class").getNodeValue();
                    IFile file = ((IFileEditorInput)this.editor.getEditorInput()).getFile();
                    IType type = BeansModelUtils.getJavaType((IProject)file.getProject(), (String)className);
                    try {
                        IMethod method = Introspector.findMethod((IType)type, (String)target, (int)0, (boolean)true, (int)Introspector.STATIC_IRRELVANT);
                        if (method != null) {
                            link = new JavaElementHyperlink(hyperlinkRegion, (IJavaElement)method);
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                }
            } else if ("factory-method".equals(name)) {
                NamedNodeMap attributes = parentNode.getAttributes();
                String className = null;
                if (attributes != null && attributes.getNamedItem("factory-bean") != null) {
                    Node factoryBean = attributes.getNamedItem("factory-bean");
                    if (factoryBean != null) {
                        String factoryBeanId = factoryBean.getNodeValue();
                        Document doc = node.getOwnerDocument();
                        Element bean = doc.getElementById(factoryBeanId);
                        if (bean != null && bean instanceof Node) {
                            NamedNodeMap attribute = bean.getAttributes();
                            className = attribute.getNamedItem("class").getNodeValue();
                        }
                    }
                } else if (attributes != null && attributes.getNamedItem("class") != null) {
                    className = attributes.getNamedItem("class").getNodeValue();
                }
                try {
                    IFile file = ((IFileEditorInput)this.editor.getEditorInput()).getFile();
                    IType type = BeansModelUtils.getJavaType((IProject)file.getProject(), (String)className);
                    IMethod method = Introspector.findMethod((IType)type, (String)target, (int)-1, (boolean)true, (int)Introspector.STATIC_YES);
                    if (method != null) {
                        link = new JavaElementHyperlink(hyperlinkRegion, (IJavaElement)method);
                    }
                }
                catch (JavaModelException javaModelException) {}
            } else if ("factory-bean".equals(name) || "depends-on".equals(name) || "parent".equals(name) || "local".equals(name) || "bean".equals(name)) {
                Document doc = node.getOwnerDocument();
                Element bean = doc.getElementById(target);
                if (bean != null) {
                    IRegion region = this.getHyperlinkRegion(bean);
                    link = new NodeElementHyperlink(hyperlinkRegion, region, textViewer);
                } else {
                    IFile file = ((IFileEditorInput)this.editor.getEditorInput()).getFile();
                    Iterator beans = BeansEditorUtils.getBeansFromConfigSets(file).iterator();
                    while (beans.hasNext()) {
                        IBean modelBean = (IBean)beans.next();
                        if (!modelBean.getElementName().equals(target)) continue;
                        link = new ExternalBeanHyperlink(modelBean, hyperlinkRegion);
                    }
                }
            }
        }
        return link;
    }
}

