/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.graph.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.ui.graph.model.Bean;
import org.springframework.ide.eclipse.beans.ui.graph.model.ConstructorArgument;
import org.springframework.ide.eclipse.beans.ui.graph.model.Property;

public class Reference
extends Edge
implements IAdaptable {
    private int type;
    private Node node;

    public Reference(Bean source, Bean target) {
        this(1, source, target, null);
    }

    public Reference(int type, Bean source, Bean target) {
        this(type, source, target, null);
    }

    public Reference(int type, Bean source, Bean target, Node node) {
        super((Node)source, (Node)target);
        this.type = type;
        this.node = node;
    }

    public int getType() {
        return this.type;
    }

    public Bean getSourceBean() {
        return (Bean)this.source;
    }

    public Bean getTargetBean() {
        return (Bean)this.target;
    }

    public Node getNode() {
        return this.node;
    }

    public IFile getConfigFile() {
        if (this.node instanceof Property) {
            IBean bean = ((Property)this.node).getBean().getBean();
            return bean.getConfig().getConfigFile();
        }
        if (this.node instanceof ConstructorArgument) {
            IBean bean = ((ConstructorArgument)this.node).getBean().getBean();
            return bean.getConfig().getConfigFile();
        }
        return this.getSourceBean().getConfigFile();
    }

    public int getStartLine() {
        if (this.node instanceof Property) {
            return ((Property)this.node).getBeanProperty().getElementStartLine();
        }
        if (this.node instanceof ConstructorArgument) {
            return ((ConstructorArgument)this.node).getBeanConstructorArgument().getElementStartLine();
        }
        return this.getSourceBean().getStartLine();
    }

    public Object getAdapter(Class adapter) {
        if (this.node instanceof Property) {
            return ((Property)this.node).getAdapter(adapter);
        }
        if (this.node instanceof ConstructorArgument) {
            return ((ConstructorArgument)this.node).getAdapter(adapter);
        }
        return this.getSourceBean().getAdapter(adapter);
    }

    public String toString() {
        return "Reference from '" + ((Bean)this.source).getName() + "' to '" + ((Bean)this.target).getName() + "'";
    }
}

