/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.graph.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.BeanReference;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeanConstructorArgument;
import org.springframework.ide.eclipse.beans.core.model.IBeanProperty;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.ui.graph.BeansGraphImages;
import org.springframework.ide.eclipse.beans.ui.graph.BeansGraphPlugin;
import org.springframework.ide.eclipse.beans.ui.graph.editor.GraphEditorInputFactory;
import org.springframework.ide.eclipse.beans.ui.graph.model.Bean;
import org.springframework.ide.eclipse.core.model.IModelElement;

public class GraphEditorInput
implements IEditorInput,
IPersistableElement {
    private IModelElement element;
    private IModelElement context;
    private String name;
    private String toolTip;
    private Map beans;
    private boolean hasError;
    static /* synthetic */ Class class$0;

    public GraphEditorInput(String elementID) {
        this(BeansCorePlugin.getModel().getElement(elementID), GraphEditorInput.getContext(elementID));
    }

    public GraphEditorInput(String elementID, String contextID) {
        this(BeansCorePlugin.getModel().getElement(elementID), BeansCorePlugin.getModel().getElement(contextID));
    }

    public GraphEditorInput(IModelElement element) {
        this(element, GraphEditorInput.getContext(element));
    }

    private static IModelElement getContext(IModelElement element) {
        if (element instanceof IBean) {
            return element.getElementParent();
        }
        if (element instanceof IBeanConstructorArgument || element instanceof IBeanProperty) {
            return element.getElementParent().getElementParent();
        }
        return element;
    }

    private static IModelElement getContext(String elementId) {
        IModelElement element = BeansCorePlugin.getModel().getElement(elementId);
        return GraphEditorInput.getContext(element);
    }

    public GraphEditorInput(IModelElement element, IModelElement context) {
        this.element = element;
        this.context = context;
        if (element instanceof IBeansConfig) {
            IFile file = ((IBeansConfig)element).getConfigFile();
            if (file != null) {
                this.name = file.getName();
                this.toolTip = String.valueOf(BeansGraphPlugin.getResourceString("ShowGraphAction.name.config")) + file.getFullPath().toString();
            } else {
                this.name = BeansGraphPlugin.getResourceString("ShowGraphAction.name.undefined");
                this.toolTip = String.valueOf(BeansGraphPlugin.getResourceString("ShowGraphAction.name.config")) + this.name;
            }
        } else if (element instanceof IBeansConfigSet) {
            IModelElement parent = ((IBeansConfigSet)element).getElementParent();
            this.name = element.getElementName();
            this.toolTip = String.valueOf(BeansGraphPlugin.getResourceString("ShowGraphAction.name.configSet")) + parent.getElementName() + '/' + element.getElementName();
        } else if (element instanceof IBean) {
            this.name = element.getElementName();
            StringBuffer buffer = new StringBuffer();
            buffer.append(BeansGraphPlugin.getResourceString("ShowGraphAction.name.bean"));
            if (context instanceof IBeansConfig) {
                buffer.append(BeansGraphPlugin.getResourceString("ShowGraphAction.name.config"));
                buffer.append(context.getElementName());
                buffer.append(": ");
            } else if (context instanceof IBeansConfigSet) {
                buffer.append(BeansGraphPlugin.getResourceString("ShowGraphAction.name.configSet"));
                buffer.append(context.getElementParent().getElementName());
                buffer.append('/');
                buffer.append(context.getElementName());
                buffer.append(": ");
            }
            buffer.append(element.getElementName());
            this.toolTip = buffer.toString();
        } else {
            throw new IllegalArgumentException("Unsupported model element " + element);
        }
        this.createBeansMap();
    }

    protected void createBeansMap() {
        IBean bean;
        Iterator beans;
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.element instanceof IBeansConfig) {
            beans = ((IBeansConfig)this.element).getBeans().iterator();
            while (beans.hasNext()) {
                bean = (IBean)beans.next();
                list.add(bean);
            }
        } else if (this.element instanceof IBeansConfigSet) {
            beans = ((IBeansConfigSet)this.element).getBeans().iterator();
            while (beans.hasNext()) {
                bean = (IBean)beans.next();
                list.add(bean);
            }
        } else if (this.element instanceof IBean) {
            list.add(this.element);
            Iterator beanRefs = BeansModelUtils.getBeanReferences((IModelElement)this.element, (IModelElement)this.context, (boolean)true).iterator();
            while (beanRefs.hasNext()) {
                BeanReference beanRef = (BeanReference)beanRefs.next();
                if (beanRef.getType() == 7) continue;
                list.add(beanRef.getTarget());
            }
        }
        this.beans = new HashMap();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            bean = (IBean)iter.next();
            this.beans.put(bean.getElementName(), new Bean(bean));
        }
    }

    public String getName() {
        return this.name;
    }

    public IModelElement getElement() {
        return this.element;
    }

    public IModelElement getContext() {
        return this.context;
    }

    public Map getBeans() {
        return this.beans;
    }

    public void setHasError(boolean hasError) {
        this.hasError = hasError;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.springframework.ide.eclipse.core.model.IModelElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this.getElement();
        }
        return null;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return BeansGraphImages.DESC_OBJS_SPRING;
    }

    public IPersistableElement getPersistable() {
        return this.hasError ? null : this;
    }

    public String getToolTipText() {
        return this.toolTip;
    }

    public String getFactoryId() {
        return GraphEditorInputFactory.getFactoryId();
    }

    public void saveState(IMemento memento) {
        GraphEditorInputFactory.saveState(memento, this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof GraphEditorInput) {
            GraphEditorInput input = (GraphEditorInput)obj;
            IModelElement element = this.getElement();
            IModelElement context = this.getContext();
            if (input.getElement() == element && input.getContext() == context) {
                return true;
            }
            if (input.getElement().equals(element) && (input.getContext() == context || input.getContext() != null && input.getContext().equals(context))) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        IModelElement element = this.getElement();
        IModelElement context = this.getContext();
        return (element == null ? 0 : element.hashCode()) ^ (context == null ? 0 : context.hashCode());
    }
}

