/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.views.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.springframework.ide.eclipse.beans.ui.BeansUIPlugin;
import org.springframework.ide.eclipse.beans.ui.model.BeanNode;
import org.springframework.ide.eclipse.beans.ui.model.ConfigNode;
import org.springframework.ide.eclipse.beans.ui.model.ConfigSetNode;
import org.springframework.ide.eclipse.beans.ui.model.INode;
import org.springframework.ide.eclipse.beans.ui.model.ProjectNode;
import org.springframework.ide.eclipse.beans.ui.model.PropertyNode;
import org.springframework.ide.eclipse.beans.ui.properties.ConfigurationPropertyPage;
import org.springframework.ide.eclipse.beans.ui.views.BeansView;
import org.springframework.ide.eclipse.ui.SpringUIUtils;

public class OpenPropertiesAction
extends Action {
    private static final String PREFIX = "View.OpenPropertiesAction.";
    private static final String TITLE = "PropertiesPage.title";
    private BeansView view;

    public OpenPropertiesAction(BeansView view) {
        super(BeansUIPlugin.getResourceString("View.OpenPropertiesAction.label"));
        this.setToolTipText(BeansUIPlugin.getResourceString("View.OpenPropertiesAction.tooltip"));
        this.view = view;
    }

    public void run() {
        IProject project = null;
        int block = 0;
        INode node = (INode)((IStructuredSelection)this.view.getViewer().getSelection()).getFirstElement();
        if (node instanceof ProjectNode) {
            project = ((ProjectNode)node).getProject().getProject();
        } else if (node instanceof ConfigNode) {
            project = ((ConfigNode)node).getProjectNode().getProject().getProject();
        } else if (node instanceof ConfigSetNode) {
            project = ((ConfigSetNode)node).getProjectNode().getProject().getProject();
            block = 1;
        } else if (node instanceof BeanNode) {
            project = ((BeanNode)node).getConfigNode().getProjectNode().getProject().getProject();
        } else if (node instanceof PropertyNode) {
            project = ((PropertyNode)node).getConfigNode().getProjectNode().getProject().getProject();
        }
        if (project != null) {
            String title = String.valueOf(BeansUIPlugin.getResourceString(TITLE)) + project.getName();
            ConfigurationPropertyPage page = new ConfigurationPropertyPage(project, block);
            SpringUIUtils.showPreferencePage((String)"org.springframework.ide.eclipse.beans.ui.properties.ConfigurationPropertyPage", (IPreferencePage)page, (String)title);
        }
    }
}

