/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.properties;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansModel;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.ui.BeansUIPlugin;
import org.springframework.ide.eclipse.beans.ui.model.ConfigNode;
import org.springframework.ide.eclipse.beans.ui.model.ConfigSetNode;
import org.springframework.ide.eclipse.beans.ui.model.ModelLabelDecorator;
import org.springframework.ide.eclipse.beans.ui.model.ModelLabelProvider;
import org.springframework.ide.eclipse.beans.ui.model.ModelSorter;
import org.springframework.ide.eclipse.beans.ui.model.ProjectNode;

public class ConfigSetDialog
extends Dialog {
    private static final String TITLE_NEW = "ConfigSetDialog.title.new";
    private static final String TITLE_EDIT = "ConfigSetDialog.title.edit";
    private static final String ERROR_INVALID_NAME = "ConfigSetDialog.error.invalidName";
    private static final String ERROR_USED_NAME = "ConfigSetDialog.error.usedName";
    private static final String NAME_TEXT_LABEL = "ConfigSetDialog.nameText.label";
    private static final String OVERRIDE_TEXT_LABEL = "ConfigSetDialog.overrideText.label";
    private static final String INCOMPLETE_TEXT_LABEL = "ConfigSetDialog.incompleteText.label";
    private static final int LIST_VIEWER_HEIGHT = 250;
    private static final int LIST_VIEWER_WIDTH = 300;
    private Text nameText;
    private Button overrideButton;
    private Button incompleteButton;
    private CheckboxTableViewer configsViewer;
    private Label errorLabel;
    private Button okButton;
    private ProjectNode project;
    private ConfigSetNode configSet;
    private String configSetName;
    private String title;

    public ConfigSetDialog(Shell parent, ProjectNode project, String configSetName) {
        super(parent);
        this.project = project;
        this.configSetName = configSetName;
        if (configSetName == null) {
            this.configSet = new ConfigSetNode(project);
            this.title = BeansUIPlugin.getResourceString(TITLE_NEW);
        } else {
            this.configSet = project.getConfigSet(configSetName);
            this.title = BeansUIPlugin.getResourceString(TITLE_EDIT);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite nameGroup = new Composite(composite, 0);
        nameGroup.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        nameGroup.setLayout((Layout)layout);
        Label nameLabel = new Label(nameGroup, 0);
        nameLabel.setText(BeansUIPlugin.getResourceString(NAME_TEXT_LABEL));
        this.nameText = new Text(nameGroup, 2052);
        this.nameText.setLayoutData((Object)new GridData(768));
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConfigSetDialog.this.validateName();
            }
        });
        Composite checkboxGroup = new Composite(composite, 0);
        checkboxGroup.setLayoutData((Object)new GridData(768));
        this.overrideButton = this.createCheckBox(checkboxGroup, BeansUIPlugin.getResourceString(OVERRIDE_TEXT_LABEL));
        this.overrideButton.setSelection(this.configSet.isOverrideEnabled());
        this.incompleteButton = this.createCheckBox(checkboxGroup, BeansUIPlugin.getResourceString(INCOMPLETE_TEXT_LABEL));
        this.incompleteButton.setSelection(this.configSet.isIncomplete());
        this.configsViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        GridData gd = new GridData(1808);
        gd.widthHint = 300;
        gd.heightHint = 250;
        this.configsViewer.getTable().setLayoutData((Object)gd);
        this.configsViewer.setContentProvider((IContentProvider)new ConfigFilesContentProvider(this.createConfigList()));
        this.configsViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new ModelLabelProvider(), (ILabelDecorator)new ModelLabelDecorator()));
        this.configsViewer.setSorter((ViewerSorter)new ModelSorter(true));
        this.configsViewer.setInput((Object)this);
        this.configsViewer.setCheckedElements(this.configSet.getConfigs().toArray());
        this.errorLabel = new Label(composite, 0);
        this.errorLabel.setLayoutData((Object)new GridData(768));
        ConfigSetDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected Button createCheckBox(Composite group, String labelText) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        group.setLayout((Layout)layout);
        Button button = new Button(group, 32);
        Label label = new Label(group, 0);
        label.setText(labelText);
        return button;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.nameText.setFocus();
        String name = this.configSet.getName();
        if (name != null && name.trim().length() != 0) {
            this.nameText.setText(name);
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            String name = this.nameText.getText();
            this.configSet.clear();
            this.configSet.setName(name);
            this.configSet.setOverrideEnabled(this.overrideButton.getSelection());
            this.configSet.setIncomplete(this.incompleteButton.getSelection());
            Object[] configs = this.configsViewer.getCheckedElements();
            int i = 0;
            while (i < configs.length) {
                this.configSet.addConfig((ConfigNode)configs[i]);
                ++i;
            }
            if (this.configSetName == null) {
                this.configSet.setParent(this.project);
                this.configSet.setOverrideEnabled(this.overrideButton.getSelection());
                this.configSet.setIncomplete(this.incompleteButton.getSelection());
            } else if (!this.configSetName.equals(name)) {
                this.project.removeConfigSet(this.configSetName);
            }
            this.project.addConfigSet(this.configSet);
        }
        super.buttonPressed(buttonId);
    }

    private List createConfigList() {
        ArrayList<ConfigNode> configs = new ArrayList<ConfigNode>(this.configSet.getConfigs());
        Iterator iter = this.project.getConfigs().iterator();
        while (iter.hasNext()) {
            ConfigNode config = (ConfigNode)iter.next();
            if (this.configSet.hasConfig(config.getName())) continue;
            configs.add(new ConfigNode(this.configSet, config.getName()));
        }
        IBeansModel model = BeansCorePlugin.getModel();
        try {
            IProject[] projects = this.project.getProject().getProject().getReferencedProjects();
            int i = 0;
            while (i < projects.length) {
                IBeansProject project = model.getProject(projects[i]);
                if (project != null) {
                    iter = project.getConfigs().iterator();
                    while (iter.hasNext()) {
                        IBeansConfig config = (IBeansConfig)iter.next();
                        String path = config.getConfigPath();
                        if (this.configSet.hasConfig(path)) continue;
                        configs.add(new ConfigNode(this.configSet, path));
                    }
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return configs;
    }

    private void validateName() {
        boolean isEnabled = false;
        String name = this.nameText.getText();
        if (name == null || name.trim().length() == 0) {
            this.errorLabel.setText(BeansUIPlugin.getResourceString(ERROR_INVALID_NAME));
        } else if (this.configSetName == null || !name.equals(this.configSetName)) {
            if (this.project.hasConfigSet(name)) {
                this.errorLabel.setText(BeansUIPlugin.getResourceString(ERROR_USED_NAME));
            } else {
                this.errorLabel.setText("");
                isEnabled = true;
            }
        } else {
            isEnabled = true;
        }
        this.okButton.setEnabled(isEnabled);
        this.errorLabel.getParent().update();
    }

    private class ConfigFilesContentProvider
    implements IStructuredContentProvider {
        private List configs;

        public ConfigFilesContentProvider(List configs) {
            this.configs = configs;
        }

        public Object[] getElements(Object obj) {
            return this.configs.toArray();
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        }

        public void dispose() {
        }
    }
}

