/*
 *  Part of the shrinkta program, a dvd copy tool
 *
 *  Copyright (C) 2005  Daryl Gray
 *  E-Mail Daryl Gray darylgray1@dodo.com.au
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <bonobo.h>
#include <gnome.h>

#include "dialogs.h"

GtkWidget *about = NULL;

static void
on_about_close		(GtkDialog	*dialog,
			 gint		 arg1,
			 gpointer	 user_data)
{
	gtk_widget_destroy (about);
	about = NULL;
}

void
show_about		(GtkWindow	*parent)
{
	const gchar *authors[] = {
		"Daryl Gray <darylgray1@dodo.com.au>",
		NULL
	};

	/* TRANSLATORS: Replace this string with your names, one name per line. */
	gchar *translators = _("translator_credits");
	GdkPixbuf *about_logo_pixbuf;
	GdkPixbuf *about_icon_pixbuf;
	static gchar *version = NULL;

	if (about != NULL) return;
	if (!strcmp (translators, "translator_credits"))
 		translators = NULL;
	about_logo_pixbuf = gdk_pixbuf_new_from_file ("/usr/share/pixmaps/shrinkta/shrinkta-icon.png", NULL);
	about = gtk_about_dialog_new ();
	gtk_window_set_transient_for (GTK_WINDOW (about), parent);
	if (version == NULL) {
		version = g_strdup_printf ("%s-%d", VERSION, LIBDVD_INTERFACE_AGE);
	}
	gtk_about_dialog_set_program_name (GTK_ABOUT_DIALOG (about), _("DVD Movie Backup"));
	gtk_about_dialog_set_version (GTK_ABOUT_DIALOG (about), version);
	gtk_about_dialog_set_copyright (GTK_ABOUT_DIALOG (about), "Copyright \xc2\xa9 2005-2008 Daryl Gray");
	gtk_about_dialog_set_comments (GTK_ABOUT_DIALOG (about), _("DVD movie backup tool for the GNOME desktop"));
	gtk_about_dialog_set_authors (GTK_ABOUT_DIALOG (about), authors);
	gtk_about_dialog_set_logo (GTK_ABOUT_DIALOG (about), about_logo_pixbuf);
	gtk_about_dialog_set_translator_credits (GTK_ABOUT_DIALOG (about), translators);
	gtk_about_dialog_set_license (GTK_ABOUT_DIALOG (about), _("DVD Movie Backup is free software; you can redistribute it and/or modify it under\n"
								  "the terms of the GNU General Public License as published by the Free\n"
								  "Software Foundation; either version 2 of the License, or (at your option)\n"
								  "any later version.\n\n"
								  "DVD Movie Backup is distributed in the hope that it will be useful, but WITHOUT\n"
        							  "ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or\n"
        							  "FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for\n"
        							  "more details.\n\n"
        							  "You should have received a copy of the GNU General Public License along with\n"
        							  "DVD Movie Backup if not, write to the\n\n"
        							  "Free Software Foundation, Inc.,\n"
        							  "51 Franklin St, Fifth Floor\n"
        							  "Boston, MA 02110-1301 USA"));
	gdk_pixbuf_unref (about_logo_pixbuf);
	gtk_window_set_destroy_with_parent (GTK_WINDOW (about), TRUE);
	about_icon_pixbuf = gdk_pixbuf_new_from_file ("/usr/share/pixmaps/shrinkta/shrinkta-icon.png", NULL);
	if (about_icon_pixbuf) {
		gtk_window_set_icon (GTK_WINDOW (about), about_icon_pixbuf);
		gdk_pixbuf_unref (about_icon_pixbuf);
	}
	g_signal_connect ((gpointer) about, "response",
			  G_CALLBACK (on_about_close),
			  NULL);
	gtk_widget_show (about);
}

gboolean
run_dialog_question	(GtkWindow	*parent,
			 const gchar	*question)
{
	GtkWidget *dialog_question;
	GtkWidget *dialog_vbox;
	GtkWidget *hbox;
	GtkWidget *image;
	GtkWidget *label_question;
	GtkWidget *dialog_action_area;
	GtkWidget *button_yes;
	GtkWidget *button_no;
	gint result;

	dialog_question = gtk_dialog_new ();
	gtk_window_set_transient_for (GTK_WINDOW (dialog_question), parent);
	gtk_window_set_title (GTK_WINDOW (dialog_question), _("Dvd Movie Backup - Question"));
	gtk_window_set_position (GTK_WINDOW (dialog_question), GTK_WIN_POS_CENTER_ON_PARENT);
	gtk_window_set_resizable (GTK_WINDOW (dialog_question), FALSE);
	gtk_window_set_destroy_with_parent (GTK_WINDOW (dialog_question), TRUE);
	gtk_window_set_skip_taskbar_hint (GTK_WINDOW (dialog_question), TRUE);
	gtk_window_set_skip_pager_hint (GTK_WINDOW (dialog_question), TRUE);
	gtk_window_set_type_hint (GTK_WINDOW (dialog_question), GDK_WINDOW_TYPE_HINT_DIALOG);

	dialog_vbox = GTK_DIALOG (dialog_question)->vbox;
	gtk_widget_show (dialog_vbox);
	
	hbox = gtk_hbox_new (FALSE, 6);
	gtk_widget_show (hbox);
	gtk_box_pack_start (GTK_BOX (dialog_vbox), hbox, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (hbox), 12);
	
	image = gtk_image_new_from_icon_name ("gtk-dialog-question", GTK_ICON_SIZE_DIALOG);
	gtk_widget_show (image);
	gtk_box_pack_start (GTK_BOX (hbox), image, FALSE, TRUE, 0);
	gtk_misc_set_alignment (GTK_MISC (image), 0.5, 0);
	
	label_question = gtk_label_new (question);
	gtk_widget_show (label_question);
	gtk_box_pack_start (GTK_BOX (hbox), label_question, TRUE, TRUE, 0);
	gtk_label_set_use_markup (GTK_LABEL (label_question), TRUE);
	gtk_misc_set_alignment (GTK_MISC (label_question), 0, 0.5);
	
	dialog_action_area = GTK_DIALOG (dialog_question)->action_area;
	gtk_widget_show (dialog_action_area);
	gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area), GTK_BUTTONBOX_END);
	
	button_yes = gtk_button_new_from_stock ("gtk-yes");
	gtk_widget_show (button_yes);
	gtk_dialog_add_action_widget (GTK_DIALOG (dialog_question), button_yes, GTK_RESPONSE_YES);
	  GTK_WIDGET_SET_FLAGS (button_yes, GTK_CAN_DEFAULT);
	
	button_no = gtk_button_new_from_stock ("gtk-no");
	gtk_widget_show (button_no);
	gtk_dialog_add_action_widget (GTK_DIALOG (dialog_question), button_no, GTK_RESPONSE_NO);
	GTK_WIDGET_SET_FLAGS (button_no, GTK_CAN_DEFAULT);

	gtk_widget_set_size_request (label_question, -1, -1);

	result = gtk_dialog_run (GTK_DIALOG (dialog_question));
	gtk_widget_destroy (dialog_question);
	switch (result) {
	case GTK_RESPONSE_YES:
		return TRUE;
		break;
	default:
		return FALSE;
		break;
	}
}

void
run_dialog_warning	(GtkWindow	*parent,
			 const gchar	*warning)
{
	GtkWidget *dialog_warning;
	GtkWidget *dialog_vbox;
	GtkWidget *hbox;
	GtkWidget *image;
	GtkWidget *label_warning;
	GtkWidget *dialog_action_area;
	GtkWidget *button_close;
	
	dialog_warning = gtk_dialog_new ();
	gtk_window_set_transient_for (GTK_WINDOW (dialog_warning), parent);
	gtk_window_set_title (GTK_WINDOW (dialog_warning), _("Dvd Movie Backup - Warning"));
	gtk_window_set_position (GTK_WINDOW (dialog_warning), GTK_WIN_POS_CENTER_ON_PARENT);
	gtk_window_set_resizable (GTK_WINDOW (dialog_warning), FALSE);
	gtk_window_set_destroy_with_parent (GTK_WINDOW (dialog_warning), TRUE);
	gtk_window_set_skip_taskbar_hint (GTK_WINDOW (dialog_warning), TRUE);
	gtk_window_set_skip_pager_hint (GTK_WINDOW (dialog_warning), TRUE);
	gtk_window_set_type_hint (GTK_WINDOW (dialog_warning), GDK_WINDOW_TYPE_HINT_DIALOG);
	
	dialog_vbox = GTK_DIALOG (dialog_warning)->vbox;
	gtk_widget_show (dialog_vbox);
	
	hbox = gtk_hbox_new (FALSE, 6);
	gtk_widget_show (hbox);
	gtk_box_pack_start (GTK_BOX (dialog_vbox), hbox, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (hbox), 12);
	
	image = gtk_image_new_from_icon_name ("gtk-dialog-warning", GTK_ICON_SIZE_DIALOG);
	gtk_widget_show (image);
	gtk_box_pack_start (GTK_BOX (hbox), image, FALSE, TRUE, 0);
	gtk_misc_set_alignment (GTK_MISC (image), 0.5, 0);
	
	label_warning = gtk_label_new (warning);
	gtk_widget_show (label_warning);
	gtk_box_pack_start (GTK_BOX (hbox), label_warning, TRUE, TRUE, 0);
	gtk_label_set_use_markup (GTK_LABEL (label_warning), TRUE);
	gtk_misc_set_alignment (GTK_MISC (label_warning), 0, 0.5);
	
	dialog_action_area = GTK_DIALOG (dialog_warning)->action_area;
	gtk_widget_show (dialog_action_area);
	gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area), GTK_BUTTONBOX_END);
	
	button_close = gtk_button_new_from_stock ("gtk-close");
	gtk_widget_show (button_close);
	gtk_dialog_add_action_widget (GTK_DIALOG (dialog_warning), button_close, GTK_RESPONSE_CLOSE);
	GTK_WIDGET_SET_FLAGS (button_close, GTK_CAN_DEFAULT);
	gtk_widget_set_size_request (dialog_warning, -1, -1);
	
	gtk_dialog_run (GTK_DIALOG (dialog_warning));
	gtk_widget_destroy (dialog_warning);
}

gboolean
run_shrinkta_dialog	(GtkWindow		*parent,
			 ShrinktaDialogType	 dialog_type)
{
	switch (dialog_type) {
	case SHRINKTA_DIALOG_TYPE_QUESTION_DELETE_IMAGE:
		
		/* This dialog asks if you want to keep a previously backed up DVD image */
		return run_dialog_question (parent,
					   _("<b>Do you want to delete the DVD disk image from your computer?</b>\n\n"
					     "Leaving the image on your computer will allow you to write additional\n"
					     "DVD's from the file, however, you must consider that each image file may\n"
					     "use up to 8.5GB of hard drive space.\n\n"
					     "Select <b><i>Yes</i></b> to delete the image, or,\n"
					     "<b><i>No</i></b> to leave the image on your computer."));
		break;
	case SHRINKTA_DIALOG_TYPE_QUESTION_WILL_FIT:
		
		/* This dialog asks if you want to make a full backup (or a title backup if you click no) */
		return run_dialog_question (parent,
					   _("<b>The DVD will fit on your blank DVD disk</b>\n\n"
					     "Do you wish to perform a full backup of the DVD?"));
		break;
	default:
		g_assert_not_reached ();
	}
}
