/*
 *  Part of the shrinkta program, a dvd backup tool
 *
 *  Copyright (C) 2005  Daryl Gray
 *  E-Mail Daryl Gray darylgray1@dodo.com.au
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
*/
/** $Revision: 1.01 $
 * Libdvd common header
 * @file dvd-audio.h DvdAudio object header file
 * @ingroup core
 *
 * libdvd
 */

#if !defined (__DVD_H_INSIDE__) && !defined (LIBDVD_COMPILATION)
#error "Only <dvd.h> can be included directly."
#endif

#ifndef __DVD_AUDIO_H__
#define __DVD_AUDIO_H__


G_BEGIN_DECLS


/* --- type macros --- */
#define DVD_AUDIO_TYPE		(dvd_audio_get_type())
#define DVD_AUDIO(o)		(G_TYPE_CHECK_INSTANCE_CAST (o, DVD_AUDIO_TYPE, DvdAudio))
#define DVD_AUDIO_CLASS(k)	(G_TYPE_CHECK_CLASS_CAST    (k, DVD_AUDIO_TYPE, DvdAudioClass))
#define DVD_IS_AUDIO(o)		(G_TYPE_CHECK_INSTANCE_TYPE (o, DVD_AUDIO_TYPE))
#define DVD_IS_AUDIO_CLASS(k)	(G_TYPE_CHECK_CLASS_TYPE    (k, DVD_AUDIO_TYPE))

/* --- typedefs & structures --- */
typedef struct	_DvdAudio	DvdAudio;
typedef struct	_DvdAudioClass	DvdAudioClass;

/** Maximum number of audio tracks allowed in dvd mpeg */
#define MAX_DVD_AUDIO_TRACKS 8

/** Audio stream format */
typedef enum _DvdAudioFormat {
	DVD_AUDIO_FORMAT_AC3,		/**< 2 to 6ch audio - up to 448bps */
	DVD_AUDIO_FORMAT_UNKNOWN1,	/**< ?? */
	DVD_AUDIO_FORMAT_MPEG1,	  	/**< 2ch audio - up to 384bps */
	DVD_AUDIO_FORMAT_MPEG2,		/**< 7.1ch audio - up to 912bps */
	DVD_AUDIO_FORMAT_LPCM,		/**< 1 to 8ch audio - up to 6144bps*/
	DVD_AUDIO_FORMAT_SDDS,		/**< 7.1ch audio - up to 1280bps [not in use] */
	DVD_AUDIO_FORMAT_DTS		/**< 5 to 6.1ch audio - up to 1536bps*/
} DvdAudioFormat;

/** Audio track purpose */
typedef enum _DvdAudioPurpose {
	DVD_AUDIO_PURPOSE_UNDEFINED,	/**< Audio purpose is undefined */
	DVD_AUDIO_PURPOSE_NORMAL,	/**< Audio purpose is normal */
	DVD_AUDIO_PURPOSE_IMPAIRED, 	/**< Audio purpose is for hearing impared?? */
	DVD_AUDIO_PURPOSE_COMMENTS1,	/**< Audio purpose is a comments track */
	DVD_AUDIO_PURPOSE_COMMENTS2,	/**< Audio purpose is a comments track */
	DVD_AUDIO_PURPOSE_UNKNOWN	/**< Audio purpose is currently an unknown type */
} DvdAudioPurpose;

/** Audio track purpose */
typedef enum _DvdAudioApplication {
	DVD_AUDIO_APPLICATION_UNDEFINED,	/**< Audio application is undefined */
	DVD_AUDIO_APPLICATION_NORMAL,		/**< Audio application is karaoke */
	DVD_AUDIO_APPLICATION_IMPAIRED 		/**< Audio application is surround */
} DvdAudioApplication;

/** Audio sample rate */
typedef enum _DvdAudioSamp {
	DVD_AUDIO_SAMP_48000,
	DVD_AUDIO_SAMP_96000,
	DVD_AUDIO_SAMP_44100,
	DVD_AUDIO_SAMP_32000
} DvdAudioSamp;

/** Audio quantinization */
typedef enum _DvdAudioQuant {
	DVD_AUDIO_QUANT_16BIT,
	DVD_AUDIO_QUANT_20BIT,
	DVD_AUDIO_QUANT_24BIT,
	DVD_AUDIO_QUANT_DRC,
} DvdAudioQuant;

struct _DvdAudio {
	GObject	        	parent;
	
	guint8	        	number;	    /**< Track number starting from 0 */
	guint8	        	channels;   /**< Number of channels in audio stream */
	DvdLanguage     	lang;	    /**< Audio stream language @see DvdLanguage */
	DvdAudioFormat 		format;     /**< Audio stream format @see DvdAudioFormat */
	DvdAudioPurpose 	purpose;    /**< Audio stream purpose @see DvdAudioPurpose */
	DvdAudioApplication	application;
	DvdAudioSamp    	samplerate; /**< Audio stream sample rate @see DvdAudioSamp */
	DvdAudioQuant   	quant;	    /**< Audio stream quantinization @see DvdAudioQuant */
};

struct _DvdAudioClass {
	GObjectClass	parent;
};

/* --- prototypes --- */
GType		dvd_audio_get_type		(void);
DvdAudio*	dvd_audio_new			(void);
void		dvd_audio_set_number		(DvdAudio	*audio,
						 guint8		 number);
guint8		dvd_audio_get_number		(DvdAudio	*audio);
void		dvd_audio_set_channels		(DvdAudio	*audio,
						 guint8		 channels);
guint8		dvd_audio_get_channels		(DvdAudio	*audio);
void		dvd_audio_set_lang		(DvdAudio	*audio,
						 DvdLanguage	 lang);
DvdLanguage	dvd_audio_get_lang		(DvdAudio	*audio);
void		dvd_audio_set_format		(DvdAudio	*audio,
						 DvdAudioFormat	 format);
DvdAudioFormat	dvd_audio_get_format		(DvdAudio	*audio);
void		dvd_audio_set_purpose		(DvdAudio	*audio,
						 DvdAudioPurpose purpose);
DvdAudioPurpose	dvd_audio_get_purpose		(DvdAudio	*audio);
void		    dvd_audio_set_application	(DvdAudio	     *audio,
						 DvdAudioApplication  application);
DvdAudioApplication dvd_audio_get_application	(DvdAudio	     *audio);
void		dvd_audio_set_samplerate	(DvdAudio	*audio,
						 DvdAudioSamp	 samplerate);
DvdAudioSamp	dvd_audio_get_samplerate	(DvdAudio	*audio);
void		dvd_audio_set_quant		(DvdAudio	*audio,
						 DvdAudioQuant	 quant);
DvdAudioQuant	dvd_audio_get_quant		(DvdAudio	*audio);

G_END_DECLS

#endif /*__DVD_AUDIO_H__*/
