/*
 * robloader.h
 * 
 * Copyright (c) 2000-2005 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

/** @file
  * Declares the RobLoader, which loads ROB files
  */

#ifndef __RT_ROBLOADER__
#define __RT_ROBLOADER__

#include <rtstring.h>
//#include <rtstreams.h>

#include "robbase.h"
#include "robvars.h"
#include "robdefines.h"

namespace rt {

/// Loads ROB files 
class RobLoader : public ProgramLoader {
public:
	// example constructor
	RobLoader(const ErrorHandler* handler);
	virtual ~RobLoader();

	virtual ProgramLoader* create(const lrt::String& filename, const Globals& glob);
	virtual bool canLoad(const lrt::String& filename);
	virtual lrt::String getFormatName();

protected:
	virtual LoadReturnType load();
	virtual LoadReturnType loadHeaders();

private:
	// we'll use it so often...
	typedef Instr::Op Op;

	// concrete constructor
	RobLoader(const RobLoader* example, const lrt::String& filename, const Globals& glob);
	bool isExample;

	lrt::StringMap<rint> labels;

	// converts our error to the generic ProgramLoader error
	LoadReturnType error(RobLoadReturnType num, DefineInputStream* in);

	/// after finishing, file position is before first "Bank" or "Define" in file
	RobLoadReturnType doLoadHeaders(DefineInputStream* in);
	RobLoadReturnType mkOldHeader(DefineInputStream* in, const lrt::String& name);
	RobLoadReturnType mkNewHeader(DefineInputStream* in, HeaderType type);

	RobLoadReturnType doLoad(DefineInputStream* in);
	RobLoadReturnType getLabels(DefineInputStream* in);
	RobLoadReturnType readOps(DefineInputStream* in, lrt::Array<Op>& ops, bool* dest);
	RobLoadReturnType convertParamDest(const lrt::String& word, Op& op);
	RobLoadReturnType convertParamSrc(const lrt::String& word, Op& op);
	// expects an EOL or EOF, there may only be comments or whitespace before it
	RobLoadReturnType expectEol(DefineInputStream* in); 
};



} // namespace

#endif

