/*
 * reportctrl.h
 * 
 * Copyright (c) 2000-2005 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

#ifndef __WXX_REPORTCTRL_H__
#define __WXX_REPORTCTRL_H__

#include <wx/listctrl.h>

#include "reportdata.h"

int wxCALLBACK wxReportCtrlCompareFunction(long, long, long);

class wxxReportCtrl : public wxListCtrl  
{
public:
	wxxReportCtrl();
	// takes ownership of data and images
	wxxReportCtrl(wxWindow* parent, wxWindowID id, wxxReportData* data, wxImageList* images = 0, 
		const wxString& configGroup = wxEmptyString, const wxPoint& pos = wxDefaultPosition, 
		const wxSize& size = wxDefaultSize, const wxValidator& validator = wxDefaultValidator, 
		const wxString& name = wxT("listCtrl"));
	~wxxReportCtrl();
	// takes ownership of data and images
	bool Create(wxWindow* parent, wxWindowID id, wxxReportData* data, wxImageList* images = 0, 
		const wxString& configGroup = wxEmptyString, const wxPoint& pos = wxDefaultPosition, 
		const wxSize& size = wxDefaultSize, const wxValidator& validator = wxDefaultValidator, 
		const wxString& name = wxT("listCtrl"));
	void SetData(wxxReportData* newData);

	// returns the first selected row, or -1 if there isn't any
	long GetSelectedRow();
	// returns all selected rows
	wxArrayLong GetSelectedRows();
	// stores column widths in global cfg
	bool StoreColumnWidths();

	// stores column widths when the control is un-displayed
	void OnCloseWindow(wxCloseEvent& event);

protected:
	wxxReportData* data;

	// @param initial If given, this method assumes that the columns are done for the first time.
	virtual bool DoColumns(bool initial = false);
	virtual bool DoRows(int start = 0, int end = -1);

	bool ReadColumnWidths();

	//DECLARE_EVENT_TABLE();

	friend class wxxReportData;
	friend int wxCALLBACK wxReportCtrlCompareFunction(long, long, long);

private:
	void OnColumnClicked(wxListEvent&);
	wxString configGroup;
};

#endif
