#include <wx/wx.h>
#include <wx/filename.h>

#include "package.h"



// Gets the absolute file name of the currently running executable. 
wxString wxxGetExecutableFileName()
{
	wxFileName execFile(wxTheApp->argv[0]);
	execFile.MakeAbsolute(wxGetCwd()); 
	return execFile.GetFullPath(); 
}

// Gets the absolute name of the folder in which the running executable is contained. 
// It is terminated with a wxFILE_SEP_PATH (usually a slash). 
wxString wxxGetExecutableFolder()
{
	wxFileName execFile(wxTheApp->argv[0]);
	execFile.MakeAbsolute(wxGetCwd()); 
	return execFile.GetPath(wxPATH_GET_VOLUME | wxPATH_GET_SEPARATOR);
}


// Search for something everywhere
// xfolder: subfolder where to look
wxString wxxFindSomething(const wxString& xfolder, const wxString& file) 
{
	wxString execFolder = wxxGetExecutableFolder(); 

	if(wxFileName(file).FileExists()) return file;

	if(wxFileName(execFolder + file).FileExists()) 
		return wxFileName(execFolder + file).GetFullPath();
	if(wxFileName(execFolder + xfolder + file).FileExists()) 
		return wxFileName(execFolder + xfolder + file).GetFullPath();

#ifdef EXTRA_DATA_DIR
	wxString extraDataDir = wxT(EXTRA_DATA_DIR); 
	if(extraDataDir.Last() != wxFILE_SEP_PATH)
		extraDataDir += wxFILE_SEP_PATH; 

	if(wxFileName(extraDataDir + xfolder + file).FileExists())
		return wxFileName(extraDataDir + xfolder + file).GetFullPath(); 
#endif

	return wxEmptyString; 
}


wxString wxxGetLanguageCode()
{
    wxLocale *pLoc = wxGetLocale();
    if (pLoc)
        return pLoc->GetCanonicalName();
    else
        return wxString(); 
}



// Finds a translated file. 
// Looks in the subfolders LANG_COUNTRY and LANG of the given package folder xfolder. 
wxString wxxFindTranslatedFile(const wxString& xfolder, const wxString& file)
{
	wxString lcode = wxxGetLanguageCode(); 
	if(lcode.Find('_') >= 0) { // fully specified language
		// search for it there
		wxString filen = wxxFindSomething(xfolder + lcode + wxFILE_SEP_PATH, file);
		if(filen.length())
			return filen; 

		// now shorten to short form of the language code (without country) 
		lcode = lcode.BeforeFirst('_'); 
	}
	if(lcode.length()) { // some language was specified
		wxString filen = wxxFindSomething(xfolder + lcode + wxFILE_SEP_PATH, file); 
		if(filen.length())
			return filen; 
	}
	// search for the default also 
	return wxxFindSomething(xfolder, file); 
}




// Finds a help file. 
// Returns the empty string if it cannot be found. 
// @param file The file name (without folders) of the help file, such as 'index.html'. 
wxString wxxFindHelpFile(const wxString& file)
{
	wxString filen = wxxFindTranslatedFile(wxString(wxT("help")) + wxFILE_SEP_PATH, file); 
#ifdef EXTRA_HELP_DIR
	wxString extraHelpDir = wxT(EXTRA_HELP_DIR); 
	if(extraHelpDir.Last() != wxFILE_SEP_PATH)
		extraHelpDir += wxFILE_SEP_PATH; 

	if(!filen.length()) {
		filen = wxxFindTranslatedFile(extraHelpDir, file); 
	}
#endif
	return filen; 
}



