/*
 * detview.h
 * 
 * Copyright (c) 2000-2005 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */
 
#ifndef __ROBOTOP_DETVIEW_H__
#define __ROBOTOP_DETVIEW_H__

#include <wx/wx.h>

#include "reportctrl.h"
#include "reportdata.h"
#include "inirepdata.h"
#include "dialogs.h"
#include "wxext.h" // bug fix

class DetailsReportData;
class TournamentFrame;
class TournamentEvent;

class DetailsFrame : public wxxMDIChildFrame
{
public:
	DetailsFrame(TournamentFrame* tour, wxMDIParentFrame *parent, const wxString& botname);
	~DetailsFrame();

	void CreateImageList();
	wxSizer* CreateInfoPanel(); // may return NULL if no info available
	wxMenuBar* CreateMenu();
	void InitToolBar(wxToolBar* toolBar);

	// event handlers (these functions should _not_ be virtual)
	void OnShowRobotInStatus(wxListEvent& event);
	void OnBrowser(wxCommandEvent& event);
	void OnDetails(wxCommandEvent& event);
	void OnDetailsList(wxListEvent& event) { OnDetails(event); }
	void OnRedisplay(wxCommandEvent& event);
	void OnTourUpdate(TournamentEvent& event);
	void OnTourClose(TournamentEvent& event);
	void OnCloseCommand(wxCommandEvent& event);
	void OnCloseWindow(wxCloseEvent& event);

private:
	TournamentFrame* tour;
    wxMDIParentFrame* parent;
	wxxReportCtrl* detailsList;
	wxImageList* imageList;
	DetailsReportData* detailsData;
	wxString botname;
	TourData configData;

	void Redisplay();

	// any class wishing to process wxWindows events must use this macro
	DECLARE_EVENT_TABLE();
};

//////////
enum DetailsFrameImageIndexes {
	dfiGood = 0,
	dfiBad = 1,
	dfiOld = 2,
	dfiNumImages
};

//////////

class DetailsReportData : public wxxIniReportData
{
public:
	DetailsReportData(const wxString& detailedIni);
	int GetImage(long row);
	// Here I'll load all the roy files - it's the best place 
	bool DoSectionCache();
	void ReadYFiles();
};


// IDs for the controls and the menu commands
enum
{
	// tool bar items
	DetFrame_Redisplay = 400,
	DetFrame_Details,
	DetFrame_Browser,
	DetFrame_List
};


#endif // file 

