/* sockets.h: this file is the header file for the tlm socket function
 *   library
 *
 *  Version: 2.10f
 *	Authors: Dr. Charles E. Campbell, GSFC/NASA
 *           Terry McRoberts, GSFC/NASA
 */
#ifndef _INC_SOCKETS_H
#define _INC_SOCKETS_H

#include <stdio.h>

/* --------------------------------------------------------------------------
 * Standard Include Section
 */
#if defined(__WIN32__) || defined(_MSC_VER)
# define SSLSKTZERO
# define close(s)        closesocket(s)
# define ioctl(s,c,a)    ioctlsocket(s, c, a)
# include <stdio.h>
# include <winsock2.h>
# include <wtypes.h>
  typedef unsigned short u_short;
# ifdef SSLNEEDTIME
#  include <time.h>
# endif
#endif

/* for Linux */
#if defined(__linux) || defined(__UNIX__)
# include <sys/types.h>
# include <sys/select.h>
# include <sys/socket.h>
# include <netinet/in.h>
# include <netinet/tcp.h>
# include <stdarg.h>
# include <netdb.h>
# include <unistd.h>
# include <stdio.h>
# ifdef SSLNEEDTIME
#  include <sys/time.h>
# endif
# ifndef __USE_BSD
  typedef unsigned short u_short;
#endif
#endif

#include "sockfunc.h"

#endif /* #ifndef SOCKETS_H */
