#ifndef __LRT_SOCKCHECK_H__
#define __LRT_SOCKCHECK_H__

// internal
#ifdef __cplusplus
extern "C" {
#endif

void mwFail(const char* message, const char* condition, const char* file, int line);

#ifdef __cplusplus
}
#endif

/// Exits the program, if a condition is not met. 
/// @param cond Condition to check
/// @param msg Message to show to the user, if condition fails. 
#define mwFailIf(cond, msg) if((cond)) { mwFail(msg, #cond, __FILE__, __LINE__); }



#endif // file



