/*
 * rtchar.cpp
 * 
 * Copyright (c) 2000-2005 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

// char.cpp: Implementierung der Klasse Char.
//
//////////////////////////////////////////////////////////////////////

#include "rtchar.h"
#include "rtmath.h"

namespace lrt {

const int Char::MAX_RADIX = 36;

bool Char::isDigit(char ch, int radix)
{
	if(((ch - '0') >= 0) && ((ch - '0') < Math::min(radix, 10))) 
		return true;
	if(radix > 10)
		if(isLetter(ch))
		{
			int nv = lowerCase(ch) - 'a';
			if((nv >= 0) && (nv < (radix - 10)))
				return true;
		}
	return false;
}

/// private, so they're never called
Char::Char()
{

}

Char::~Char()
{

}

} // namespace

