/****************************************************************************
** TemplateWizard class
**
**   Created : Mon May 23 12:09:08 2005
**        by : Varol Okan using kate editor
** Copyright : (c) Varol Okan
** License   : GPL v 2.0
**
** This class allows the user to choose a template and simply fillin the 
** blanks.
**
** Templates are stored under :
** /usr/share/qdvdauthor/templates/static/<tmpltdir>
** /usr/share/qdvdauthor/templates/movie/<tmpltdir>
** - each template has its own tmpltdir
** - each tmpltdir has a preview.jpg OR preview.mpg
** - each tmpltdir has a template.xml file, which describes the template.
**
****************************************************************************/

#ifndef TEMPLATEWIZARD_H
#define TEMPLATEWIZARD_H

#include <qframe.h>
#include <qlistbox.h>
#include <qtooltip.h>

#include "uitemplatewizard.h"

class TemplateWizard;
class MediaInterface;
class DVDMenu;

// This class was derived to have the mouseClick and drop events covered
class TemplateFrame : public QFrame
{
	Q_OBJECT
public:
	TemplateFrame ( TemplateWizard *, QWidget *p=0, const char *n=0, WFlags f=0 );
	virtual ~TemplateFrame ();

protected:
	virtual void dropEvent     (QDropEvent *);
	virtual void dragEnterEvent(QDragEnterEvent *);

protected slots:
	void mouseReleaseEvent ( QMouseEvent * );

signals:
	void signalMouseReleaseEvent (QMouseEvent *);
private:
	TemplateWizard *m_pTemplateWizard;
};

class ListBoxToolTip : public QToolTip 
{
public:
	ListBoxToolTip(QListBox *);
	virtual ~ListBoxToolTip () {};

	virtual void maybeTip(const QPoint &);
protected:
	QListBox* m_pListBox;
};

class TemplateWizard : public uiTemplateWizard
{
	Q_OBJECT

public:
	class DropZone
	{
		 DropZone ();
	public:
		 enum { IgnoreObject, ImageObject, MovieObject, TextObject, FrameObject };
		 DropZone (int, QString, QRect, QString);
 		~DropZone ();

		int      iNumber;	// Counter, of which DropZone we have ... E.g. 1
		int      iType;         // MovieObject, TextObject, FrameObject or ImageObject
		bool     bMovie;	// Is this a movie Source ?
		QString  qsText;	// E.g "Movie 1" used for ???
		QRect    rect;
		QString  qsFileName;
		QString  qsImagePreview;
		QPixmap *pPixmap;
	};

	 TemplateWizard( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
	~TemplateWizard();

	void initMe             ( );
	void droppedSomething   ( QDropEvent * );
	void showDialog         ( );

protected:
	void initTab (QString, QIconView * );
	void initPreview                  ( );
	void initDragList                 ( );
	void refreshBackground            ( );
	void refreshComboMenu             ( );
	void handleMenuAudio              ( );
	QString getSourceEntryName( QString );
	QString readProjectFile   ( QString, bool );
	void adjustPixmapHeight   ( QPixmap *, QString & );
	void refreshMovieButtons  ( DVDMenu * );

protected slots:
	virtual void slotTemplateClicked   (QMouseEvent   *);
	virtual void slotListBoxClicked    (QListBoxItem  *);
	virtual void slotIconViewClicked   (QIconViewItem *);
	virtual void slotTargetMenuChanged (const QString &);
	virtual void slotPlaybackFinished  ( );
	virtual void slotTemplateDetails   ( );
	virtual void next     ( );
	virtual void reject   ( );
	virtual void accept   ( );
	virtual void hide     ( );
	virtual void slotHelp ( );

private:
	TemplateFrame           *m_pFrameProperties;
	MediaInterface          *m_pMediaInterface;
	ListBoxToolTip          *m_pListBoxToolTip;
	bool                     m_bDontRestart;
	bool                     m_bLocalTemplate;

	QValueList<DVDMenu *>    m_listDVDMenus;
	QString                  m_qsPathName;
	QValueList<DropZone *>   m_listDropZones;
	QString                  m_qsXMLDVDMenu;
	QString                  m_qsCurrentTemplate;
	QString                  m_qsTemplateVersion;
	QString                  m_qsTemplateAuthor;
	QString                  m_qsTemplateContact;
	QString                  m_qsTemplateHeader;
	QString                  m_qsTemplateDescription;
	QString                  m_qsTemplateComment;

	float                    m_fScale;
	QStringList              m_listSourceFileDescriptions;
};

#endif // TEMPLATEWIZARD_H
