/****************************************************************************
** FilePreviewDialog - class
**
**   Created : Tue Jan 05 12:09:08 2006
**        by : Varol Okan using XEmacs
** Copyright : (c) Varol Okan
**   License : GPL v 2.0
**
** This class is creates an openFileDialog and presents a preview of
** Image, and Video files.
**
**
****************************************************************************/
 
#ifndef FILEPREVIEWDIALOG_H
#define FILEPREVIEWDIALOG_H

#include <qstringlist.h>
#include <qfiledialog.h>
#include <qlabel.h>

class MediaInterface;

class FilePreviewDialog : public QLabel, public QFilePreview
{
  Q_OBJECT
public: 
           FilePreviewDialog ( void *e=NULL, QWidget *p=NULL );
  virtual ~FilePreviewDialog ( );

  virtual void previewUrl ( const QUrl &theUrl );

  // This is a drop in replacement for QFileDialog::getOpenFileName, including a preview ( Image or Video )
  static QString getOpenFileName  ( void          *m=NULL,          // pointer to existing media engine
				    const QString &s=QString::null, // Start in dir
				    const QString &f=QString::null, // filter
				    QWidget       *p=NULL,          // Parent
				    const char    *n=NULL,          // name
				    const QString &c=QString::null, // Caption
				    QString       *e=0,             // selected Filter
				    bool           o=true );        // resolve symlinks

  static QStringList getOpenFileNames   ( void    *m=NULL,          // pointer to existing media engine
				    const QString &s=QString::null, // Start in dir
				    const QString &f=QString::null, // filter
				    QWidget       *p=NULL,          // Parent
				    const char    *n=NULL,          // name
				    const QString &c=QString::null, // Caption
				    QString       *e=0,             // selected Filter
				    bool           o=TRUE );        // resolve symlinks

  static QStringList getOpenFileNames   ( 
				    const QString &s=QString::null, // Start in dir
				    const QString &f=QString::null, // filter
				    QWidget       *p=NULL,          // Parent
				    const char    *n=NULL,          // name
				    const QString &c=QString::null, // Caption
				    QString       *e=0,             // selected Filter
				    bool           o=TRUE );        // resolve symlinks

protected slots:
  virtual void slotSetPreview ( );

private:
  MediaInterface *m_pMediaInterface;
  bool            m_bSetupPreview;
  QString         m_qsPath;
};

#endif	// FILEPREVIEWDIALOG_H
