/* GraphListElementPopupMenu.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.worksheet.actions;

import be.ugent.caagt.swirl.lists.TypedListModel;

import java.awt.Component;
import java.util.ResourceBundle;
import javax.swing.JPopupMenu;
import javax.swing.ListSelectionModel;

import org.grinvin.list.graphs.GraphListElement;
import org.grinvin.list.actions.RenameAction;
import org.grinvin.list.actions.GraphRenamePanel;

/**
 *
 */
public class GraphListElementPopupMenu extends JPopupMenu {
    
    //
    private RenameAction rAction;
    
    //
    private ShowGraphPropertiesAction sAction;
    
    //
    private InvalidateGraphBundleCacheAction iAction;
    
    //
    public GraphListElementPopupMenu(TypedListModel<GraphListElement> list, ListSelectionModel selection) {
        this.sAction = new ShowGraphPropertiesAction();
        this.iAction = new InvalidateGraphBundleCacheAction();
        this.rAction = new RenameAction<GraphListElement>(list, selection, new GraphRenamePanel(), ResourceBundle.getBundle("org.grinvin.worksheet.actions.resources"), "renameGraphListElement.description");
        add(rAction);
        add(sAction);
        add(iAction);
    }
    
    //
    public void show(GraphListElement[] graphListElements, Component invoker, int x, int y) {
        rAction.setParent(invoker);
        sAction.setGraphListElements(graphListElements);
        iAction.setGraphListElements(graphListElements);
        show(invoker, x, y);
    }
}
