/* GraphGeneratorInstanceListLoader.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.io.list;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.grinvin.generators.graphs.GraphGeneratorInstance;
import org.grinvin.generators.graphs.GraphGeneratorInstanceManager;
import org.grinvin.generators.graphs.UnknownGraphGeneratorInstanceException;
import org.grinvin.io.IOFormatException;
import org.grinvin.io.LoaderSaverHelper;
import org.grinvin.list.generators.GraphGeneratorInstanceList;

import org.jdom.Document;
import org.jdom.Element;

/**
 *
 */
public class GraphGeneratorInstanceListLoader {
    
    //
    private static final String PUBLIC_ID = "-//GrInvIn IO//GeneratorList 1.0//EN";
    
    //
    private GraphGeneratorInstanceListLoader() { }
    
    //
    private static final Logger LOGGER = Logger.getLogger("org.grinvin.io");
    
    //
    private static void load(GraphGeneratorInstanceList list, Element element) {
        for (Object obj: element.getChildren("instance")) {
            try {
                Element child = (Element)obj;
                GraphGeneratorInstance generator = GraphGeneratorInstanceManager.getInstance().getGraphGeneratorInstance(child.getAttributeValue("id"));
                list.add(generator);
            } catch (UnknownGraphGeneratorInstanceException ex) {
                LOGGER.log(Level.WARNING, "Ignored unknown generator {0}", ex.getId());
                // ignore unknown generators
            }
        }
    }
    
    public static void load(GraphGeneratorInstanceList list, InputStream input) throws IOException {
        Document document = LoaderSaverHelper.loadDocument(input);
        if (!PUBLIC_ID.equals(document.getDocType().getPublicID()))
            throw new IOFormatException("Unkown document type: " + document.getDocType().getPublicID() + " expects " + PUBLIC_ID);
        load(list, document.getRootElement());
    }
    
}
