/* Graph.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.graphs;

/**
 * <p>
 * A mutable version of {@link GraphView}. Provides methods to add and remove
 * vertices and edges in the graph.
 * </p>
 */
public interface Graph extends GraphView {
    
    /**
     * Create a new vertex and add it to the graph. The index of this
     * newly created vertex should be equal to the number of vertices
     * in the graph before that vertex was added.
     * @return the newly created vertex.
     */
    public Vertex addNewVertex();
    
    /**
     * Add a new edge to the graph which joins the given (existing) vertices.
     * @throws IllegalArgumentException when the stated endpoints do not
     * both already belong to the graph.
     * @return the newly created edge.
     */
    public Edge addNewEdge(Vertex firstEndpoint, Vertex secondEndpoint);
    
    /**
     * Remove the given vertex from the graph. Also removes all
     * edges incident with this vertex. Removing a vertex makes its index negative
     * and may change the indices of other vertices in the same graph.
     */
    public void remove(Vertex v);
    
    /**
     * Remove the given edge from the graph.
     */
    public void remove(Edge e);
    
    /**
     * Remove all vertices and all edges from this graph.
     */
    public void clear();
    
    /**
     * Make this graph a copy of the given view. Corresponding vertices will have
     * the same index in the copy as in the original. This graph will be cleared
     * prior to the copy operation.
     */
    public void copy(GraphView original);
    
}
