/***************************************************************************
 *   Copyright (C) 2003-2005 by Kevin Hessels                              *
 *   khessels@shaw.ca                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KFOLDINGQUEUEWIDGET_H
#define KFOLDINGQUEUEWIDGET_H

#include <qdatetime.h>
#include <qpixmap.h>

#include <klistview.h>

class KProcess;

class kfoldingQueueItem : public QObject, public KListViewItem
{
public:
	kfoldingQueueItem( QListView *parent = 0, const QStringList& lines = 0L );
	virtual ~kfoldingQueueItem();

protected:
	virtual int compare( QListViewItem *i, int col, bool ascending ) const;

private:
	void parse( const QStringList& );
	
	QPixmap _icon;
	QString _index;
	QString	_projectName;
	QString	_unit;
	QString _pph;
	QString _speed;
	QString _status;
	QString _benchmark;
	QDateTime _begin;
	QDateTime _due;
};


class kfoldingQueueWidget : public KListView
{

Q_OBJECT

signals:
	void populated();

public:
	kfoldingQueueWidget(QWidget *parent = 0, const char *name = 0, const QString& workingDir = QString::null );
	virtual ~kfoldingQueueWidget();
	
	
private:
	KProcess* _qdProcess;
	QString _outputBuffer;
	bool	_populated;	

	void populate();

	int calculateHeight();
	
private slots:
	void slotReadQD( KProcess*, char*, int );
	void slotQDExited( KProcess* );
	
};

#endif
