package jfractionlab.worksheets;

import java.io.File;
import java.util.ArrayList;


public class WSGDivision extends WorkSheetGenerator{
	private ArrayList<ExerciseMultDivision> al_exercises;

	public WSGDivision(File exerciseFile, File solutionFile, int max){
		super(lang.Messages.getString("div_fr_by_fr"), WorkSheetGenerator.ONE_COLUMN);
		if (max == 10 || max == 100){
			al_exercises = new ArrayList<ExerciseMultDivision>();
			al_solutionLine = new ArrayList<String>();
			mkExercises(nb_of_exercises, max);
			generateText();
			writeFile(
					exerciseFile,
					al_exercisesText,
					true
			);
			writeFile(
					solutionFile,
					al_solutionsText,
					false
			);
		}else{
			throw new IllegalArgumentException( "max has to be 10 or 100" );
		}
	}//Constructor
	
	protected void mkExercises(int nb, int max){
		for (int i = 0; i<nb; i++){
			al_exercises.add(new ExerciseMultDivision(max));
		}//for
	}//mkFractions
	
	@Override
	protected String writeOneLine(boolean isExercise, int nb){
		String strReturn = "";
		n1 = al_exercises.get(nb).getN1();
		d1 = al_exercises.get(nb).getD1();
		n2 = al_exercises.get(nb).getN2();
		d2 = al_exercises.get(nb).getD2();

		if(isExercise){
			strReturn = String.valueOf((nb+1));
			strReturn += "&";
			strReturn += "$\\frac{"+n1+"}{"+d1+"}";
			strReturn += " \\div ";
			strReturn += "\\frac{"+n2+"}{"+d2+"}$";
			strReturn += " =\\\\";
		}else{
			strReturn = String.valueOf((nb+1));
			strReturn += "&";
			strReturn += "$\\frac{"+n1+"}{"+d1+"}";
			strReturn += " \\div ";
			strReturn += "\\frac{"+n2+"}{"+d2+"}$";
			strReturn += " = ";
			int p;
			p=n2;
			n2=d2;
			d2=p;
			strReturn += "$\\frac{"+n1+"}{"+d1+"}";
			strReturn += " \\cdot ";
			strReturn += "\\frac{"+n2+"}{"+d2+"}$";
			strReturn += " = ";
			strReturn += writeReduction();
			strReturn += "$\\frac{"+(n1*n2)+"}{"+(d1*d2)+"}$";
			al_solutionLine.add("$\\frac{"+(n1*n2)+"}{"+(d1*d2)+"}$");
			strReturn += "\\\\";
		}
		return strReturn;
	}
}//class
