package jfractionlab.jflDialogs;


import info.clearthought.layout.TableLayout;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;


import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRadioButton;

import jfractionlab.JFractionLab;
import jfractionlab.worksheets.WSGExtending;



public class WorkSheetDialogExtending extends WorkSheetDialog{
	static final long serialVersionUID = JFractionLab.serialVersionUID;
	
	private JLabel lbFractionNumbersText = new JLabel();
	private JLabel lbFactorNumbersText = new JLabel();
	private ButtonGroup btngrp_FractionNumbers = new ButtonGroup();
	private JRadioButton rb_fraction_10 = new JRadioButton("0 - 10");
	private JRadioButton rb_fraction_100 = new JRadioButton("0 - 100");
	private ButtonGroup btngrp_FactorNumbers = new ButtonGroup();
	private JRadioButton rb_factor_10 = new JRadioButton("0 - 10");
	private JRadioButton rb_factor_100 = new JRadioButton("0 - 100");
	
	public WorkSheetDialogExtending(){
		super(true);
		lbTitle.setText(
				lang.Messages.getString("worksheets")+" : "+
				lang.Messages.getString("extend_fractions")
		);
		
		double sizes_numbers[][] = {{
			5,
			TableLayout.FILL,
			TableLayout.FILL,
			5
		},{
			5,
			TableLayout.FILL,
			TableLayout.FILL,
			TableLayout.FILL,
			5
		}}; //Spalten / Zeilen
		pnOptions.setLayout(new TableLayout(sizes_numbers));
		pnOptions.setBorder(BorderFactory.createEtchedBorder());
		lbFractionNumbersText = new JLabel(
				lang.Messages.getString("range_of_numbers")+" : "+
				lang.Messages.getString("fractions"));
		pnOptions.add(lbFractionNumbersText, "1,1");
		pnOptions.add(rb_fraction_10, "1,2");
		pnOptions.add(rb_fraction_100, "1,3");
			btngrp_FractionNumbers.add(rb_fraction_10);
			btngrp_FractionNumbers.add(rb_fraction_100);
			rb_fraction_10.setSelected(true);
		lbFactorNumbersText = new JLabel(
				lang.Messages.getString("range_of_numbers")+" : "+
				lang.Messages.getString("factors"));
		pnOptions.add(lbFactorNumbersText, "2,1");
		pnOptions.add(rb_factor_10, "2,2");
		pnOptions.add(rb_factor_100, "2,3");
			btngrp_FactorNumbers.add(rb_factor_10);
			btngrp_FactorNumbers.add(rb_factor_100);
			rb_factor_10.setSelected(true);			
			
		content.add(pnOptions, "1,3,2,3");
		
		setLocation(150, 150);
		setSize(500,300);
		setResizable(true);
		setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		pack();
		setVisible(true);
	}
	
	private void okAction(){
		if(filesAreCreatedSuccessfully(jtfFile.getText())){
			setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
			if(rb_fraction_10.isSelected()){
				if(rb_factor_10.isSelected()){
					new WSGExtending(exerciseFile, solutionsFile, 10,10);
				}else if(rb_factor_100.isSelected()){
					new WSGExtending(exerciseFile, solutionsFile, 10,100);
				}
			}else if (rb_fraction_100.isSelected()){
				if(rb_factor_10.isSelected()){
					new WSGExtending(exerciseFile, solutionsFile, 100,10);
				}else if(rb_factor_100.isSelected()){
					new WSGExtending(exerciseFile, solutionsFile, 100,100);
				}
			}
//			setCursor(null);
			close();
		}else{
			jtfFile.setText(System.getProperty("user.home")
					+System.getProperty("file.separator")
			);
		}
	}
	
	@Override
	public void actionPerformed(ActionEvent e) {
		Object obj = e.getSource();
		if (obj == btnCancel){
				close();
		}else if(obj == btnOK){
			okAction();
		}else if (obj == btnChooseFile){
			jtfFile.setText(chooseFileName());
		}
	}
	
	@Override
	public void keyPressed(KeyEvent event){
		int key = event.getKeyCode();
		Object obj = event.getSource();
		if(key == KeyEvent.VK_ENTER && obj == btnCancel){
			close();
		}else if(key == KeyEvent.VK_ENTER && obj == btnOK){
			okAction();
		}else if(key == KeyEvent.VK_ENTER && obj == jtfFile){
			okAction();
		}
	}
}