package jfractionlab.jflDialogs;


import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.JFrame;

import jfractionlab.JFractionLab;
import jfractionlab.worksheets.WSGAddition;

public class WorkSheetDialogAddition extends WorkSheetDialog{
	static final long serialVersionUID = JFractionLab.serialVersionUID;

	public WorkSheetDialogAddition(){
		super(false);
		lbTitle.setText(
				lang.Messages.getString("worksheets")+" : "+
				lang.Messages.getString("add_fractions")
		);
		setLocation(150, 150);
		setSize(500,300);
		setResizable(true);
		setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		pack();
		setVisible(true);
	}
	
	private void okAction(){
		if(filesAreCreatedSuccessfully(jtfFile.getText())){
			setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
			new WSGAddition(exerciseFile, solutionsFile);
			setCursor(null);
			close();
		}else{
			jtfFile.setText(System.getProperty("user.home")
					+System.getProperty("file.separator")
			);
		}
	}
	
	@Override
	public void actionPerformed(ActionEvent e) {
		Object obj = e.getSource();
		if (obj == btnCancel){
				close();
		}else if(obj == btnOK){
			okAction();
		}else if (obj == btnChooseFile){
			jtfFile.setText(chooseFileName());
		}
	}
	@Override
	public void keyPressed(KeyEvent event){
		int key = event.getKeyCode();
		Object obj = event.getSource();
		if(key == KeyEvent.VK_ENTER && obj == btnCancel){
			close();
		}else if(key == KeyEvent.VK_ENTER && obj == btnOK){
			okAction();
		}else if(key == KeyEvent.VK_ENTER && obj == jtfFile){
			okAction();
		}
	}
}