/* 
 * cx25840 - register map 
 *
 * This file is auto generated do not edit. 
 *
 * There are non obvoius relationships between values.
 *
 * Submit errors in this file to the ivtv development mail list.
 *
 */
#ifndef __CX25840_REGISTERS_H
#define __CX25840_REGISTERS_H
#include <asm/types.h>
#include "cx25840-settings.h"

typedef enum { RC, RO, RR, RW, SC, VO } cx25840_setting_type;
extern __u16 cx25840_register_info[];
extern char *cx25840_register_name[];
extern __u8 cx25840_register_default[];

typedef struct {
	unsigned int value;
	char *name;
} value_map;

typedef struct {
	__u32 location;		// bit0-8 reg 9-11 start 12-16 len 17-20 type
	__u32 default_value;
	char *name;
	value_map *mapping;
	char *description;
} cx25840_setting_entry;
extern cx25840_setting_entry cx25840_settings[];

#define CX25840_REGISTER_ADDRESS(i) (cx25840_register_info[(i)]&0x0fff)
#define CX25840_REGISTER_TYPE(i)    (cx25840_register_info[(i)]>>12)
#define CX25840_REGISTER_NAME(i)    (cx25840_register_name[(i)])
#define CX25840_REGISTER_DEFAULT(i) (cx25840_register_default[(i)])

#define CX25840_SETTING_REGISTER_INDEX(i) ((cx25840_settings[(i)].location>>0)&0x01ff)
#define CX25840_SETTING_START_BIT(i)      ((cx25840_settings[(i)].location>>9)&0x0007)
#define CX25840_SETTING_BIT_LENGTH(i)     ((cx25840_settings[(i)].location>>12)&0x001f)
#define CX25840_SETTING_TYPE(i)           ((cx25840_settings[(i)].location>>17)&0x000f)
#define CX25840_SETTING_DEFAULT_VALUE(i)  (cx25840_settings[(i)].default_value)
#define CX25840_SETTING_NAME(i)           (cx25840_settings[(i)].name)
#define CX25840_SETTING_MAPPING(i)        (cx25840_settings[(i)].mapping)
#define CX25840_SETTING_DESCRIPTION(i)    (cx25840_settings[(i)].description)

typedef enum {
	Host_Register_1,
	Host_Register_2,
	Device_ID_Low_Byte,
	Device_ID_High_Byte,
	Configuration,
	Video_Input_Control,
	AFE_Control_1,
	AFE_Control_2,
	AFE_Control_3,
	AFE_Control_4,
	Video_PLL_Integer,
	Video_PLL_Divider,
	Aux_PLL_Integer,
	Aux_PLL_Divider,
	Video_PLL_Fractional_1,
	Video_PLL_Fractional_2,
	Video_PLL_Fractional_3,
	Video_PLL_Fractional_4,
	Aux_PLL_Fractional_1,
	Aux_PLL_Fractional_2,
	Aux_PLL_Fractional_3,
	Aux_PLL_Fractional_4,
	Pin_Control_1,
	Pin_Control_2,
	Pin_Control_3,
	Pin_Control_4,
	Pin_Control_5,
	Pin_Control_6,
	Pin_Configuration_1,
	Pin_Configuration_2,
	Pin_Configuration_3,
	Pin_Configuration_4,
	Pin_Configuration_5,
	Pin_Configuration_6,
	Pin_Configuration_7,
	Pin_Configuration_8,
	Pin_Configuration_9,
	Pin_Configuration_10,
	Pin_Configuration_11,
	Pin_Configuration_12,
	Video_Count_Low,
	Video_Count_Mid,
	Video_Count_High,
	Audio_Lock,
	Audio_Count_Low,
	Audio_Count_Mid,
	Audio_Lock_2,
	Audio_Lock_3,
	Power_Control_1,
	Power_Control_2,
	AFE_Diagnostic_Control_1,
	AFE_Diagnostic_Control_2,
	AFE_Diagnostic_Control_3,
	AFE_Diagnostic_Control_5,
	AFE_Diagnostic_Control_6,
	AFE_Diagnostic_Control_7,
	AFE_Diagnostic_Control_8,
	PLL_Diagnostic_Control_1,
	PLL_Diagnostic_Control_2,
	DLL1_Diagnostic_Control_2,
	DLL1_Diagnostic_Control_3,
	DLL1_Diagnostic_Control_4,
	DLL2_Diagnostic_Control_1,
	DLL2_Diagnostic_Control_2,
	DLL2_Diagnostic_Control_3,
	DLL2_Diagnostic_Control_4,
	IR_Control_1,
	IR_Control_2,
	IR_TX_Clock_Divider_Low,
	IR_TX_Clock_Divider_High,
	IR_RX_Clock_Divider_Low,
	IR_RX_Clock_Divider_High,
	IR_TX_Carrier_Duty_Cycle,
	IR_Status,
	IR_Interrupt_Enable,
	IR_Low_Pass_Filter_Low,
	IR_Low_Pass_Filter_High,
	IR_FIFO_Low,
	IR_FIFO_High,
	IR_FIFO_Level,
	Video_Mode_Control_1,
	Video_Mode_Control_2,
	Video_Mode_Control_3,
	Video_Mode_Control_4,
	Video_Out_Control_1,
	Video_Out_Control_2,
	Video_Out_Control_3,
	Video_Out_Control_4,
	Ancillary_IDID_0,
	Ancillary_IDID_1,
	Ancillary_IDID_0_1,
	Ancillary_Audio_Output_Control,
	Copy_Protection_Status,
	General_Status_1,
	General_Status_2,
	Interrupt_Status_1,
	Interrupt_Status_2,
	Interrupt_Mask_1,
	Interrupt_Mask_2,
	Brightness,
	Contrast,
	Luma_Control,
	Horizontal_Scaling_Low,
	Horizontal_Scaling_Mid,
	Horizontal_Scaling_High,
	Horizontal_Scaling_Control,
	Vertical_Scaling_Low,
	Vertical_Scaling_High,
	Vertical_Scaling_Control,
	Vertical_Line_Control,
	Saturation_U,
	Saturation_V,
	Hue,
	Chroma_Control,
	VBI_Line_Control_1,
	VBI_Line_Control_2,
	VBI_Line_Control_3,
	VBI_Line_Control_4,
	VBI_Line_Control_5,
	VBI_Line_Control_6,
	VBI_Line_Control_7,
	VBI_Line_Control_8,
	VBI_Line_Control_9,
	VBI_Line_Control_10,
	VBI_Line_Control_11,
	VBI_Line_Control_12,
	VBI_Line_Control_13,
	VBI_Line_Control_14,
	VBI_Line_Control_15,
	VBI_Line_Control_16,
	VBI_Line_Control_17,
	VBI_Frame_Code_Search_Mode,
	VBI_Alternate_Frame_Code_Type,
	VBI_Alternate_1_Frame_Code,
	VBI_Alternate_2_Frame_Code,
	VBI_Miscellaneous_Config_1,
	TTX_Packet_Address_1,
	TTX_Packet_Address_2,
	TTX_Packet_Address_3,
	VBI_1_and_2_SDID,
	VBI_3_SDID,
	VBI_FIFO_Reset,
	VBI_Hamming,
	Closed_Caption_Status,
	Closed_Caption_Data,
	GEMSTAR_1x_Status,
	GEMSTAR_1x_Data,
	GEMSTAR_2x_Status,
	GEMSTAR_2x_Data,
	WSS_Status,
	WSS_Data,
	VBI_Custom_1_Horizontal_Delay,
	VBI_Custom_1_Bit_Increment,
	VBI_Custom_1_Slice_Distance,
	VBI_Custom_1_Clock_Run_in_Window,
	VBI_Custom_1_Frame_Code_Low,
	VBI_Custom_1_Frame_Code_Mid,
	VBI_Custom_1_Frame_Code_High,
	VBI_Custom_1_Frame_Code_Length,
	VBI_Custom_1_Clock_Run_in_Period,
	VBI_Custom_1_Clock_Run_in_Margin_and_Length,
	VBI_Custom_1_Payload_Length,
	VBI_Custom_1_Miscellaneous,
	VBI_Custom_2_Horizontal_Delay,
	VBI_Custom_2_Bit_Increment,
	VBI_Custom_2_Slice_Distance,
	VBI_Custom_2_Clock_Run_In_Window,
	VBI_Custom_2_Frame_Code_Low,
	VBI_Custom_2_Frame_Code_Mid,
	VBI_Custom_2_Frame_Code_High,
	VBI_Custom_2_Frame_Code_Length,
	VBI_Custom_2_Clock_Run_in_Period,
	VBI_Custom_2_Clock_Run_in_Margin_and_Length,
	VBI_Custom_2_Payload_Length,
	VBI_Custom_2_Miscellaneous,
	VBI_Custom_3_Horizontal_Delay,
	VBI_Custom_3_Bit_Increment,
	VBI_Custom_3_Slice_Distance,
	VBI_Custom_3_Clock_Run_in_Window,
	VBI_Custom_3_Frame_Code_Low,
	VBI_Custom_3_Frame_Code_Mid,
	VBI_Custom_3_Frame_Code_High,
	VBI_Custom_3_Frame_Code_Length,
	VBI_Custom_3_Clock_Run_in_Period,
	VBI_Custom_3_Clock_Run_in_Margin_and_Length,
	VBI_Custom_3_Payload_Length,
	VBI_Custom_3_Miscellaneous,
	Horizontal_Blanking_Delay_Low,
	Horizontal_Blanking_Delay_High,
	Horizontal_Active_High,
	Burst_Gate_Delay,
	Vertical_Blanking_Delay_Low,
	Vertical_Blanking_Delay_High,
	Vertical_Active_High,
	Vertical_Blanking_Delay_656,
	SRC_Decimation_Ratio_Low,
	SRC_Decimation_Ratio_High,
	Comb_Filter_Bandwidth_Select,
	Comb_Filter_Enable,
	Subcarrier_Step_Size_Low,
	Subcarrier_Step_Size_Mid,
	Subcarrier_Step_Size_High,
	VBI_Offset,
	Field_Count_Low,
	Field_Count_High,
	Temporal_Decimation,
	Miscellaneous_Timing_Control,
	Video_Detect_Configuration,
	VGA_Gain_Control,
	AGC_Gain_Control_Low,
	AGC_Gain_Control_High,
	Digital_Front_End_Control,
	VGA_Sync_Control,
	VGA_Track_Range,
	VGA_Acquire_Range,
	DFE_Control,
	Backporch_Loop_Gain,
	DFT_Threshold,
	Backporch_Percent,
	PLL_Offset_Low,
	PLL_Offset_High,
	PLL_Indirect_Loop_Gain,
	PLL_Direct_Loop_Gain,
	Horizontal_Tracking_Loop_Indirect_Gain,
	Luma_Comb_Error_Limit_Max,
	Luma_Comb_Threshold,
	Chroma_Comb_Error_Limit_Max,
	Comb_Phase_Limit_Max,
	White_Crush_Increment,
	White_Crush_Decrement,
	White_Crush_Comparison_Point,
	Soft_Reset_Mask_1,
	Soft_Reset_Mask_2,
	Version_ID,
	Miscellaneous_Diagnostic_Control,
	Download_Address_Low_Byte,
	Download_Address_High_Byte,
	Download_Data_Control,
	Download_Control,
	Mode_Detect_Status_0,
	Mode_Detect_Status_1,
	Audio_Configuration,
	Preferred_Decode_Mode,
	Embedded_Microcontroller_Video_Format,
	Audio_Format_Control_0,
	Soft_Reset,
	Audio_Interrupt_Control,
	Audio_Interrupt_Status,
	Analog_AGC_Hysteresis1,
	Analog_AGC_Hysteresis2,
	Analog_AGC_Control,
	AFE_12DB_ENABLE,
	IF_SRC_Mode,
	Phase_Fix_Control,
	Dematrix_Bypass,
	Dematrix_Select_Control,
	Digital_Audio_Input_Shifter,
	Path1_Audio_Select_Control,
	Path1_AVC_Control1,
	Path1_AVC_Control2,
	Mute_Control,
	Path1_Volume,
	Path1_Balance,
	Path1_AVC_Threshold_Low,
	Path1_AVC_Threshold_High,
	Path1_EQ_Band_Select,
	Path1_EQ_Bass_Adjust,
	Path1_EQ_Midrange_Adjust,
	Path1_EQ_Treble_Adjust,
	Path1_Soft_Clip_Control1,
	Path1_Soft_Clip_Control2,
	Path1_Soft_Clip_Threshold_Low,
	Path1_Soft_Clip_Threshold_High,
	Path2_Audio_Select_Control,
	Path2_AVC_Control1,
	Path2_AVC_Control2,
	Path2_Mute_Control,
	Path2_Volume,
	Path2_Balance,
	Path2_AVC_Threshold_Low,
	Path2_AVC_Threshold_High,
	Path2_EQ_Band_Select,
	Path2_EQ_Bass_Adjust,
	Path2_EQ_Midrange_Adjust,
	Path2_EQ_Treble_Adjust,
	Path2_Soft_Clip_Control1,
	Path2_Soft_Clip_Control2,
	Path2_Soft_Clip_Threshold_Low,
	Path2_Soft_Clip_Threshold_High,
	Sample_Rate_Converter_Status1,
	Sample_Rate_Converter_Status2,
	Sample_Rate_Converter_Status3,
	SRC1_Phase_Increment_Low,
	SRC1_Phase_Increment_Mid,
	SRC1_Phase_Increment_High,
	SRC1_FIFO_Read_Threshold,
	SRC2_Phase_Increment_Low,
	SRC2_Phase_Increment_Mid,
	SRC2_Phase_Increment_High,
	SRC2_FIFO_Read_Threshold,
	SRC3_Phase_Increment_Low,
	SRC3_Phase_Increment_Mid,
	SRC3_Phase_Increment_High,
	SRC3_FIFO_Read_Threshold,
	SRC4_Phase_Increment_Low,
	SRC4_Phase_Increment_Mid,
	SRC4_Phase_Increment_High,
	SRC4_FIFO_Read_Threshold,
	SRC5_Phase_Increment_Low,
	SRC5_Phase_Increment_Mid,
	SRC5_Phase_Increment_High,
	SRC5_FIFO_Read_Threshold,
	SRC6_Phase_Increment_Low,
	SRC6_Phase_Increment_Mid,
	SRC6_Phase_Increment_High,
	SRC6_FIFO_Read_Threshold,
	Output_SRC_Source_Select,
	Baseband_Bypass_Control,
	Input_SRC_Source_Select1,
	Input_SRC_Source_Select2,
	Serial_Audio_Input_Control1,
	Serial_Audio_Input_Control2,
	Serial_Audio_Output_Control1,
	Serial_Audio_Output_Control2,
	AC97_Shutdown,
	AC97_Wake_Up,
	AC97_Reset,
	AC97_Upsample_Bypass,
	ACL_Control_0,
	Space_Holder_Dummy,
	Space_Holder_Dummy_UNIQ1,
	Space_Holder_Dummy_UNIQ2,
	ACL_Control_1,
	Space_Holder_Dummy_UNIQ3,
	Space_Holder_Dummy_UNIQ4,
	Space_Holder_Dummy_UNIQ5,
	ACL_Control_2,
	Space_Holder_Dummy_UNIQ6,
	Space_Holder_Dummy_UNIQ7,
	Space_Holder_Dummy_UNIQ8,
	ACL_Control_3,
	Space_Holder_Dummy_UNIQ9,
	Space_Holder_Dummy_UNIQ10,
	Space_Holder_Dummy_UNIQ11,
	ACL_Command,
	Space_Holder_Dummy_UNIQ12,
	Space_Holder_Dummy_UNIQ13,
	ACL_GPIO_Output_Data,
	Space_Holder_Dummy_UNIQ14,
	ACL_GPIO_Input_Data,
	Space_Holder_Dummy_UNIQ15,
	ACL_Status_Slot_Interface,
	Space_Holder_Dummy_UNIQ16,
	Space_Holder_Dummy_UNIQ17,
	ACL_Warm_Reset,
	Space_Holder_Dummy_UNIQ18,
	Space_Holder_Dummy_UNIQ19,
	ACL_Tag,
	Space_Holder_Dummy_UNIQ20,
	Space_Holder_Dummy_UNIQ21,
	Space_Holder_Dummy_UNIQ22,
	RDS_I_Low,
	RDS_I_High,
	RDS_Q_Low,
	number_of_registers
} cx25840_register;

#endif /* __CX25840_REGISTERS_H */
