/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.variantcontext;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class InferredGeneticContext {
    public static final double NO_NEG_LOG_10PERROR = -1.0;
    private static Set<String> NO_FILTERS = Collections.unmodifiableSet(new HashSet());
    private static Map<String, Object> NO_ATTRIBUTES = Collections.unmodifiableMap(new HashMap());
    private double negLog10PError = -1.0;
    private String name = null;
    private Set<String> filters = NO_FILTERS;
    private Map<String, Object> attributes = NO_ATTRIBUTES;

    public InferredGeneticContext(String name, double negLog10PError, Set<String> filters, Map<String, ?> attributes) {
        this.name = name;
        this.setNegLog10PError(negLog10PError);
        if (filters != null) {
            this.setFilters(filters);
        }
        if (attributes != null) {
            this.setAttributes(attributes);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null " + this);
        }
        this.name = name;
    }

    public Set<String> getFilters() {
        return Collections.unmodifiableSet(this.filters);
    }

    public boolean isFiltered() {
        return this.filters.size() > 0;
    }

    public boolean isNotFiltered() {
        return !this.isFiltered();
    }

    public void addFilter(String filter) {
        if (this.filters == NO_FILTERS) {
            this.filters = new HashSet<String>(this.filters);
        }
        if (filter == null) {
            throw new IllegalArgumentException("BUG: Attempting to add null filter " + this);
        }
        if (this.getFilters().contains(filter)) {
            throw new IllegalArgumentException("BUG: Attempting to add duplicate filter " + filter + " at " + this);
        }
        this.filters.add(filter);
    }

    public void addFilters(Collection<String> filters) {
        if (filters == null) {
            throw new IllegalArgumentException("BUG: Attempting to add null filters at" + this);
        }
        for (String f : filters) {
            this.addFilter(f);
        }
    }

    public void clearFilters() {
        this.filters = new HashSet<String>();
    }

    public void setFilters(Collection<String> filters) {
        this.clearFilters();
        this.addFilters(filters);
    }

    public boolean hasNegLog10PError() {
        return this.getNegLog10PError() != -1.0;
    }

    public double getNegLog10PError() {
        return this.negLog10PError;
    }

    public double getPhredScaledQual() {
        return this.getNegLog10PError() * 10.0;
    }

    public void setNegLog10PError(double negLog10PError) {
        if (negLog10PError < 0.0 && negLog10PError != -1.0) {
            throw new IllegalArgumentException("BUG: negLog10PError cannot be < than 0 : " + negLog10PError);
        }
        if (Double.isInfinite(negLog10PError)) {
            throw new IllegalArgumentException("BUG: negLog10PError should not be Infinity");
        }
        if (Double.isNaN(negLog10PError)) {
            throw new IllegalArgumentException("BUG: negLog10PError should not be NaN");
        }
        this.negLog10PError = negLog10PError;
    }

    public void clearAttributes() {
        this.attributes = new HashMap<String, Object>();
    }

    public Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public void setAttributes(Map<String, ?> map) {
        this.clearAttributes();
        this.putAttributes(map);
    }

    public void putAttribute(String key, Object value) {
        this.putAttribute(key, value, false);
    }

    public void putAttribute(String key, Object value, boolean allowOverwrites) {
        if (!allowOverwrites && this.hasAttribute(key)) {
            throw new IllegalStateException("Attempting to overwrite key->value binding: key = " + key + " this = " + this);
        }
        if (this.attributes == NO_ATTRIBUTES) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(key, value);
    }

    public void removeAttribute(String key) {
        if (this.attributes == NO_ATTRIBUTES) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.remove(key);
    }

    public void putAttributes(Map<String, ?> map) {
        if (map != null) {
            if (this.attributes.size() == 0) {
                if (this.attributes == NO_ATTRIBUTES) {
                    this.attributes = new HashMap<String, Object>();
                }
                this.attributes.putAll(map);
            } else {
                for (Map.Entry<String, ?> elt : map.entrySet()) {
                    this.putAttribute(elt.getKey(), elt.getValue(), false);
                }
            }
        }
    }

    public boolean hasAttribute(String key) {
        return this.attributes.containsKey(key);
    }

    public int getNumAttributes() {
        return this.attributes.size();
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public Object getAttribute(String key, Object defaultValue) {
        if (this.hasAttribute(key)) {
            return this.attributes.get(key);
        }
        return defaultValue;
    }

    public String getAttributeAsString(String key) {
        return String.valueOf(this.getAttribute(key));
    }

    public int getAttributeAsInt(String key) {
        Object x = this.getAttribute(key);
        return x instanceof Integer ? (Integer)x : Integer.valueOf((String)x);
    }

    public double getAttributeAsDouble(String key) {
        Object x = this.getAttribute(key);
        return x instanceof Double ? (Double)x : Double.valueOf((String)x);
    }

    public boolean getAttributeAsBoolean(String key) {
        Object x = this.getAttribute(key);
        return x instanceof Boolean ? (Boolean)x : Boolean.valueOf((String)x);
    }

    public String getAttributeAsString(String key, String defaultValue) {
        return (String)this.getAttribute(key, defaultValue);
    }

    public int getAttributeAsInt(String key, int defaultValue) {
        return (Integer)this.getAttribute(key, defaultValue);
    }

    public double getAttributeAsDouble(String key, double defaultValue) {
        return (Double)this.getAttribute(key, defaultValue);
    }

    public boolean getAttributeAsBoolean(String key, boolean defaultValue) {
        return (Boolean)this.getAttribute(key, defaultValue);
    }

    public Integer getAttributeAsIntegerNoException(String key) {
        try {
            return this.getAttributeAsInt(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Double getAttributeAsDoubleNoException(String key) {
        try {
            return this.getAttributeAsDouble(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getAttributeAsStringNoException(String key) {
        if (this.getAttribute(key) == null) {
            return null;
        }
        return this.getAttributeAsString(key);
    }

    public Boolean getAttributeAsBooleanNoException(String key) {
        try {
            return this.getAttributeAsBoolean(key);
        }
        catch (Exception e) {
            return null;
        }
    }
}

