/*
 * Copyright (c) 2007-2010 by The Broad Institute, Inc. and the Massachusetts Institute of Technology.
 * All Rights Reserved.
 *
 * This software is licensed under the terms of the GNU Lesser General Public License (LGPL), Version 2.1 which
 * is available at http://www.opensource.org/licenses/lgpl-2.1.php.
 *
 * THE SOFTWARE IS PROVIDED "AS IS." THE BROAD AND MIT MAKE NO REPRESENTATIONS OR WARRANTIES OF
 * ANY KIND CONCERNING THE SOFTWARE, EXPRESS OR IMPLIED, INCLUDING, WITHOUT LIMITATION, WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR THE ABSENCE OF LATENT
 * OR OTHER DEFECTS, WHETHER OR NOT DISCOVERABLE.  IN NO EVENT SHALL THE BROAD OR MIT, OR THEIR
 * RESPECTIVE TRUSTEES, DIRECTORS, OFFICERS, EMPLOYEES, AND AFFILIATES BE LIABLE FOR ANY DAMAGES OF
 * ANY KIND, INCLUDING, WITHOUT LIMITATION, INCIDENTAL OR CONSEQUENTIAL DAMAGES, ECONOMIC
 * DAMAGES OR INJURY TO PROPERTY AND LOST PROFITS, REGARDLESS OF WHETHER THE BROAD OR MIT SHALL
 * BE ADVISED, SHALL HAVE OTHER REASON TO KNOW, OR IN FACT SHALL KNOW OF THE POSSIBILITY OF THE
 * FOREGOING.
 */

/*
 * LegendDialog.java
 *
 * Created on March 21, 2008, 2:10 AM
 */
package org.broad.igv.ui.legend;

import org.broad.igv.track.TrackType;
import org.broad.igv.ui.util.UIUtilities;

/**
 * @author jrobinso
 */
public class LegendDialog extends javax.swing.JDialog {

    /**
     * Creates new form LegendDialog
     */
    public LegendDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        ((LegendPanel) copyNoCanvas).setTrackType(TrackType.COPY_NUMBER);
        ((LegendPanel) expressionCanvas).setTrackType(TrackType.GENE_EXPRESSION);
        ((LegendPanel) methylationCanvas).setTrackType(TrackType.DNA_METHYLATION);
        ((LohLegendPanel) lohCanvas).setTrackType(TrackType.LOH);
        setLocationRelativeTo(parent);
    }

    /**
     * This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        okButton = new javax.swing.JButton();
        cnLabel = new javax.swing.JLabel();
        copyNoCanvas = new org.broad.igv.ui.legend.HeatmapLegendPanel(TrackType.COPY_NUMBER);
        jLabel1 = new javax.swing.JLabel();
        legendLabel1 = new javax.swing.JLabel();
        methylationCanvas = new HeatmapLegendPanel(TrackType.DNA_METHYLATION);
        lohCanvas = new LohLegendPanel();
        legendLabel2 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        expressionCanvas = new HeatmapLegendPanel(TrackType.GENE_EXPRESSION);
        mutationCanvas = new MutationLegendPanel();
        legendLabel3 = new javax.swing.JLabel();
        resetToDefault = new javax.swing.JButton();
        jLabel3 = new javax.swing.JLabel();
        legendLabel4 = new javax.swing.JLabel();
        rnaiPanel = new HeatmapLegendPanel(TrackType.RNAI);

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);

        okButton.setText("OK");
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });

        cnLabel.setText("Copy Number");

        org.jdesktop.layout.GroupLayout copyNoCanvasLayout = new org.jdesktop.layout.GroupLayout(copyNoCanvas);
        copyNoCanvas.setLayout(copyNoCanvasLayout);
        copyNoCanvasLayout.setHorizontalGroup(
                copyNoCanvasLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                        .add(0, 512, Short.MAX_VALUE)
        );
        copyNoCanvasLayout.setVerticalGroup(
                copyNoCanvasLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                        .add(0, 53, Short.MAX_VALUE)
        );

        jLabel1.setFont(new java.awt.Font("Lucida Sans", 1, 18));
        jLabel1.setText("Legends");

        legendLabel1.setText("Expression");

        methylationCanvas.setMinimumSize(new java.awt.Dimension(100, 100));

        org.jdesktop.layout.GroupLayout methylationCanvasLayout = new org.jdesktop.layout.GroupLayout(methylationCanvas);
        methylationCanvas.setLayout(methylationCanvasLayout);
        methylationCanvasLayout.setHorizontalGroup(
                methylationCanvasLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                        .add(0, 512, Short.MAX_VALUE)
        );
        methylationCanvasLayout.setVerticalGroup(
                methylationCanvasLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                        .add(0, 53, Short.MAX_VALUE)
        );

        org.jdesktop.layout.GroupLayout lohCanvasLayout = new org.jdesktop.layout.GroupLayout(lohCanvas);
        lohCanvas.setLayout(lohCanvasLayout);
        lohCanvasLayout.setHorizontalGroup(
                lohCanvasLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                        .add(0, 512, Short.MAX_VALUE)
        );
        lohCanvasLayout.setVerticalGroup(
                lohCanvasLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                        .add(0, 24, Short.MAX_VALUE)
        );

        legendLabel2.setText("LOH");

        jLabel2.setText("Methylation");

        org.jdesktop.layout.GroupLayout expressionCanvasLayout = new org.jdesktop.layout.GroupLayout(expressionCanvas);
        expressionCanvas.setLayout(expressionCanvasLayout);
        expressionCanvasLayout.setHorizontalGroup(
                expressionCanvasLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                        .add(0, 512, Short.MAX_VALUE)
        );
        expressionCanvasLayout.setVerticalGroup(
                expressionCanvasLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                        .add(0, 53, Short.MAX_VALUE)
        );

        org.jdesktop.layout.GroupLayout mutationCanvasLayout = new org.jdesktop.layout.GroupLayout(mutationCanvas);
        mutationCanvas.setLayout(mutationCanvasLayout);
        mutationCanvasLayout.setHorizontalGroup(
                mutationCanvasLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                        .add(0, 512, Short.MAX_VALUE)
        );
        mutationCanvasLayout.setVerticalGroup(
                mutationCanvasLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                        .add(0, 49, Short.MAX_VALUE)
        );

        legendLabel3.setText("Mutation");

        resetToDefault.setText("Reset to default");
        resetToDefault.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                resetToDefaultActionPerformed(evt);
            }
        });
        resetToDefault.addAncestorListener(new javax.swing.event.AncestorListener() {
            public void ancestorMoved(javax.swing.event.AncestorEvent evt) {
            }

            public void ancestorAdded(javax.swing.event.AncestorEvent evt) {
            }

            public void ancestorRemoved(javax.swing.event.AncestorEvent evt) {
                resetToDefaultAncestorRemoved(evt);
            }
        });

        jLabel3.setText("<html>* click any item to bring up its editor");

        legendLabel4.setText("RNAi");

        org.jdesktop.layout.GroupLayout rnaiPanelLayout = new org.jdesktop.layout.GroupLayout(rnaiPanel);
        rnaiPanel.setLayout(rnaiPanelLayout);
        rnaiPanelLayout.setHorizontalGroup(
                rnaiPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                        .add(0, 512, Short.MAX_VALUE)
        );
        rnaiPanelLayout.setVerticalGroup(
                rnaiPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                        .add(0, 53, Short.MAX_VALUE)
        );

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
                layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                        .add(layout.createSequentialGroup()
                                .addContainerGap()
                                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                        .add(cnLabel)
                                        .add(legendLabel3))
                                .add(58, 58, 58)
                                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                        .add(copyNoCanvas, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                        .add(expressionCanvas, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                                .addContainerGap(124, Short.MAX_VALUE))
                        .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                                .addContainerGap(394, Short.MAX_VALUE)
                                .add(okButton)
                                .add(137, 137, 137)
                                .add(resetToDefault)
                                .add(67, 67, 67))
                        .add(layout.createSequentialGroup()
                                .add(133, 133, 133)
                                .add(lohCanvas, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .addContainerGap(155, Short.MAX_VALUE))
                        .add(layout.createSequentialGroup()
                                .add(133, 133, 133)
                                .add(mutationCanvas, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .addContainerGap(155, Short.MAX_VALUE))
                        .add(layout.createSequentialGroup()
                                .addContainerGap()
                                .add(legendLabel2)
                                .addContainerGap(753, Short.MAX_VALUE))
                        .add(layout.createSequentialGroup()
                                .addContainerGap()
                                .add(jLabel3, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 249, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .addContainerGap(531, Short.MAX_VALUE))
                        .add(layout.createSequentialGroup()
                                .addContainerGap()
                                .add(legendLabel1)
                                .addContainerGap(711, Short.MAX_VALUE))
                        .add(layout.createSequentialGroup()
                                .add(327, 327, 327)
                                .add(jLabel1)
                                .addContainerGap(395, Short.MAX_VALUE))
                        .add(layout.createSequentialGroup()
                                .addContainerGap()
                                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                        .add(layout.createSequentialGroup()
                                                .add(144, 144, 144)
                                                .add(methylationCanvas, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                                        .add(layout.createSequentialGroup()
                                        .add(jLabel2)
                                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 582, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                                .addContainerGap(124, Short.MAX_VALUE))
                        .add(layout.createSequentialGroup()
                        .addContainerGap()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                .add(layout.createSequentialGroup()
                                        .add(144, 144, 144)
                                        .add(rnaiPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                                .add(layout.createSequentialGroup()
                                .add(legendLabel4)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 625, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                        .addContainerGap(124, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
                layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                        .add(layout.createSequentialGroup()
                        .add(24, 24, 24)
                        .add(jLabel1)
                        .add(18, 18, 18)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.CENTER)
                                .add(cnLabel)
                                .add(copyNoCanvas, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                        .add(23, 23, 23)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.CENTER)
                                .add(legendLabel1)
                                .add(expressionCanvas, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                        .add(18, 18, 18)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.CENTER)
                                .add(legendLabel4)
                                .add(rnaiPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                        .add(25, 25, 25)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.CENTER)
                                .add(jLabel2)
                                .add(methylationCanvas, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 53, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                .add(layout.createSequentialGroup()
                                        .add(78, 78, 78)
                                        .add(legendLabel2))
                                .add(layout.createSequentialGroup()
                                .add(70, 70, 70)
                                .add(lohCanvas, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                .add(layout.createSequentialGroup()
                                        .add(46, 46, 46)
                                        .add(legendLabel3))
                                .add(layout.createSequentialGroup()
                                .add(27, 27, 27)
                                .add(mutationCanvas, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                        .add(31, 31, 31)
                        .add(jLabel3)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 12, Short.MAX_VALUE)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                                .add(okButton)
                                .add(resetToDefault))
                        .add(39, 39, 39))
        );

        layout.linkSize(new java.awt.Component[]{copyNoCanvas, expressionCanvas, methylationCanvas}, org.jdesktop.layout.GroupLayout.VERTICAL);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
        setVisible(false);
    }//GEN-LAST:event_okButtonActionPerformed

    private void resetToDefaultActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_resetToDefaultActionPerformed

        String message = "This will reset all heatmap preferences to their default values.\n" +
                "Are you sure you want to continue?";

        boolean status = UIUtilities.showConfirmationDialog(this, message);
        if (status) {

            ((LegendPanel) copyNoCanvas).resetPreferencesToDefault();
            ((LegendPanel) expressionCanvas).resetPreferencesToDefault();
            ((LegendPanel) rnaiPanel).resetPreferencesToDefault();
            ((LegendPanel) lohCanvas).resetPreferencesToDefault();
            ((LegendPanel) methylationCanvas).resetPreferencesToDefault();
            ((LegendPanel) mutationCanvas).resetPreferencesToDefault();
        }
    }//GEN-LAST:event_resetToDefaultActionPerformed

    private void resetToDefaultAncestorRemoved(javax.swing.event.AncestorEvent evt) {//GEN-FIRST:event_resetToDefaultAncestorRemoved
        // TODO add your handling code here:
    }//GEN-LAST:event_resetToDefaultAncestorRemoved

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {
                LegendDialog dialog = new LegendDialog(new javax.swing.JFrame(), true);
                dialog.addWindowListener(new java.awt.event.WindowAdapter() {

                    public void windowClosing(java.awt.event.WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel cnLabel;
    private javax.swing.JPanel copyNoCanvas;
    private javax.swing.JPanel expressionCanvas;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel legendLabel1;
    private javax.swing.JLabel legendLabel2;
    private javax.swing.JLabel legendLabel3;
    private javax.swing.JLabel legendLabel4;
    private javax.swing.JPanel lohCanvas;
    private javax.swing.JPanel methylationCanvas;
    private javax.swing.JPanel mutationCanvas;
    private javax.swing.JButton okButton;
    private javax.swing.JButton resetToDefault;
    private javax.swing.JPanel rnaiPanel;
    // End of variables declaration//GEN-END:variables
}
