/*
 * Copyright (c) 2007-2010 by The Broad Institute, Inc. and the Massachusetts Institute of Technology.
 * All Rights Reserved.
 *
 * This software is licensed under the terms of the GNU Lesser General Public License (LGPL), Version 2.1 which
 * is available at http://www.opensource.org/licenses/lgpl-2.1.php.
 *
 * THE SOFTWARE IS PROVIDED "AS IS." THE BROAD AND MIT MAKE NO REPRESENTATIONS OR WARRANTIES OF
 * ANY KIND CONCERNING THE SOFTWARE, EXPRESS OR IMPLIED, INCLUDING, WITHOUT LIMITATION, WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR THE ABSENCE OF LATENT
 * OR OTHER DEFECTS, WHETHER OR NOT DISCOVERABLE.  IN NO EVENT SHALL THE BROAD OR MIT, OR THEIR
 * RESPECTIVE TRUSTEES, DIRECTORS, OFFICERS, EMPLOYEES, AND AFFILIATES BE LIABLE FOR ANY DAMAGES OF
 * ANY KIND, INCLUDING, WITHOUT LIMITATION, INCIDENTAL OR CONSEQUENTIAL DAMAGES, ECONOMIC
 * DAMAGES OR INJURY TO PROPERTY AND LOST PROFITS, REGARDLESS OF WHETHER THE BROAD OR MIT SHALL
 * BE ADVISED, SHALL HAVE OTHER REASON TO KNOW, OR IN FACT SHALL KNOW OF THE POSSIBILITY OF THE
 * FOREGOING.
 */

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.renderer;

import org.apache.log4j.Logger;
import org.broad.igv.feature.Feature;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.track.FeatureTrack;

import java.awt.*;
import java.util.HashMap;
import java.util.List;

/**
 * @author jrobinso
 */
public abstract class FeatureRenderer implements Renderer {

    boolean overlayMode = false;

    private static Color defaultColor = new Color(0, 0, 150);

    final HashMap<Color, Graphics2D> graphicCacheByColor = new HashMap<Color, Graphics2D>();

    /**
     * Return the pixel position corresponding to the chromosomal position.
     */
    private static Logger log = Logger.getLogger(FeatureRenderer.class);

    private Feature highlightFeature = null;


    public void setOverlayMode(boolean overlayMode) {
        this.overlayMode = overlayMode;
    }

    public boolean getOverlayMode() {
        return overlayMode;
    }


    /**
     * Render a border.  By default does nothing.
     *
     * @param track
     * @param context
     * @param rect
     */
    public void renderBorder(Track track, RenderContext context, Rectangle rect) {

    }

    /**
     * Render a Y axis.  By default does nothing.
     *
     * @param track
     * @param context
     * @param rect
     */
    public void renderAxis(Track track, RenderContext context, Rectangle rect) {

    }

    public Color getDefaultColor() {
        return defaultColor;
    }

    public abstract void renderFeatures(List<Feature> features, RenderContext context,
                                        Rectangle rect, FeatureTrack track);

    public Feature getHighlightFeature() {
        return highlightFeature;
    }

    public void setHighlightFeature(Feature highlightFeature) {
        this.highlightFeature = highlightFeature;
    }
}
