/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.controller;

import com.amazonaws.services.auth.identity.cli.common.Utils;
import com.amazonaws.services.auth.identity.cli.controller.IAMDriver;
import com.amazonaws.services.auth.identity.cli.model.CLIRequest;
import com.amazonaws.services.auth.identity.cli.model.GroupGetRequest;
import com.amazonaws.services.identitymanagement.model.GetGroupRequest;
import com.amazonaws.services.identitymanagement.model.GetGroupResult;
import com.amazonaws.services.identitymanagement.model.User;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class IAMGroupGetDriver
extends IAMDriver {
    private static final Log LOG = LogFactory.getLog(IAMGroupGetDriver.class);

    protected void invokeRequestImpl(CLIRequest request) {
        if (request instanceof GroupGetRequest) {
            GroupGetRequest req = (GroupGetRequest)request;
            LOG.debug((Object)("Getting group " + req));
            GetGroupRequest getGroupRequest = new GetGroupRequest();
            getGroupRequest.setGroupName(req.getGroupName());
            GetGroupResult result = this.getClient().getGroup(getGroupRequest);
            LOG.info((Object)result.getGroup().getArn());
            LOG.info((Object)result.getGroup().getGroupId());
            LOG.info((Object)"\tUsers:");
            for (User user : result.getUsers()) {
                LOG.info((Object)("\t" + user.getArn()));
            }
        } else {
            Utils.exit(1, "request " + request + " is of an incorrect type.", null);
        }
    }
}

