#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <glob.h>
#include <math.h>

#include "tcprobe.h"
#include "interface.h"

#define DIRECTVIDEO 0
#define PROCESSVIDEO 1
#define DIRECTAUDIO 2
#define PROCESSAUDIO 3

interface_struct interface;
output_config_struct output_config;
extern tcprobe_data_struct tcprobe_data;

GtkWidget * create_main_window(void){
	/* main layout */
	GtkWidget *mainWindow;
	GtkWidget *mainVbox;
	GtkWidget *mainHbox;
	GtkWidget *transcodeCommandLine;
	GtkWidget *progressBar;


	/* menu bar */
	GtkWidget *filemenuitem;
	GtkWidget *aboutmenuitem;
	GtkWidget *item;
	GtkWidget *menu;
	GtkWidget *menubar;

	/* left side */
	GtkWidget *leftMainVbox;
	GtkWidget *inputFrame;
	GtkWidget *leftVbox;
	GtkWidget *inputFileHbox;
	GtkWidget *inputAudioFileHbox;
	GtkWidget *probedFrame;

	GtkWidget *inputVideoLabel;
	GtkWidget *inputVideoEntry;
	GtkWidget *inputVideoButton;

	GtkWidget *inputAudioLabel;
	GtkWidget *inputAudioEntry;
	GtkWidget *inputAudioButton;

	GtkWidget *importModuleHbox;
	GtkWidget *importModuleLabel;
	GtkWidget *importModuleCombo;
	GList *importModuleOptions = NULL;

	GtkWidget *importFramesHbox;
	GtkWidget *importFramesLabel;
	GtkWidget *importFramesEntry;

	GtkWidget *probedLabel;

	GtkWidget *fileSizeFrame;
	GtkWidget *fileSizeVbox;

	GtkWidget *fileSizeVideoHbox;
	GtkWidget *fileSizeVideoLabel;
	GtkWidget *fileSizeVideoInfo;
	GtkWidget *fileSizeVideoOverheadHbox;
	GtkWidget *fileSizeVideoOverheadLabel;
	GtkWidget *fileSizeVideoOverheadInfo;
	GtkWidget *fileSizeAudioHbox;
	GtkWidget *fileSizeAudioLabel;
	GtkWidget *fileSizeAudioInfo;
	GtkWidget *fileSizeAudioOverheadHbox;
	GtkWidget *fileSizeAudioOverheadLabel;
	GtkWidget *fileSizeAudioOverheadInfo;
	GtkWidget *fileSizeTotalHbox;
	GtkWidget *fileSizeTotalLabel;
	GtkWidget *fileSizeTotalInfo;

	/* right side */
	GtkWidget *outputFrame;
	GtkWidget *rightVbox;

	GtkWidget *outputVideoHbox;
	GtkWidget *outputVideoLabel;
	GtkWidget *outputVideoEntry;
	GtkWidget *outputVideoButton;

	GtkWidget *videoOptionsFrame;
	GtkWidget *videoOptionsVbox;
	GSList *videoGroup = NULL;
	GtkWidget *videoProcessingVbox;

	GtkWidget *exportModuleHbox;
	GtkWidget *exportModuleLabel;
	GtkWidget *exportModuleCombo;
	GList *exportModuleOptions = NULL;

	GtkWidget *exportModuleStringHbox;
	GtkWidget *exportModuleStringLabel;
	GtkWidget *exportModuleStringEntry;

	GtkWidget *exportFramerateHbox;
	GtkWidget *exportFramerateLabel;
	GtkWidget *exportFramerateCombo;
	GList     *exportFramerateOptions = NULL;
	
	GtkWidget *exportSizeHbox;
	GtkWidget *exportSizeLabel;
	GtkWidget *exportSizeCheckButton;
	GtkWidget *exportSizeXLabel;
	GtkWidget *exportSizeWidthEntry;
	GtkWidget *exportSizeHeightEntry;

	GtkWidget *exportYUVCheckButton;
	GtkWidget *exportSwapRBCheckButton;
	GtkWidget *exportFlipCheckButton;
	GtkWidget *exportMirrorCheckButton;

	GtkWidget *exportDeinterHbox;
	GtkWidget *exportDeinterLabel;
	GtkWidget *exportDeinterCombo;
	GList     *exportDeinterOptions = NULL;

	GtkWidget *exportAntialiasHbox;
	GtkWidget *exportAntialiasLabel;
	GtkWidget *exportAntialiasCombo;
	GList     *exportAntialiasOptions = NULL;

	GtkWidget *exportVideoBitrateHbox;
	GtkWidget *exportVideoBitrateLabel;
	GtkWidget *exportVideoBitrateEntry;

	GtkWidget *audioOptionsFrame;
	GtkWidget *audioOptionsVbox;
	GSList *audioGroup = NULL;

	GtkWidget *audioProcessingVbox;

	GtkWidget *exportAudioFormatHbox;
	GtkWidget *exportAudioFormatLabel;
	GtkWidget *exportAudioFormatCombo;
	GList     *exportAudioFormatOptions = NULL;

	GtkWidget *exportAudioBitrateHbox;
	GtkWidget *exportAudioBitrateLabel;
	GtkWidget *exportAudioBitrateCombo;
	GList     *exportAudioBitrateOptions = NULL;

	GtkWidget *exportAudioGainHbox;
	GtkWidget *exportAudioGainLabel;
	GtkWidget *exportAudioGainEntry;

	glob_t globbuf;
	gint count;
	gchar *p_char;

	/* initilize configuration */
	output_config.process_video = 0;
	output_config.process_audio = 0;
	output_config.yuv = 0;
	output_config.swapRB = 0;
	output_config.flip = 0;
	output_config.mirror = 0;
	
	interface.aspectLock = FALSE;
	interface.dirtyTranscodeLine = 0;

	/* main layout */
	mainWindow = gtk_window_new( GTK_WINDOW_TOPLEVEL );
	gtk_window_set_default_size(GTK_WINDOW(mainWindow),800,600);

	mainVbox = gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(mainWindow),mainVbox);

	/* menu */
	menubar = gtk_menu_bar_new();
	gtk_box_pack_start(GTK_BOX(mainVbox),menubar,FALSE,FALSE,0);
	filemenuitem = gtk_menu_item_new_with_label("File");	
	gtk_menu_bar_append(GTK_MENU_BAR(menubar),filemenuitem);
	menu = gtk_menu_new();
	
	/* removing test show transcode line
	item = gtk_menu_item_new_with_label("show transcode command line");
	gtk_menu_append(GTK_MENU(menu),item);
	gtk_signal_connect(
			GTK_OBJECT(item),
			"activate",
			GTK_SIGNAL_FUNC(MenuTranscodeLine),
			NULL
			);
	*/
		
	item = gtk_menu_item_new_with_label("GO! (transcode)");
	gtk_menu_append(GTK_MENU(menu),item);
	gtk_signal_connect(
			GTK_OBJECT(item),
			"activate",
			GTK_SIGNAL_FUNC(MenuGO),
			NULL
			);
	item = gtk_menu_item_new();
	gtk_container_add(GTK_CONTAINER(item),gtk_hseparator_new());
	gtk_menu_append(GTK_MENU(menu),item);
	item = gtk_menu_item_new_with_label("Quit");
	gtk_menu_append(GTK_MENU(menu),item);
	gtk_signal_connect(
			GTK_OBJECT(item),
			"activate",
			GTK_SIGNAL_FUNC(MenuQuit),
			NULL
			);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(filemenuitem),menu);

	aboutmenuitem = gtk_menu_item_new_with_label("About");
	gtk_menu_bar_append(GTK_MENU_BAR(menubar),aboutmenuitem);
	gtk_signal_connect(
			GTK_OBJECT(aboutmenuitem),
			"activate",
			GTK_SIGNAL_FUNC(MenuAbout),
			NULL
			);

	
	mainHbox = gtk_hbox_new(TRUE,0);
	gtk_box_pack_start(GTK_BOX(mainVbox),mainHbox,TRUE,TRUE,0);
	//gtk_container_add(GTK_CONTAINER(mainVbox),mainHbox);
	
	leftMainVbox = gtk_vbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(mainHbox),leftMainVbox,TRUE,TRUE,0);
	
	transcodeCommandLine = gtk_entry_new();
	gtk_box_pack_start(GTK_BOX(mainVbox),transcodeCommandLine,FALSE,FALSE,0);
	interface.transcodeCommandLineEntry = transcodeCommandLine;
	gtk_entry_set_editable(GTK_ENTRY(transcodeCommandLine),TRUE);

	/* left side */
	inputFrame = gtk_frame_new("Input");
	gtk_frame_set_shadow_type(GTK_FRAME(inputFrame),GTK_SHADOW_OUT);
	gtk_container_set_border_width(GTK_CONTAINER(inputFrame),10);
	gtk_box_pack_start(GTK_BOX(leftMainVbox),inputFrame,TRUE,TRUE,0);

	leftVbox= gtk_vbox_new(FALSE,0);
	gtk_container_set_border_width(GTK_CONTAINER(leftVbox),10);
	gtk_container_add(GTK_CONTAINER(inputFrame),leftVbox);

	/* file input dialog */
	/* video */
	inputFileHbox = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(leftVbox),inputFileHbox,FALSE,FALSE,0);

	inputVideoLabel = gtk_label_new("Video File or Directory");
	gtk_box_pack_start(GTK_BOX(inputFileHbox),inputVideoLabel,FALSE,TRUE,5);

	inputVideoEntry = gtk_entry_new();
	gtk_box_pack_start(GTK_BOX(inputFileHbox),inputVideoEntry,TRUE,TRUE,0);
	interface.inputVideoEntry = inputVideoEntry;

	inputVideoButton = gtk_button_new_with_label("Browse");
	gtk_box_pack_start(GTK_BOX(inputFileHbox),inputVideoButton,FALSE,TRUE,0);

	
	/* audio */
	inputAudioFileHbox = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(leftVbox),inputAudioFileHbox,FALSE,FALSE,0);

	inputAudioLabel = gtk_label_new("Audio File (optional)");
	gtk_box_pack_start(GTK_BOX(inputAudioFileHbox),inputAudioLabel,FALSE,TRUE,0);

	inputAudioEntry = gtk_entry_new();
	gtk_box_pack_start(GTK_BOX(inputAudioFileHbox),inputAudioEntry,TRUE,TRUE,0);
	interface.inputAudioEntry = inputAudioEntry;

	inputAudioButton = gtk_button_new_with_label("Browse");
	gtk_box_pack_start(GTK_BOX(inputAudioFileHbox),inputAudioButton,FALSE,FALSE,0);

	/* import module */
	importModuleHbox = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(leftVbox),importModuleHbox,FALSE,FALSE,0);
	importModuleLabel = gtk_label_new("import module");
	gtk_box_pack_start(GTK_BOX(importModuleHbox),importModuleLabel,TRUE,FALSE,10);

	importModuleCombo = gtk_combo_new();
	gtk_box_pack_start(GTK_BOX(importModuleHbox),importModuleCombo,FALSE,FALSE,0);
	interface.importModuleCombo = importModuleCombo;
		
	importModuleOptions = g_list_append(importModuleOptions,"auto (use probed)");

	glob("/usr/local/lib/transcode/import*.so",0,NULL,&globbuf);
	for(count=0;count<globbuf.gl_pathc;count++){
		globbuf.gl_pathv[count]=strrchr(globbuf.gl_pathv[count],'_');
		globbuf.gl_pathv[count]++;
		p_char = strrchr(globbuf.gl_pathv[count],'.');
		*p_char = '\0';
		importModuleOptions = g_list_append(importModuleOptions,globbuf.gl_pathv[count]);
	}
	
	gtk_combo_set_popdown_strings(GTK_COMBO(importModuleCombo),importModuleOptions);
	
	importFramesHbox = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(leftVbox),importFramesHbox,FALSE,FALSE,0);
	importFramesLabel = gtk_label_new("frames (blank = ALL) e.g. f1-f2");
	gtk_box_pack_start(GTK_BOX(importFramesHbox),importFramesLabel,TRUE,FALSE,10);
	importFramesEntry= gtk_entry_new();
	gtk_box_pack_start(GTK_BOX(importFramesHbox),importFramesEntry,TRUE,TRUE,0);
	interface.importFramesEntry= importFramesEntry;

	probedFrame = gtk_frame_new("Probed Info about Input Video (audio not probed)");
	gtk_box_pack_start(GTK_BOX(leftVbox),probedFrame,TRUE,TRUE,30);
	gtk_container_set_border_width(GTK_CONTAINER(probedFrame),30);

	probedLabel = gtk_label_new("File not yet probed.");
	gtk_container_add(GTK_CONTAINER(probedFrame),probedLabel);
	gtk_label_set_justify(GTK_LABEL(probedLabel),GTK_JUSTIFY_LEFT);
	interface.probedLabel = probedLabel;

	/* projected video size*/

	fileSizeFrame= gtk_frame_new("Projected Output File Size (for .avi files)");
	gtk_frame_set_shadow_type(GTK_FRAME(fileSizeFrame),GTK_SHADOW_OUT);
	gtk_container_set_border_width(GTK_CONTAINER(fileSizeFrame),10);
	gtk_box_pack_start(GTK_BOX(leftMainVbox),fileSizeFrame,FALSE,FALSE,0);
	
	fileSizeVbox = gtk_vbox_new(TRUE,0);
	gtk_container_add(GTK_CONTAINER(fileSizeFrame),fileSizeVbox);

	fileSizeVideoHbox = gtk_hbox_new(TRUE,0);
	gtk_box_pack_start(GTK_BOX(fileSizeVbox),fileSizeVideoHbox,FALSE,FALSE,0);
	fileSizeVideoLabel = gtk_label_new("Video Data Size");
	gtk_box_pack_start(GTK_BOX(fileSizeVideoHbox),fileSizeVideoLabel,FALSE,FALSE,0);
	fileSizeVideoInfo = gtk_label_new("N/A MB");
	gtk_box_pack_start(GTK_BOX(fileSizeVideoHbox),fileSizeVideoInfo,FALSE,FALSE,0);
	interface.fileSizeVideo = fileSizeVideoInfo;

	fileSizeVideoOverheadHbox = gtk_hbox_new(TRUE,0);
	gtk_box_pack_start(GTK_BOX(fileSizeVbox),fileSizeVideoOverheadHbox,FALSE,FALSE,0);
	fileSizeVideoOverheadLabel = gtk_label_new("Video Overhead Size");
	gtk_box_pack_start(GTK_BOX(fileSizeVideoOverheadHbox),fileSizeVideoOverheadLabel,FALSE,FALSE,0);
	fileSizeVideoOverheadInfo = gtk_label_new("N/A MB");
	gtk_box_pack_start(GTK_BOX(fileSizeVideoOverheadHbox),fileSizeVideoOverheadInfo,FALSE,FALSE,0);
	interface.fileSizeVideoOverhead = fileSizeVideoOverheadInfo;

	fileSizeAudioHbox = gtk_hbox_new(TRUE,0);
	gtk_box_pack_start(GTK_BOX(fileSizeVbox),fileSizeAudioHbox,FALSE,FALSE,0);
	fileSizeAudioLabel= gtk_label_new("Audio Data Size");
	gtk_box_pack_start(GTK_BOX(fileSizeAudioHbox),fileSizeAudioLabel,FALSE,FALSE,0);
	fileSizeAudioInfo = gtk_label_new("N/A MB");
	gtk_box_pack_start(GTK_BOX(fileSizeAudioHbox),fileSizeAudioInfo,FALSE,FALSE,0);
	interface.fileSizeAudio = fileSizeAudioInfo;

	fileSizeAudioOverheadHbox = gtk_hbox_new(TRUE,0);
	gtk_box_pack_start(GTK_BOX(fileSizeVbox),fileSizeAudioOverheadHbox,FALSE,FALSE,0);
	fileSizeAudioOverheadLabel= gtk_label_new("Audio Overhead Size");
	gtk_box_pack_start(GTK_BOX(fileSizeAudioOverheadHbox),fileSizeAudioOverheadLabel,FALSE,FALSE,0);
	fileSizeAudioOverheadInfo = gtk_label_new("N/A MB");
	gtk_box_pack_start(GTK_BOX(fileSizeAudioOverheadHbox),fileSizeAudioOverheadInfo,FALSE,FALSE,0);
	interface.fileSizeAudioOverhead = fileSizeAudioOverheadInfo;

	fileSizeTotalHbox = gtk_hbox_new(TRUE,0);
	gtk_box_pack_start(GTK_BOX(fileSizeVbox),fileSizeTotalHbox,FALSE,FALSE,0);
	fileSizeTotalLabel= gtk_label_new("Total");
	gtk_box_pack_start(GTK_BOX(fileSizeTotalHbox),fileSizeTotalLabel,FALSE,FALSE,0);
	fileSizeTotalInfo = gtk_label_new("N/A MB");
	gtk_box_pack_start(GTK_BOX(fileSizeTotalHbox),fileSizeTotalInfo,FALSE,FALSE,0);
	interface.fileSizeTotal = fileSizeTotalInfo;

	
	/* right side */
	outputFrame = gtk_frame_new("Output");
	gtk_frame_set_shadow_type(GTK_FRAME(outputFrame),GTK_SHADOW_OUT);
	gtk_container_set_border_width(GTK_CONTAINER(outputFrame),10);
	gtk_box_pack_start(GTK_BOX(mainHbox),outputFrame,TRUE,TRUE,0);

	rightVbox= gtk_vbox_new(FALSE,0);
	gtk_container_set_border_width(GTK_CONTAINER(rightVbox),10);
	gtk_container_add(GTK_CONTAINER(outputFrame),rightVbox);

	/* output video selection */
	outputVideoHbox = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(rightVbox),outputVideoHbox,FALSE,FALSE,0);

	outputVideoLabel = gtk_label_new("Output Video File");
	gtk_box_pack_start(GTK_BOX(outputVideoHbox),outputVideoLabel,FALSE,FALSE,5);

	outputVideoEntry = gtk_entry_new();
	gtk_box_pack_start(GTK_BOX(outputVideoHbox),outputVideoEntry,TRUE,TRUE,0);
	interface.outputVideoEntry = outputVideoEntry;

	outputVideoButton = gtk_button_new_with_label("Browse");
	gtk_box_pack_start(GTK_BOX(outputVideoHbox),outputVideoButton,FALSE,TRUE,0);

	/* output options */
	/* video */
	videoOptionsFrame = gtk_frame_new("Video Options");
	gtk_box_pack_start(GTK_BOX(rightVbox),videoOptionsFrame,TRUE,TRUE,0);

	videoOptionsVbox = gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(videoOptionsFrame),videoOptionsVbox);

	videoGroup = AddRadioButton(videoOptionsVbox,"Direct Stream Copy (pass-through)",DIRECTVIDEO,videoGroup);
	videoGroup = AddRadioButton(videoOptionsVbox,"Full Processing Mode",PROCESSVIDEO,videoGroup);

	videoProcessingVbox = gtk_vbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(videoOptionsVbox),videoProcessingVbox,TRUE,TRUE,0);
	interface.videoProcessingVbox = videoProcessingVbox;

	exportModuleHbox = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(videoProcessingVbox),exportModuleHbox,FALSE,FALSE,0);
	exportModuleLabel = gtk_label_new("export module");
	gtk_box_pack_start(GTK_BOX(exportModuleHbox),exportModuleLabel,TRUE,FALSE,10);

	exportModuleCombo = gtk_combo_new();
	gtk_box_pack_start(GTK_BOX(exportModuleHbox),exportModuleCombo,FALSE,FALSE,0);
	interface.exportModuleCombo = exportModuleCombo;

	glob("/usr/local/lib/transcode/export*.so",0,NULL,&globbuf);
	for(count=0;count<globbuf.gl_pathc;count++){
		globbuf.gl_pathv[count]=strrchr(globbuf.gl_pathv[count],'_');
		globbuf.gl_pathv[count]++;
		p_char = strrchr(globbuf.gl_pathv[count],'.');
		*p_char = '\0';
		exportModuleOptions = g_list_append(exportModuleOptions,globbuf.gl_pathv[count]);
	}
	
	//exportModuleOptions = g_list_append(exportModuleOptions,"divx4");
	gtk_combo_set_popdown_strings(GTK_COMBO(exportModuleCombo),exportModuleOptions);

	exportModuleStringHbox = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(videoProcessingVbox),exportModuleStringHbox,FALSE,FALSE,0);
	exportModuleStringLabel = gtk_label_new("export module optional string");
	gtk_box_pack_start(GTK_BOX(exportModuleStringHbox),exportModuleStringLabel,TRUE,FALSE,10);

	exportModuleStringEntry = gtk_entry_new();
	gtk_box_pack_start(GTK_BOX(exportModuleStringHbox),exportModuleStringEntry,FALSE,FALSE,10);
	interface.exportModuleStringEntry = exportModuleStringEntry;

	exportFramerateHbox = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(videoProcessingVbox),exportFramerateHbox,FALSE,FALSE,0);
	exportFramerateLabel = gtk_label_new("frame rate (fps) ");
	gtk_box_pack_start(GTK_BOX(exportFramerateHbox),exportFramerateLabel,TRUE,FALSE,10);
	exportFramerateCombo = gtk_combo_new();
	gtk_box_pack_start(GTK_BOX(exportFramerateHbox),exportFramerateCombo,FALSE,FALSE,0);

	interface.exportFramerateCombo = exportFramerateCombo;
	exportFramerateOptions = g_list_append(exportFramerateOptions,"auto (same as input)");
	exportFramerateOptions = g_list_append(exportFramerateOptions,"23.976");
	exportFramerateOptions = g_list_append(exportFramerateOptions,"25");
	exportFramerateOptions = g_list_append(exportFramerateOptions,"29.970");
	gtk_combo_set_popdown_strings(GTK_COMBO(exportFramerateCombo),exportFramerateOptions);

	exportDeinterHbox = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(videoProcessingVbox),exportDeinterHbox,FALSE,FALSE,0);
	exportDeinterLabel = gtk_label_new("deinterlace mode");
	gtk_box_pack_start(GTK_BOX(exportDeinterHbox),exportDeinterLabel,TRUE,TRUE,10);
	exportDeinterCombo = gtk_combo_new();
	gtk_box_pack_start(GTK_BOX(exportDeinterHbox),exportDeinterCombo,FALSE,FALSE,0);
	interface.exportDeinterCombo = exportDeinterCombo;
	exportDeinterOptions = g_list_append(exportDeinterOptions,"none");
	exportDeinterOptions = g_list_append(exportDeinterOptions,"interpolate scanlines (fast)");
	exportDeinterOptions = g_list_append(exportDeinterOptions,"handled by encoder (if available)");
	exportDeinterOptions = g_list_append(exportDeinterOptions,"zoom to full frame (slow)");
	exportDeinterOptions = g_list_append(exportDeinterOptions,"drop field / half height (fast)");
	exportDeinterOptions = g_list_append(exportDeinterOptions,"interpolate scanlines / blend frames");
	gtk_combo_set_popdown_strings(GTK_COMBO(exportDeinterCombo),exportDeinterOptions);

	exportAntialiasHbox = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(videoProcessingVbox),exportAntialiasHbox,FALSE,FALSE,0);
	exportAntialiasLabel = gtk_label_new("antialias mode");
	gtk_box_pack_start(GTK_BOX(exportAntialiasHbox),exportAntialiasLabel,TRUE,TRUE,10);
	exportAntialiasCombo = gtk_combo_new();
	gtk_box_pack_start(GTK_BOX(exportAntialiasHbox),exportAntialiasCombo,FALSE,FALSE,0);
	interface.exportAntialiasCombo = exportAntialiasCombo;
	exportAntialiasOptions = g_list_append(exportAntialiasOptions,"none");
	exportAntialiasOptions = g_list_append(exportAntialiasOptions,"de-interlace effects only");
	exportAntialiasOptions = g_list_append(exportAntialiasOptions,"resize effects only");
	exportAntialiasOptions = g_list_append(exportAntialiasOptions,"process full frame (slow)");
	gtk_combo_set_popdown_strings(GTK_COMBO(exportAntialiasCombo),exportAntialiasOptions);

	/* video bitrate stuff */
	exportVideoBitrateHbox = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(videoProcessingVbox),exportVideoBitrateHbox,FALSE,FALSE,0);
	exportVideoBitrateLabel= gtk_label_new("video bitrate (kbits/sec)");
	gtk_box_pack_start(GTK_BOX(exportVideoBitrateHbox),exportVideoBitrateLabel,TRUE,TRUE,10);
	exportVideoBitrateEntry= gtk_entry_new();
	gtk_box_pack_start(GTK_BOX(exportVideoBitrateHbox),exportVideoBitrateEntry,FALSE,FALSE,0);
	interface.exportVideoBitrateEntry= exportVideoBitrateEntry;

	exportSizeHbox = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(videoProcessingVbox),exportSizeHbox,FALSE,FALSE,0);

	exportSizeCheckButton = gtk_check_button_new_with_label("preserve aspect ratio");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(exportSizeCheckButton),TRUE);
	output_config.aspectRatio=1;
	gtk_box_pack_start(GTK_BOX(exportSizeHbox),exportSizeCheckButton,FALSE,FALSE,0);

	exportSizeWidthEntry = gtk_entry_new();
	gtk_widget_set_usize(exportSizeWidthEntry,40,20);
	gtk_box_pack_start(GTK_BOX(exportSizeHbox),exportSizeWidthEntry,FALSE,FALSE,0);
	interface.exportSizeWidthEntry = exportSizeWidthEntry;
	
	exportSizeXLabel = gtk_label_new(" x ");
	gtk_box_pack_start(GTK_BOX(exportSizeHbox),exportSizeXLabel,FALSE,FALSE,0);

	exportSizeHeightEntry = gtk_entry_new();
	gtk_widget_set_usize(exportSizeHeightEntry,40,20);
	gtk_box_pack_start(GTK_BOX(exportSizeHbox),exportSizeHeightEntry,FALSE,FALSE,0);
	interface.exportSizeHeightEntry = exportSizeHeightEntry;

	exportYUVCheckButton = gtk_check_button_new_with_label("use YUV/YV12/I420 internally (usually much faster)");
	gtk_box_pack_start(GTK_BOX(videoProcessingVbox),exportYUVCheckButton,FALSE,FALSE,0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(exportYUVCheckButton),TRUE);
	output_config.yuv=1;

	exportSwapRBCheckButton = gtk_check_button_new_with_label("swap red and blue");
	gtk_box_pack_start(GTK_BOX(videoProcessingVbox),exportSwapRBCheckButton,FALSE,FALSE,0);

	exportFlipCheckButton = gtk_check_button_new_with_label("flip upside down");
	gtk_box_pack_start(GTK_BOX(videoProcessingVbox),exportFlipCheckButton,FALSE,FALSE,0);

	exportMirrorCheckButton = gtk_check_button_new_with_label("mirror");
	gtk_box_pack_start(GTK_BOX(videoProcessingVbox),exportMirrorCheckButton,FALSE,FALSE,0);


	
	/* audio*/
	audioOptionsFrame = gtk_frame_new("Audio Options");
	gtk_box_pack_start(GTK_BOX(rightVbox),audioOptionsFrame,TRUE,TRUE,0);

	audioOptionsVbox = gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(audioOptionsFrame),audioOptionsVbox);

	audioGroup = AddRadioButton(audioOptionsVbox,"Direct Stream Copy (pass-through)",DIRECTAUDIO,audioGroup);
	audioGroup = AddRadioButton(audioOptionsVbox,"Full Processing Mode",PROCESSAUDIO,audioGroup);

	audioProcessingVbox = gtk_vbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(audioOptionsVbox),audioProcessingVbox,FALSE,TRUE,0);
	interface.audioProcessingVbox = audioProcessingVbox;

	exportAudioFormatHbox = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(audioProcessingVbox),exportAudioFormatHbox,TRUE,TRUE,0);

	exportAudioFormatLabel = gtk_label_new("audio format");
	gtk_box_pack_start(GTK_BOX(exportAudioFormatHbox),exportAudioFormatLabel,TRUE,TRUE,0);
	exportAudioFormatCombo = gtk_combo_new();
	gtk_box_pack_start(GTK_BOX(exportAudioFormatHbox),exportAudioFormatCombo,TRUE,TRUE,0);
	interface.exportAudioFormatCombo = exportAudioFormatCombo;
	exportAudioFormatOptions = g_list_append(exportAudioFormatOptions,"MPEG layer-3 aka MP3");
	exportAudioFormatOptions = g_list_append(exportAudioFormatOptions,"OGG/Vorbis");
	exportAudioFormatOptions = g_list_append(exportAudioFormatOptions,"MPEG layer-2 aka MP2");
	exportAudioFormatOptions = g_list_append(exportAudioFormatOptions,"AC3 audio");
	exportAudioFormatOptions = g_list_append(exportAudioFormatOptions,"PCM uncompressed");
	gtk_combo_set_popdown_strings(GTK_COMBO(exportAudioFormatCombo),exportAudioFormatOptions);

	exportAudioBitrateHbox = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(audioProcessingVbox),exportAudioBitrateHbox,TRUE,TRUE,0);
	exportAudioBitrateLabel = gtk_label_new("audio bitrate (kbits/sec)");
	gtk_box_pack_start(GTK_BOX(exportAudioBitrateHbox),exportAudioBitrateLabel,TRUE,TRUE,0);
	exportAudioBitrateCombo = gtk_combo_new();
	gtk_box_pack_start(GTK_BOX(exportAudioBitrateHbox),exportAudioBitrateCombo,TRUE,TRUE,0);
	interface.exportAudioBitrateCombo = exportAudioBitrateCombo;
	exportAudioBitrateOptions = g_list_append(exportAudioBitrateOptions,"64");
	exportAudioBitrateOptions = g_list_append(exportAudioBitrateOptions,"96");
	exportAudioBitrateOptions = g_list_append(exportAudioBitrateOptions,"128");
	exportAudioBitrateOptions = g_list_append(exportAudioBitrateOptions,"160");
	exportAudioBitrateOptions = g_list_append(exportAudioBitrateOptions,"192");
	exportAudioBitrateOptions = g_list_append(exportAudioBitrateOptions,"256");
	exportAudioBitrateOptions = g_list_append(exportAudioBitrateOptions,"320");
	exportAudioBitrateOptions = g_list_append(exportAudioBitrateOptions,"384");
	gtk_combo_set_popdown_strings(GTK_COMBO(exportAudioBitrateCombo),exportAudioBitrateOptions);

	exportAudioGainHbox = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(audioProcessingVbox),exportAudioGainHbox,TRUE,TRUE,0);
	exportAudioGainLabel = gtk_label_new("volume gain (1=same as input)");
	gtk_box_pack_start(GTK_BOX(exportAudioGainHbox),exportAudioGainLabel,TRUE,TRUE,0);
	exportAudioGainEntry = gtk_entry_new();
	gtk_widget_set_usize(exportAudioGainEntry,40,20);
	gtk_box_pack_start(GTK_BOX(exportAudioGainHbox),exportAudioGainEntry,FALSE,TRUE,0);
	interface.exportAudioGainEntry = exportAudioGainEntry;
	

	/* connect signals */

	gtk_signal_connect(
			GTK_OBJECT(mainWindow),
			"destroy",
			GTK_SIGNAL_FUNC(CloseTheApp),
			NULL);

	gtk_signal_connect(
			GTK_OBJECT(inputVideoEntry),
			"activate",
			GTK_SIGNAL_FUNC(ProbeVideoFile),
			probedLabel);

	gtk_signal_connect(
			GTK_OBJECT(inputVideoEntry),
			"changed",
			GTK_SIGNAL_FUNC(UpdateTranscodeLine),
			probedLabel);

	gtk_signal_connect(
			GTK_OBJECT(inputAudioEntry),
			"changed",
			GTK_SIGNAL_FUNC(UpdateTranscodeLine),
			probedLabel);

	gtk_signal_connect(
			GTK_OBJECT(GTK_EDITABLE(GTK_COMBO(importModuleCombo)->entry)),
			"changed",
			GTK_SIGNAL_FUNC(UpdateTranscodeLine),
			probedLabel);

	gtk_signal_connect(
			GTK_OBJECT(outputVideoEntry),
			"changed",
			GTK_SIGNAL_FUNC(UpdateTranscodeLine),
			probedLabel);
	
	gtk_signal_connect(
			GTK_OBJECT(GTK_EDITABLE(GTK_COMBO(exportModuleCombo)->entry)),
			"changed",
			GTK_SIGNAL_FUNC(UpdateTranscodeLine),
			probedLabel);

	gtk_signal_connect(
			GTK_OBJECT(exportModuleStringEntry),
			"changed",
			GTK_SIGNAL_FUNC(UpdateTranscodeLine),
			probedLabel);

	gtk_signal_connect(
			GTK_OBJECT(GTK_EDITABLE(GTK_COMBO(exportFramerateCombo)->entry)),
			"changed",
			GTK_SIGNAL_FUNC(UpdateTranscodeLine),
			probedLabel);

	gtk_signal_connect(
			GTK_OBJECT(GTK_EDITABLE(exportAudioGainEntry)),
			"changed",
			GTK_SIGNAL_FUNC(UpdateTranscodeLine),
			probedLabel);

	gtk_signal_connect(
			GTK_OBJECT(exportSizeWidthEntry),
			"changed",
			GTK_SIGNAL_FUNC(UpdateTranscodeLine),
			probedLabel);

	gtk_signal_connect(
			GTK_OBJECT(exportSizeHeightEntry),
			"changed",
			GTK_SIGNAL_FUNC(UpdateTranscodeLine),
			probedLabel);

	gtk_signal_connect(
			GTK_OBJECT(GTK_EDITABLE(GTK_COMBO(exportDeinterCombo)->entry)),
			"changed",
			GTK_SIGNAL_FUNC(UpdateTranscodeLine),
			probedLabel);

	gtk_signal_connect(
			GTK_OBJECT(GTK_EDITABLE(GTK_COMBO(exportAntialiasCombo)->entry)),
			"changed",
			GTK_SIGNAL_FUNC(UpdateTranscodeLine),
			probedLabel);

	gtk_signal_connect(
			GTK_OBJECT(GTK_EDITABLE(GTK_COMBO(exportAudioFormatCombo)->entry)),
			"changed",
			GTK_SIGNAL_FUNC(UpdateTranscodeLine),
			probedLabel);

	gtk_signal_connect(
			GTK_OBJECT(GTK_EDITABLE(GTK_COMBO(exportAudioBitrateCombo)->entry)),
			"changed",
			GTK_SIGNAL_FUNC(UpdateTranscodeLine),
			probedLabel);

	gtk_signal_connect(
			GTK_OBJECT(GTK_EDITABLE(interface.importFramesEntry)),
			"changed",
			GTK_SIGNAL_FUNC(UpdateTranscodeLine),
			probedLabel);

	gtk_signal_connect(
			GTK_OBJECT(inputVideoButton),
			"clicked",
			GTK_SIGNAL_FUNC(MakeBrowseWindow),
			inputVideoEntry);

	gtk_signal_connect(
			GTK_OBJECT(outputVideoButton),
			"clicked",
			GTK_SIGNAL_FUNC(MakeBrowseWindowOutput),
			outputVideoEntry);

	gtk_signal_connect(
			GTK_OBJECT(exportSizeCheckButton),
			"toggled",
			GTK_SIGNAL_FUNC(ToggleAspectRatio),
			outputVideoEntry);

	gtk_signal_connect(
			GTK_OBJECT(GTK_EDITABLE(interface.exportVideoBitrateEntry)),
			"changed",
			GTK_SIGNAL_FUNC(UpdateTranscodeLine),
			probedLabel);

	gtk_signal_connect(
			GTK_OBJECT(GTK_EDITABLE(GTK_COMBO(interface.exportFramerateCombo)->entry)),
			"changed",
			GTK_SIGNAL_FUNC(UpdateVideoSize),
			probedLabel);


	gtk_signal_connect(
			GTK_OBJECT(GTK_EDITABLE(interface.exportVideoBitrateEntry)),
			"changed",
			GTK_SIGNAL_FUNC(UpdateVideoSize),
			probedLabel);

	gtk_signal_connect(
			GTK_OBJECT(GTK_EDITABLE(GTK_COMBO(interface.exportAudioBitrateCombo)->entry)),
			"changed",
			GTK_SIGNAL_FUNC(UpdateAudioSize),
			probedLabel);

	gtk_signal_connect(
			GTK_OBJECT(exportSizeWidthEntry),
			"changed",
			GTK_SIGNAL_FUNC(UpdateRatioWidth),
			NULL);

	gtk_signal_connect(
			GTK_OBJECT(exportSizeHeightEntry),
			"changed",
			GTK_SIGNAL_FUNC(UpdateRatioHeight),
			NULL);

	gtk_signal_connect(
			GTK_OBJECT(exportYUVCheckButton),
			"toggled",
			GTK_SIGNAL_FUNC(ToggleButton),
			&output_config.yuv);

	gtk_signal_connect(
			GTK_OBJECT(exportSwapRBCheckButton),
			"toggled",
			GTK_SIGNAL_FUNC(ToggleButton),
			&output_config.swapRB);

	gtk_signal_connect(
			GTK_OBJECT(exportFlipCheckButton),
			"toggled",
			GTK_SIGNAL_FUNC(ToggleButton),
			&output_config.flip);

	gtk_signal_connect(
			GTK_OBJECT(exportMirrorCheckButton),
			"toggled",
			GTK_SIGNAL_FUNC(ToggleButton),
			&output_config.mirror);

	gtk_signal_connect(
			GTK_OBJECT(interface.transcodeCommandLineEntry),
			"changed",
			GTK_SIGNAL_FUNC(SetDirty),
			NULL);

	/* connect signals for any changes to update transcode line */
	/* TODO */

	return mainWindow;
}

void MakeTranscodeDialog(void){
	GtkWidget *dialog;
	GtkWidget *text;
	GtkWidget *vBox;
	GtkWidget *hBox;
	GtkWidget *progressBar;
	GtkWidget *cancel_button;

	output_config.running = TRUE;

	dialog = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_default_size(GTK_WINDOW(dialog),600,400);
	gtk_window_set_title(GTK_WINDOW(dialog),"running transcode ...");
	gtk_container_set_border_width(GTK_CONTAINER(dialog),10);
	gtk_window_set_position(GTK_WINDOW(dialog),GTK_WIN_POS_CENTER);

	vBox = gtk_vbox_new(FALSE,5);
	gtk_container_add(GTK_CONTAINER(dialog),vBox);

	text = gtk_text_new(NULL,NULL);
	gtk_box_pack_start(GTK_BOX(vBox),text,TRUE,TRUE,0);
	interface.transcodeOutputText = text;

	hBox = gtk_hbox_new(FALSE,5);
	gtk_box_pack_start(GTK_BOX(vBox),hBox,FALSE,FALSE,0);

	cancel_button = gtk_button_new_with_label("cancel");
	gtk_box_pack_start(GTK_BOX(hBox),cancel_button,FALSE,FALSE,0);
   gtk_signal_connect ( GTK_OBJECT ( cancel_button), 
      "clicked",
      GTK_SIGNAL_FUNC ( StopTranscode ), 
      NULL);

	progressBar = gtk_progress_bar_new();
	gtk_progress_set_show_text(GTK_PROGRESS(progressBar),TRUE);
	gtk_box_pack_start(GTK_BOX(hBox),progressBar,TRUE,TRUE,0);
	interface.progressBar = progressBar;
	gtk_progress_configure(GTK_PROGRESS(interface.progressBar),0.0,0.0,(float)tcprobe_data.length_frames);

	gtk_widget_show_all(dialog);

}

/* subroutines */
GSList *AddRadioButton(GtkWidget *box, gchar *label,gint value, GSList *group){
	GtkWidget *radio;
	gint *value_malloced;

	value_malloced = (gint *)malloc(sizeof(int));
	*value_malloced = value;

	radio = gtk_radio_button_new_with_label(group,label);
	gtk_box_pack_start(GTK_BOX(box),radio,FALSE,FALSE,0);
	gtk_signal_connect(
			GTK_OBJECT(radio),
			"pressed",
			GTK_SIGNAL_FUNC(RadioClicked),
			value_malloced);
	return (gtk_radio_button_group(GTK_RADIO_BUTTON(radio)));
}

void SetDirty(void){
	interface.dirtyTranscodeLine = 1;
}

void UpdateTranscodeLine(GtkWidget *Entry, gpointer data){
	MakeTranscodeLine();
}

void MenuTranscodeLine(GtkMenuItem *menuitem,gpointer data){
	MakeTranscodeLine();
}

/* Function to show a message in a dialog box */
void ShowMessage( gchar * textmessage ) {
   GtkWidget * dialogwindow;
   GtkWidget * packingbox;
   GtkWidget * dialogwidget;

   /* First, set up a window, centered on the screen */
   dialogwindow = gtk_window_new ( GTK_WINDOW_DIALOG );
   gtk_window_set_title ( GTK_WINDOW ( dialogwindow ), "Message..." );
   gtk_container_set_border_width( GTK_CONTAINER ( dialogwindow ), 10 );
   gtk_window_set_position ( GTK_WINDOW ( dialogwindow ), GTK_WIN_POS_CENTER );

   /* Add a VBox to the window to hold the dialog widgets */
   packingbox = gtk_vbox_new ( FALSE, 5 );
   gtk_container_add ( GTK_CONTAINER ( dialogwindow ), packingbox );

   /* Now add a label to the vbox with the user's message */
   dialogwidget = AddWidget ( gtk_label_new ( textmessage ), packingbox );

   /* Next, add a horizontal separator bar to make things look nice */
   dialogwidget = AddWidget ( gtk_hseparator_new (), packingbox );

   /* Finally, add a button and connect its signal handler */
   dialogwidget = AddWidget ( gtk_button_new_with_label ( "OK" ), packingbox );
   gtk_signal_connect ( GTK_OBJECT ( dialogwidget ), 
      "clicked",
      GTK_SIGNAL_FUNC ( CloseDialog ), 
      dialogwindow );

   /* All that remains is to set the modality of the window and show it */
   gtk_window_set_modal ( GTK_WINDOW ( dialogwindow ), TRUE );
   gtk_widget_show_all ( dialogwindow );
}

GtkWidget *AddWidget(GtkWidget * widget, GtkWidget * packingbox){
   gtk_box_pack_start ( GTK_BOX ( packingbox ), widget, FALSE, TRUE, 2 );
   return widget;
}



void MakeTranscodeLine(void){
	GString *commandLine;
	gchar *text;
	gchar text_temp[256];
	gint number=3;
	gint width=0;
	gint height=0;

	/* gotta start somehwere */
	commandLine = g_string_new("transcode ");

	/* input video */
	text = gtk_editable_get_chars(GTK_EDITABLE(interface.inputVideoEntry),0,-1);
	sprintf(text_temp,"-i \"%s\" ",text);
	g_string_append(commandLine,text_temp);

	/* input audio (if available) */
	text = gtk_editable_get_chars(GTK_EDITABLE(interface.inputAudioEntry),0,-1);
	if(strcmp(text,"")){
		sprintf(text_temp,"-p \"%s\" ",text);
		g_string_append(commandLine,text_temp);
	}

	/* import module */
	text =  gtk_editable_get_chars(GTK_EDITABLE(GTK_COMBO(interface.importModuleCombo)->entry),0,-1);
	if(strcmp("auto (use probed)",text)){
		sprintf(text_temp,"-x %s ",text);
		g_string_append(commandLine,text_temp);
	}

	/* input frames */
	text =  gtk_editable_get_chars(GTK_EDITABLE(interface.importFramesEntry),0,-1);
	if(strcmp("",text)){
		sprintf(text_temp,"-c %s ",text);
		g_string_append(commandLine,text_temp);
	}



	/* passthrough options */
	if(output_config.process_video || output_config.process_audio){
		if(output_config.process_video)
			number = number-1;
		if(output_config.process_audio)
			number = number-2;
	}
	if(number>0){
		sprintf(text_temp,"-P %d ",number);
		g_string_append(commandLine,text_temp);
	}

	/* video processing options */
	if(output_config.process_video){

		/* export module */
		text =  gtk_editable_get_chars(GTK_EDITABLE(GTK_COMBO(interface.exportModuleCombo)->entry),0,-1);
		sprintf(text_temp,"-y %s ",text);
		g_string_append(commandLine,text_temp);

		text =  gtk_editable_get_chars(GTK_EDITABLE(interface.exportModuleStringEntry),0,-1);
		if((strcmp(text,""))){ 
			sprintf(text_temp,"-F %s ",text);
			g_string_append(commandLine,text_temp);
		}

		/* framerate */
		text =  gtk_editable_get_chars(GTK_EDITABLE(GTK_COMBO(interface.exportFramerateCombo)->entry),0,-1);
		if(strcmp("auto (same as input)",text)){ /* selected framerate differs from input */
			sprintf(text_temp,"-f %s ",text);
			g_string_append(commandLine,text_temp);
		}

		/* deinterlace mode */
		text =  gtk_editable_get_chars(GTK_EDITABLE(GTK_COMBO(interface.exportDeinterCombo)->entry),0,-1);
		if(!strcmp("interpolate scanlines (fast)",text)){ 
			sprintf(text_temp,"-I 1 ");
			g_string_append(commandLine,text_temp);
		}else{
			if(!strcmp("handled by encoder (if available)",text)){ 
				sprintf(text_temp,"-I 2 ");
				g_string_append(commandLine,text_temp);
			}else{
				if(!strcmp("zoom to full frame (slow)",text)){ 
					sprintf(text_temp,"-I 3 ");
					g_string_append(commandLine,text_temp);
				}else{
					if(!strcmp("drop field / half height (fast)",text)){ 
						sprintf(text_temp,"-I 4 ");
						g_string_append(commandLine,text_temp);
					}else{
						if(!strcmp("interpolate scanlines / blend frames",text)){
							sprintf(text_temp,"-I 5 ");
							g_string_append(commandLine,text_temp);
						}else{
							if(strcmp("none",text)&&strcmp("",text)){ 
								sprintf(text_temp,"-I %d ",atoi(text));
								g_string_append(commandLine,text_temp);
							}
						}
					}
				}
			}

		}

		/* anti-aliasing mode */
		text =  gtk_editable_get_chars(GTK_EDITABLE(GTK_COMBO(interface.exportAntialiasCombo)->entry),0,-1);
		if(!strcmp("de-interlace effects only",text)){
			sprintf(text_temp,"-C 1 ");
			g_string_append(commandLine,text_temp);
		}else{
			if(!strcmp("resize effects only",text)){
				sprintf(text_temp,"-C 2 ");
				g_string_append(commandLine,text_temp);
			}else{
				if(!strcmp("process full frame (slow)",text)){ 
					sprintf(text_temp,"-C 3 ");
					g_string_append(commandLine,text_temp);
				}else{
						if(strcmp("none",text)&&(strcmp("",text))){ 
							sprintf(text_temp,"-C %d ",atoi(text));
							g_string_append(commandLine,text_temp);
						}
				}
			}
		}
	
		/* export video bitrate */
		text = gtk_editable_get_chars(GTK_EDITABLE(interface.exportVideoBitrateEntry),0,-1);
		if((strcmp(text,""))){ 
			sprintf(text_temp,"-w %d ",atoi(text));
			g_string_append(commandLine,text_temp);
		}


		/* size */
		width =  atoi(gtk_editable_get_chars(GTK_EDITABLE(interface.exportSizeWidthEntry),0,-1));
		height =  atoi(gtk_editable_get_chars(GTK_EDITABLE(interface.exportSizeHeightEntry),0,-1));
		/* only print resizing information if it differs from input */
		if(!((width == tcprobe_data.width)&&(height==tcprobe_data.height))){
			sprintf(text_temp,"-Z %dx%d ",width,height);
			g_string_append(commandLine,text_temp);
		}

		/* checked options */
		if(output_config.yuv)
			g_string_append(commandLine,"-V ");
		if(output_config.swapRB)
			g_string_append(commandLine,"-k ");
		if(output_config.flip)
			g_string_append(commandLine,"-z ");
		if(output_config.mirror)
			g_string_append(commandLine,"-l ");
	
	}

	/* audio processing options */
	if(output_config.process_audio){
		
		/* audio format */
		text =  gtk_editable_get_chars(GTK_EDITABLE(GTK_COMBO(interface.exportAudioFormatCombo)->entry),0,-1);
		if(!strcmp("MPEG layer-3 aka MP3",text))
			g_string_append(commandLine,"-N 0x55 ");
		if(!strcmp("OGG/Vorbis",text))
			g_string_append(commandLine,"-N 0xfffe ");
		if(!strcmp("PCM uncompressed",text))
			g_string_append(commandLine,"-N 0x1 ");
		if(!strcmp("MPEG layer-2 aka MP2",text))
			g_string_append(commandLine,"-N 0x50 ");
		if(!strcmp("AC3 audio",text))
			g_string_append(commandLine,"-A -N 0x2000 ");

		/* audio bitrate */	
		text =  gtk_editable_get_chars(GTK_EDITABLE(GTK_COMBO(interface.exportAudioBitrateCombo)->entry),0,-1);
		if(strcmp("",text)){ /* unless string is empty */
			sprintf(text_temp,"-b %s ",text);
			g_string_append(commandLine,text_temp);
		}

		/* volume gain */
		text =  gtk_editable_get_chars(GTK_EDITABLE(interface.exportAudioGainEntry),0,-1);
		if(strcmp("",text)){ /* unless string is empty */
			sprintf(text_temp,"-s %s ",text);
			g_string_append(commandLine,text_temp);
		}
	}
	
	/* output video */
	text = gtk_editable_get_chars(GTK_EDITABLE(interface.outputVideoEntry),0,-1);
	sprintf(text_temp,"-o \"%s\" ",text);
	g_string_append(commandLine,text_temp);



	gtk_entry_set_text(GTK_ENTRY(interface.transcodeCommandLineEntry),commandLine->str);	
	interface.dirtyTranscodeLine = 0;
}

void MenuGO(GtkMenuItem *menuitem,gpointer data){
	/* if the transcode line has changed since last time we built it */
	if(!interface.dirtyTranscodeLine){
		MakeTranscodeLine();
	}
	RunTranscode(gtk_editable_get_chars(GTK_EDITABLE(interface.transcodeCommandLineEntry),0,-1));

}

void MenuAbout(GtkMenuItem *menuitem,gpointer data){
	char message[] = 
"gtranscode - a GUI (graphical user interface) front end for transcode\n"
"GPL Copyright (C) 2003 Michael Spiceland\n"
"\n"
"While transcode is an excellent and powerful tool, the fact\n"
"that it is text based may make it hard to use for many \n"
"people.  'gtranscode' aims to eleviate the learning curve by\n"
"providing a GUI for *most* of the functions of transcode and\n"
"showing the equivalent command line.  'gtranscode' also \n"
"allows users to place whatever extra commands that are not\n"
"supported by the GUI in the command line string (at the\n"
"bottom of the main screen) just before hiting 'GO'.\n"
"\n"
"This program is free software; you can redistribute it and/or modify\n"
"it under the terms of the GNU General Public License as published by\n"
"the Free Software Foundation; either version 2 of the License, or\n"
"(at your option) any later version.\n"
"    \n"
"This program is distributed in the hope that it will be useful,\n"
"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
"GNU General Public License for more details.\n"
"\n"
"You should have received a copy of the GNU General Public License\n"
"along with this program; if not, write to the Free Software\n"
"Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307";
	ShowMessage(message);

}

void MenuQuit(GtkMenuItem *menuitem,gpointer data){
	gtk_main_quit();
}


void RadioClicked(GtkToggleButton *button,gpointer data){
	gint value = *(gint *)data;
	switch (value){
		case DIRECTVIDEO:
			gtk_widget_hide(interface.videoProcessingVbox);
			output_config.process_video = 0;
			break;
		case PROCESSVIDEO:
			gtk_widget_show(interface.videoProcessingVbox);
			output_config.process_video = 1;
			break;
		case DIRECTAUDIO:
			gtk_widget_hide(interface.audioProcessingVbox);
			output_config.process_audio = 0;
			break;
		case PROCESSAUDIO:
			gtk_widget_show(interface.audioProcessingVbox);
			output_config.process_audio = 1;
			break;
		default:
			g_print("ERROR: I should never get here!\n");
			g_print("Value received was %d\n",value);
			break;
	}
	MakeTranscodeLine();
	UpdateProjectedFileSize();
}


/* callbacks */

void CloseTheApp(GtkWidget *window, gpointer data){
	gtk_main_quit();
}

/***************************************************************************
 * update the projected video size
 **************************************************************************/
void UpdateVideoSize(GtkWidget *Entry, gpointer data){
	UpdateProjectedFileSize();
}
void UpdateAudioSize(GtkWidget *Entry, gpointer data){
	UpdateProjectedFileSize();
}

void StopTranscode(GtkWidget *Entry, gpointer data){
	output_config.running = FALSE;
}


void UpdateProjectedFileSize(void){
	double Size;
	gchar *bitrate;
	double framerate;
	gchar Text[25];
	double total=0;
	
	sprintf(Text,"N/A MB");
	gtk_label_set_text(GTK_LABEL(interface.fileSizeVideo),Text);
	gtk_label_set_text(GTK_LABEL(interface.fileSizeVideoOverhead),Text);
	gtk_label_set_text(GTK_LABEL(interface.fileSizeAudio),Text);
	gtk_label_set_text(GTK_LABEL(interface.fileSizeAudioOverhead),Text);
	gtk_label_set_text(GTK_LABEL(interface.fileSizeTotal),Text);
	
	/* Video Bitrates */
	if(output_config.process_video){
		bitrate =  gtk_editable_get_chars(GTK_EDITABLE(interface.exportVideoBitrateEntry),0,-1);
		Size = atof(bitrate);
		if(!(Size)){Size=1800;} /* set bitrate to 1800 if not specified */
		framerate = atof(gtk_editable_get_chars(GTK_EDITABLE(GTK_COMBO(interface.exportFramerateCombo)->entry),0,-1));
		if(!(framerate)){
			framerate = atof(tcprobe_data.framerate);
		}
		if(framerate){
			Size = Size*tcprobe_data.length_frames/framerate/8.0/1024.0;
			total = total+Size;
			sprintf(Text,"%.1f MB",Size);
			gtk_label_set_text(GTK_LABEL(interface.fileSizeVideo),Text);
		}
		if(tcprobe_data.length_frames){
			Size = .35*tcprobe_data.length_frames/8.0/1024.0;
			total = total+Size;
			sprintf(Text,"%.1f MB",Size);
			gtk_label_set_text(GTK_LABEL(interface.fileSizeVideoOverhead),Text);
		}
	}
	
	/* Audio Bitrates */
	if(output_config.process_audio){
		bitrate =  gtk_editable_get_chars(GTK_EDITABLE(GTK_COMBO(interface.exportAudioBitrateCombo)->entry),0,-1);
		Size = atof(bitrate);
		if(!(Size)){Size=128;} /* set bitrate to 128 if not specified */
		framerate = atof(gtk_editable_get_chars(GTK_EDITABLE(GTK_COMBO(interface.exportFramerateCombo)->entry),0,-1));
		if(!(framerate)){
			framerate = atof(tcprobe_data.framerate);
		}
		if(framerate){
			Size = Size*tcprobe_data.length_frames/framerate/8.0/1024.0;
			total = total+Size;
			sprintf(Text,"%.1f MB",Size);
			gtk_label_set_text(GTK_LABEL(interface.fileSizeAudio),Text);
		}
		if(tcprobe_data.length_frames){
			Size = .12*tcprobe_data.length_frames/8.0/1024.0;
			total = total+Size;
			sprintf(Text,"%.1f MB",Size);
			gtk_label_set_text(GTK_LABEL(interface.fileSizeAudioOverhead),Text);
		}
	}
	if(output_config.process_audio && output_config.process_video){
		sprintf(Text,"%.1f MB",total);
		gtk_label_set_text(GTK_LABEL(interface.fileSizeTotal),Text);
	}
}


/****************************************************************************
 * update height as width is adjusted (if keep aspect ratio selected)
 ***************************************************************************/
void UpdateRatioWidth(GtkWidget *Entry, gpointer data){
	double aspectRatio;
	gchar *widthEntry;
	gchar newHeightEntry[10];

	if(output_config.aspectRatio && !interface.aspectLock && tcprobe_data.height){
		
		widthEntry = gtk_editable_get_chars(GTK_EDITABLE(Entry),0,-1);
		aspectRatio = (double)tcprobe_data.width/tcprobe_data.height;
		sprintf(newHeightEntry,"%d",(int)(rint(atof(widthEntry)/aspectRatio)));
		interface.aspectLock = TRUE;
		gtk_entry_set_text(GTK_ENTRY(interface.exportSizeHeightEntry),newHeightEntry);
		interface.aspectLock = FALSE;
	}
	MakeTranscodeLine();
}

/****************************************************************************
 * update width as heigth is adjusted (if keep aspect ratio selected)
 ***************************************************************************/
void UpdateRatioHeight(GtkWidget *Entry, gpointer data){
	double aspectRatio;
	gchar *heightEntry;
	gchar newWidthEntry[10];

	if(output_config.aspectRatio && !interface.aspectLock && tcprobe_data.width){
		
		heightEntry = gtk_editable_get_chars(GTK_EDITABLE(Entry),0,-1);
		aspectRatio = (double)tcprobe_data.width/tcprobe_data.height;
		sprintf(newWidthEntry,"%d",(int)(rint(aspectRatio*atof(heightEntry))));
		interface.aspectLock = TRUE;
		gtk_entry_set_text(GTK_ENTRY(interface.exportSizeWidthEntry),newWidthEntry);
		interface.aspectLock = FALSE;
	}
	MakeTranscodeLine();
}

void ToggleAspectRatio(GtkWidget *window, gpointer data){
	static gint aspectRatio =1;

	aspectRatio = !aspectRatio; /* toggle */
	output_config.aspectRatio = aspectRatio;
	MakeTranscodeLine();
}

void ToggleButton(GtkWidget *window, gpointer data){
	*(gint *)data = !*(gint *)data;
	MakeTranscodeLine();
}

void MakeBrowseWindow(GtkButton *button, gpointer data){
	GtkWidget *filesel;

	filesel = gtk_file_selection_new("Select File ...");
	gtk_signal_connect(
			GTK_OBJECT(GTK_FILE_SELECTION(filesel)->ok_button),
			"clicked",
			GTK_SIGNAL_FUNC(FileselOK),
			filesel);
	gtk_signal_connect(
			GTK_OBJECT(GTK_FILE_SELECTION(filesel)->cancel_button),
			"clicked",
			GTK_SIGNAL_FUNC(FileselCANCEL),
			filesel);
	gtk_window_set_modal(GTK_WINDOW(filesel),TRUE);
	gtk_widget_show(filesel);
	
}

void MakeBrowseWindowOutput(GtkButton *button, gpointer data){
	GtkWidget *filesel;

	filesel = gtk_file_selection_new("Select File ...");
	gtk_signal_connect(
			GTK_OBJECT(GTK_FILE_SELECTION(filesel)->ok_button),
			"clicked",
			GTK_SIGNAL_FUNC(FileselOKOutput),
			filesel);
	gtk_signal_connect(
			GTK_OBJECT(GTK_FILE_SELECTION(filesel)->cancel_button),
			"clicked",
			GTK_SIGNAL_FUNC(FileselCANCEL),
			filesel);
	gtk_window_set_modal(GTK_WINDOW(filesel),TRUE);
	gtk_widget_show(filesel);
	
}


void FileselOK(GtkButton *button,gpointer data){
	gchar *selectedFile;

	selectedFile = gtk_file_selection_get_filename(GTK_FILE_SELECTION(data));
	gtk_entry_set_text(GTK_ENTRY(interface.inputVideoEntry),selectedFile);
	gtk_widget_destroy(GTK_WIDGET(data));
	ProbeVideoFile(GTK_WIDGET(interface.inputVideoEntry),interface.probedLabel);


	//MakeTranscodeLine();
}

void CloseDialog( GtkButton * button, gpointer data ){
   gtk_widget_destroy ( GTK_WIDGET ( data ) );
}

void FileselOKOutput(GtkButton *button,gpointer data){
	gchar *selectedFile;

	selectedFile = gtk_file_selection_get_filename(GTK_FILE_SELECTION(data));
	gtk_entry_set_text(GTK_ENTRY(interface.outputVideoEntry),selectedFile);
	gtk_widget_destroy(GTK_WIDGET(data));
	MakeTranscodeLine();
}

void FileselCANCEL(GtkButton *button,gpointer data){
	gtk_widget_destroy(GTK_WIDGET(data));
}

void ProbeVideoFile(GtkWidget *Entry, gpointer data){
	gchar *text;
	gchar text_tmp[256];
	FILE *exist_check;
	GString *probedData;
	
	/* initialize values */
	tcprobe_data.width = 0;
	tcprobe_data.height = 0;
	tcprobe_data.audio_rate = 0;
	tcprobe_data.audio_size = 0;
	tcprobe_data.audio_channels = 0;
	tcprobe_data.length_frames = 0;
	tcprobe_data.length_h = 0;
	tcprobe_data.length_m = 0;
	tcprobe_data.length_s = 0;


	/* get text from entry box */
	text = gtk_editable_get_chars(GTK_EDITABLE(Entry),0,-1);
	if((exist_check = fopen((char *)text,"r"))==NULL){
		gtk_label_set_text(GTK_LABEL(data),"ERROR: File does not exist!");
	}else{
		close(exist_check);
		if(tcprobe(text,&tcprobe_data)){

			/* update filesize */
			UpdateProjectedFileSize();

			/* we had an error running tcprobe */
			gtk_label_set_text(GTK_LABEL(data),"ERROR: tcprobe -i doesn't work with this file!\nRun it manually to see what errors it may be getting.");
		}else{

			/*collect data and display on label */
			probedData = g_string_new("File: ");
			probedData = g_string_append(probedData,text);
			sprintf(text_tmp," (%d files)\n",tcprobe_data.num_files);
			probedData = g_string_append(probedData,text_tmp);
		
			/* video info */
			sprintf(text_tmp,"Size: %dx%d\n",tcprobe_data.width,tcprobe_data.height);
			probedData = g_string_append(probedData,text_tmp);
			sprintf(text_tmp,"Frame Rate: %s frames/sec\n",tcprobe_data.framerate);
			probedData = g_string_append(probedData,text_tmp);
			if(tcprobe_data.length_frames){
				sprintf(text_tmp,"Length: %d frames => %dh %dm %ds\n",
						tcprobe_data.length_frames,
						tcprobe_data.length_h,
						tcprobe_data.length_m,
						tcprobe_data.length_s);
				probedData = g_string_append(probedData,text_tmp);
			}
	
			/* audio info */
			if(tcprobe_data.audio_rate){
				sprintf(text_tmp,"Audio: %d Hz, %d bit/sample, %d channels\n",
						tcprobe_data.audio_rate,
						tcprobe_data.audio_size,
						tcprobe_data.audio_channels);
				probedData = g_string_append(probedData,text_tmp);
			}

			gtk_label_set_text(GTK_LABEL(data),probedData->str);
			sprintf(text_tmp,"%d",	tcprobe_data.width);
			gtk_entry_set_text(GTK_ENTRY(interface.exportSizeWidthEntry),text_tmp);
			sprintf(text_tmp,"%d",	tcprobe_data.height);
			gtk_entry_set_text(GTK_ENTRY(interface.exportSizeHeightEntry),text_tmp);
		}
	}
	gtk_widget_show(data);

	g_free(text);
}
