/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.impl.jxta;

import com.sun.enterprise.ee.cms.core.DistributedStateCache;
import com.sun.enterprise.ee.cms.core.GMSCacheable;
import com.sun.enterprise.ee.cms.core.GMSException;
import com.sun.enterprise.ee.cms.core.GroupHandle;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.cms.impl.common.GMSContextFactory;
import com.sun.enterprise.ee.cms.impl.common.ViewWindow;
import com.sun.enterprise.ee.cms.impl.jxta.DistributedStateCacheImpl;
import com.sun.enterprise.ee.cms.impl.jxta.GMSContext;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import com.sun.enterprise.ee.cms.spi.GMSMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GroupHandleImpl
implements GroupHandle {
    private String groupName;
    private String serverToken;
    private GMSContext ctx;
    private static final Logger logger = GMSLogDomain.getLogger("ShoalLogger");
    private static final String REC_PROGRESS_STATE = GroupManagementService.RECOVERY_STATE.RECOVERY_IN_PROGRESS.toString();
    private static final String REC_APPOINTED_STATE = GroupManagementService.RECOVERY_STATE.RECOVERY_SERVER_APPOINTED.toString();
    private static final int SYNC_WAIT = 2000;
    private List<String> selfRecoveryList;

    public GroupHandleImpl(String groupName, String serverToken) {
        this.groupName = groupName;
        this.serverToken = serverToken;
        this.selfRecoveryList = new ArrayList<String>();
    }

    private GMSContext getGMSContext() {
        if (this.ctx == null) {
            this.ctx = (GMSContext)GMSContextFactory.getGMSContext(this.groupName);
        }
        return this.ctx;
    }

    @Override
    public void sendMessage(String componentName, byte[] message) throws GMSException {
        GMSMessage gMsg = new GMSMessage(componentName, message, this.groupName, this.getGMSContext().getStartTime());
        this.getGMSContext().getGroupCommunicationProvider().sendMessage(null, gMsg, false);
    }

    @Override
    public void sendMessage(String targetServerToken, String targetComponentName, byte[] message) throws GMSException {
        GMSMessage gMsg = new GMSMessage(targetComponentName, message, this.groupName, this.getGMSContext().getStartTime());
        this.getGMSContext().getGroupCommunicationProvider().sendMessage(targetServerToken, gMsg, false);
    }

    @Override
    public DistributedStateCache getDistributedStateCache() {
        return this.getGMSContext().getDistributedStateCache();
    }

    @Override
    public List<String> getCurrentCoreMembers() {
        ViewWindow viewWindow = this.getGMSContext().getViewWindow();
        return viewWindow.getCurrentCoreMembers();
    }

    @Override
    public List<String> getAllCurrentMembers() {
        ViewWindow viewWindow = this.getGMSContext().getViewWindow();
        return viewWindow.getAllCurrentMembers();
    }

    @Override
    public List<String> getCurrentCoreMembersWithStartTimes() {
        ViewWindow viewWindow = this.getGMSContext().getViewWindow();
        return viewWindow.getCurrentCoreMembersWithStartTimes();
    }

    @Override
    public List<String> getAllCurrentMembersWithStartTimes() {
        ViewWindow viewWindow = this.getGMSContext().getViewWindow();
        return viewWindow.getAllCurrentMembersWithStartTimes();
    }

    @Override
    public void raiseFence(String componentName, String failedMemberToken) throws GMSException {
        if (!this.isFenced(componentName, failedMemberToken)) {
            DistributedStateCache dsc = this.getGMSContext().getDistributedStateCache();
            dsc.addToCache(componentName, this.getGMSContext().getServerIdentityToken(), (Serializable)((Object)failedMemberToken), (Serializable)((Object)GroupHandleImpl.setStateAndTime()));
            if (this.fenceForSelfRecovery(failedMemberToken)) {
                this.saveRaisedFenceState(componentName, failedMemberToken);
            }
            logger.log(Level.FINE, "Fence raised for member " + failedMemberToken + " by member " + this.getGMSContext().getServerIdentityToken() + " component " + componentName);
        }
    }

    private void saveRaisedFenceState(String componentName, String failedMemberToken) {
        this.selfRecoveryList.add(componentName + failedMemberToken);
    }

    private boolean fenceForSelfRecovery(String failedMemberToken) {
        return failedMemberToken.equals(this.getGMSContext().getServerIdentityToken());
    }

    @Override
    public void lowerFence(String componentName, String failedMemberToken) throws GMSException {
        if (this.isFenced(componentName, failedMemberToken) || this.selfRecoveryList.contains(componentName + failedMemberToken)) {
            DistributedStateCache dsc = this.getGMSContext().getDistributedStateCache();
            dsc.removeFromCache(componentName, this.getGMSContext().getServerIdentityToken(), (Serializable)((Object)failedMemberToken));
            logger.log(Level.FINE, "Fence lowered for member " + failedMemberToken + " by member " + this.getGMSContext().getServerIdentityToken() + " component " + componentName);
            this.removeRecoveryAppointments(dsc.getFromCache(failedMemberToken), failedMemberToken);
            this.selfRecoveryList.remove(componentName + failedMemberToken);
        }
    }

    private void removeRecoveryAppointments(Map<GMSCacheable, Object> fromCache, String failedMemberToken) throws GMSException {
        DistributedStateCache dsc = this.getGMSContext().getDistributedStateCache();
        for (GMSCacheable cKey : fromCache.keySet()) {
            if (!cKey.getKey().equals(failedMemberToken) || !fromCache.get(cKey).toString().startsWith(REC_APPOINTED_STATE)) continue;
            dsc.removeFromCache(cKey.getComponentName(), cKey.getMemberTokenId(), (Serializable)cKey.getKey());
        }
    }

    @Override
    public boolean isFenced(String componentName, String memberToken) {
        boolean retval = false;
        DistributedStateCache dsc = this.getDistributedStateCache();
        List<String> members = this.getAllCurrentMembers();
        int count = 0;
        while (members.size() > 1 && !dsc.isFirstSyncDone()) {
            logger.log(Level.FINE, "Waiting for DSC first Sync");
            try {
                Thread.sleep(2000L);
                if (++count <= 4) continue;
                this.forceDSCSync((DistributedStateCacheImpl)dsc);
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, e.getLocalizedMessage());
            }
        }
        Map<GMSCacheable, Object> entries = dsc.getFromCache(memberToken);
        for (GMSCacheable c : entries.keySet()) {
            if (!componentName.equals(c.getComponentName()) || !memberToken.equals(c.getKey()) || memberToken.equals(c.getMemberTokenId()) || !((String)entries.get(c)).startsWith(REC_PROGRESS_STATE)) continue;
            logger.log(Level.FINER, c.toString() + " value:" + entries.get(c));
            logger.log(Level.FINER, "Returning true for isFenced query");
            retval = true;
            break;
        }
        return retval;
    }

    private void forceDSCSync(DistributedStateCacheImpl dsc) {
        try {
            String token = this.getGMSContext().getGroupCommunicationProvider().getGroupLeader();
            logger.log(Level.FINE, "Force Syncing DistributedStateCache with " + token);
            dsc.syncCache(token, true);
        }
        catch (GMSException e) {
            logger.log(Level.WARNING, "Force Syncing of DistributedStateCache failed:" + e.getLocalizedMessage());
        }
    }

    @Override
    public boolean isMemberAlive(String memberToken) {
        return memberToken.equals(this.serverToken) || this.getAllCurrentMembers().contains(memberToken);
    }

    @Override
    public String getGroupLeader() {
        return this.getGMSContext().getGroupCommunicationProvider().getGroupLeader();
    }

    @Override
    public boolean isGroupLeader() {
        return this.getGMSContext().getGroupCommunicationProvider().isGroupLeader();
    }

    public List<String> getSuspectList() {
        return this.getGMSContext().getSuspectList();
    }

    public String toString() {
        return this.getClass().getName();
    }

    private static String setStateAndTime() {
        return GroupManagementService.RECOVERY_STATE.RECOVERY_IN_PROGRESS.toString() + "|" + System.currentTimeMillis();
    }
}

