/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.impl.jxta;

import com.sun.enterprise.ee.cms.core.DistributedStateCache;
import com.sun.enterprise.ee.cms.core.GMSCacheable;
import com.sun.enterprise.ee.cms.core.GMSException;
import com.sun.enterprise.ee.cms.impl.common.DSCMessage;
import com.sun.enterprise.ee.cms.impl.common.GMSContextFactory;
import com.sun.enterprise.ee.cms.impl.jxta.GMSContext;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributedStateCacheImpl
implements DistributedStateCache {
    private final ConcurrentHashMap<GMSCacheable, Object> cache = new ConcurrentHashMap();
    private GMSContext ctx = null;
    private final Logger logger = GMSLogDomain.getLogger("ShoalLogger");
    private boolean firstSyncDone = false;
    private static final Map<String, DistributedStateCacheImpl> ctxCache = new HashMap<String, DistributedStateCacheImpl>();
    private final String groupName;

    private DistributedStateCacheImpl(String groupName) {
        this.groupName = groupName;
    }

    static DistributedStateCache getInstance(String groupName) {
        DistributedStateCacheImpl instance;
        if (ctxCache.get(groupName) == null) {
            instance = new DistributedStateCacheImpl(groupName);
            ctxCache.put(groupName, instance);
        } else {
            instance = ctxCache.get(groupName);
        }
        return instance;
    }

    @Override
    public void addToCache(String componentName, String memberTokenId, Serializable key, Serializable state) throws GMSException {
        this.logger.log(Level.FINER, "Adding to DSC by local Member:" + memberTokenId + ",Component:" + componentName + ",key:" + key + ",State:" + state);
        GMSCacheable cKey = DistributedStateCacheImpl.createCompositeKey(componentName, memberTokenId, key);
        this.addToLocalCache(cKey, state);
        this.addToRemoteCache(cKey, state);
    }

    public void addToCache(String componentName, String memberTokenId, Serializable key, byte[] state) throws GMSException {
        this.logger.log(Level.FINER, "Adding to DSC by local Member:" + memberTokenId + ",Component:" + componentName + ",key:" + key + ",State:" + state);
        GMSCacheable cKey = DistributedStateCacheImpl.createCompositeKey(componentName, memberTokenId, key);
        this.addToLocalCache(cKey, state);
        this.addToRemoteCache(cKey, state);
    }

    @Override
    public void addToLocalCache(String componentName, String memberTokenId, Serializable key, Serializable state) {
        GMSCacheable cKey = DistributedStateCacheImpl.createCompositeKey(componentName, memberTokenId, key);
        this.addToLocalCache(cKey, state);
    }

    public void addToLocalCache(String componentName, String memberTokenId, Serializable key, byte[] state) {
        GMSCacheable cKey = DistributedStateCacheImpl.createCompositeKey(componentName, memberTokenId, key);
        this.addToLocalCache(cKey, state);
    }

    public void addToLocalCache(GMSCacheable cKey, Object state) {
        cKey = this.getTrueKey(cKey);
        this.logger.log(Level.FINEST, "Adding cKey=" + cKey.toString() + " state=" + state.toString());
        this.cache.put(cKey, state);
        this.printDSCContents();
    }

    private void printDSCContents() {
        this.logger.log(Level.FINER, this.getGMSContext().getServerIdentityToken() + ":DSC now contains ---------\n" + this.getDSCContents());
    }

    private GMSContext getGMSContext() {
        if (this.ctx == null) {
            this.ctx = (GMSContext)GMSContextFactory.getGMSContext(this.groupName);
        }
        return this.ctx;
    }

    private String getDSCContents() {
        StringBuffer buf = new StringBuffer();
        ConcurrentHashMap<GMSCacheable, Object> copy = new ConcurrentHashMap<GMSCacheable, Object>(this.cache);
        for (GMSCacheable c : copy.keySet()) {
            buf.append(c.hashCode()).append(" key=").append(c.toString()).append(" : value=").append(copy.get(c)).append("\n");
        }
        return buf.toString();
    }

    private void addToRemoteCache(GMSCacheable cKey, Object state) throws GMSException {
        DSCMessage msg = new DSCMessage(cKey, state, DSCMessage.OPERATION.ADD.toString());
        this.sendMessage(null, msg);
    }

    @Override
    public void removeFromCache(String componentName, String memberTokenId, Serializable key) throws GMSException {
        GMSCacheable cKey = DistributedStateCacheImpl.createCompositeKey(componentName, memberTokenId, key);
        this.removeFromLocalCache(cKey);
        this.removeFromRemoteCache(cKey);
    }

    void removeFromLocalCache(GMSCacheable cKey) {
        cKey = this.getTrueKey(cKey);
        this.cache.remove(cKey);
    }

    private void removeFromRemoteCache(GMSCacheable cKey) throws GMSException {
        cKey = this.getTrueKey(cKey);
        DSCMessage msg = new DSCMessage(cKey, null, DSCMessage.OPERATION.REMOVE.toString());
        this.sendMessage(null, msg);
    }

    @Override
    public Object getFromCache(String componentName, String memberTokenId, Serializable key) throws GMSException {
        if (key != null && componentName != null && memberTokenId != null) {
            GMSCacheable cKey = DistributedStateCacheImpl.createCompositeKey(componentName, memberTokenId, key);
            cKey = this.getTrueKey(cKey);
            return this.cache.get(cKey);
        }
        throw new GMSException(new StringBuffer().append("DistributedStateCache: ").append("componentName, memberTokenId and key ").append("are required parameters and cannot be null").toString());
    }

    @Override
    public Map<GMSCacheable, Object> getAllCache() {
        return new ConcurrentHashMap<GMSCacheable, Object>(this.cache);
    }

    @Override
    public Map<Serializable, Serializable> getFromCacheForPattern(String componentName, String memberToken) {
        Hashtable<Serializable, Serializable> retval = new Hashtable<Serializable, Serializable>();
        if (componentName == null || memberToken == null) {
            return retval;
        }
        for (GMSCacheable c : this.cache.keySet()) {
            if (!componentName.equals(c.getComponentName()) || !memberToken.equals(c.getMemberTokenId())) continue;
            retval.put((Serializable)c.getKey(), (Serializable)this.cache.get(c));
        }
        if (!retval.isEmpty()) {
            return retval;
        }
        if (!memberToken.equals(this.getGMSContext().getServerIdentityToken())) {
            ConcurrentHashMap<GMSCacheable, Object> temp = new ConcurrentHashMap<GMSCacheable, Object>(this.cache);
            DSCMessage msg = new DSCMessage(temp, DSCMessage.OPERATION.ADDALLLOCAL.toString(), true);
            try {
                this.sendMessage(memberToken, msg);
                Thread.sleep(3000L);
                retval.putAll(this.getFromCacheForPattern(componentName, memberToken));
            }
            catch (GMSException e) {
                this.logger.log(Level.WARNING, "GMSException during DistributedStateCache Sync...." + e);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (retval.isEmpty()) {
            this.logger.finer("retVal is empty");
        }
        return retval;
    }

    @Override
    public Map<GMSCacheable, Object> getFromCache(Object key) {
        Hashtable<GMSCacheable, Object> retval = new Hashtable<GMSCacheable, Object>();
        for (GMSCacheable c : this.cache.keySet()) {
            if (!key.equals(c.getComponentName()) && !key.equals(c.getMemberTokenId()) && !key.equals(c.getKey())) continue;
            retval.put(c, this.cache.get(c));
        }
        return retval;
    }

    @Override
    public boolean contains(Object key) {
        boolean retval = false;
        for (GMSCacheable c : this.cache.keySet()) {
            this.logger.log(Level.FINER, new StringBuffer().append("key=").append(key).append(" underlying key=").append(c.getKey()).toString());
            if (!key.equals(c.getKey())) continue;
            retval = true;
        }
        return retval;
    }

    @Override
    public boolean contains(String componentName, Object key) {
        boolean retval = false;
        for (GMSCacheable c : this.cache.keySet()) {
            this.logger.log(Level.FINER, new StringBuffer().append("comp=").append(componentName).append(" underlying comp=").append(c.getComponentName()).toString());
            this.logger.log(Level.FINER, new StringBuffer().append("key=").append(key).append(" underlying key=").append(c.getKey()).toString());
            if (!key.equals(c.getKey()) || !componentName.equals(c.getComponentName())) continue;
            retval = true;
        }
        return retval;
    }

    void addAllToLocalCache(Map<GMSCacheable, Object> map) {
        if (map != null && map.size() > 0) {
            this.cache.putAll(map);
        }
        this.firstSyncDone = true;
        this.logger.log(Level.FINER, "done adding all to Distributed State Cache");
    }

    void addAllToRemoteCache() throws GMSException {
        ConcurrentHashMap<GMSCacheable, Object> temp = new ConcurrentHashMap<GMSCacheable, Object>(this.cache);
        DSCMessage msg = new DSCMessage(temp, DSCMessage.OPERATION.ADDALLREMOTE.toString(), false);
        this.sendMessage(null, msg);
    }

    void removeAllFromCache(String componentName, String memberTokenId, List<Serializable> exempted) {
    }

    Hashtable<GMSCacheable, Object> getAllEntries() {
        Hashtable<GMSCacheable, Object> temp = new Hashtable<GMSCacheable, Object>();
        for (GMSCacheable key : this.cache.keySet()) {
            temp.put(key, this.cache.get(key));
        }
        return temp;
    }

    void syncCache(String memberToken, boolean isCoordinator) throws GMSException {
        ConcurrentHashMap<GMSCacheable, Object> temp = new ConcurrentHashMap<GMSCacheable, Object>(this.cache);
        DSCMessage msg = new DSCMessage(temp, DSCMessage.OPERATION.ADDALLLOCAL.toString(), isCoordinator);
        if (!memberToken.equals(this.getGMSContext().getServerIdentityToken())) {
            this.logger.log(Level.FINER, "Sending sync message from DistributedStateCache to member " + memberToken);
            this.sendMessage(memberToken, msg);
        }
        if (isCoordinator) {
            this.firstSyncDone = true;
        }
    }

    private GMSCacheable getTrueKey(GMSCacheable cKey) {
        Set keys = this.cache.keySet();
        for (GMSCacheable comp : keys) {
            if (!comp.equals(cKey)) continue;
            cKey = comp;
            break;
        }
        return cKey;
    }

    private static GMSCacheable createCompositeKey(String componentName, String memberTokenId, Object key) {
        return new GMSCacheable(componentName, memberTokenId, key);
    }

    private void sendMessage(String member, DSCMessage msg) throws GMSException {
        this.getGMSContext().getGroupCommunicationProvider().sendMessage(member, msg, true);
    }

    @Override
    public boolean isFirstSyncDone() {
        return this.firstSyncDone;
    }

    @Override
    public void removeAll() {
        this.cache.clear();
    }

    @Override
    public void removeAllForMember(String memberToken) {
        Set<GMSCacheable> keys = this.getFromCache(memberToken).keySet();
        for (GMSCacheable key : keys) {
            this.removeFromLocalCache(key);
        }
    }
}

