/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.jsf.bean;

import com.sun.enterprise.tools.admingui.util.GuiUtil;
import com.sun.jbi.jsf.bean.AlertBean;
import com.sun.jbi.jsf.util.BeanUtilities;
import com.sun.jbi.jsf.util.I18nUtilities;
import com.sun.jbi.jsf.util.JBILogger;
import com.sun.jbi.ui.common.JBIAdminCommands;
import com.sun.jbi.ui.common.JBIManagementMessage;
import com.sun.jbi.ui.common.JBIRemoteException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;

public class OperationBean {
    public static final String OPERATION_SHUT_DOWN = "Shut Down";
    public static final String OPERATION_START = "Start";
    public static final String OPERATION_STOP = "Stop";
    private static Logger sLog = JBILogger.getInstance();
    private JBIAdminCommands mJac = BeanUtilities.getClient();
    private String mJbiAutoInstallDir;
    private String mHeartBeatInterval;

    public Properties shutDown(Properties aRequestResponse, List aTargetsList) {
        sLog.fine("OperationBean.shutDown(" + aRequestResponse + ", " + aTargetsList + ")");
        Properties result = this.doCommand(OPERATION_SHUT_DOWN, aRequestResponse, aTargetsList);
        sLog.fine("OperationBean.shutDown(), result=" + aRequestResponse);
        return result;
    }

    public Properties start(Properties aRequestResponse, List aTargetsList) {
        sLog.fine("OperationBean.start(" + aRequestResponse + ", " + aTargetsList + ")");
        Properties result = this.doCommand(OPERATION_START, aRequestResponse, aTargetsList);
        sLog.fine("OperationBean.start(), result=" + aRequestResponse);
        return result;
    }

    public Properties stop(Properties aRequestResponse, List aTargetsList) {
        sLog.fine("OperationBean.stop(" + aRequestResponse + ", " + aTargetsList + ")");
        Properties result = this.doCommand(OPERATION_STOP, aRequestResponse, aTargetsList);
        sLog.fine("OperationBean.stop(), result=" + aRequestResponse);
        return result;
    }

    public String getValueShutDown() {
        return OPERATION_SHUT_DOWN;
    }

    public String getValueStart() {
        return OPERATION_START;
    }

    public String getValueStop() {
        return OPERATION_STOP;
    }

    private Properties doCommand(String anOperation, Properties aRequestResponse, List aTargetsList) {
        int targetDownCount = 0;
        String downTargetsList = "";
        sLog.fine("OperationBean.doCommand(" + anOperation + ", " + aRequestResponse + ", " + aTargetsList + ")");
        Properties result = aRequestResponse;
        String jbiName = aRequestResponse.getProperty("name");
        String jbiType = aRequestResponse.getProperty("type");
        String lifeCycleResult = null;
        if (null != this.mJac) {
            for (Properties targetProp : aTargetsList) {
                String target = targetProp.getProperty("name", "server");
                sLog.fine("OperationBean.doCommand(...), target=" + target);
                try {
                    sLog.fine("OperationBean.doCommand(...), target=" + target);
                    if (!this.mJac.isTargetUp(target)) {
                        ++targetDownCount;
                        downTargetsList = "".equals(downTargetsList) ? target : downTargetsList + ", " + target;
                    }
                    sLog.fine("OperationBean.doCommand(...), target=" + target + ", isTargetUp=" + this.mJac.isTargetUp(target) + ", targetDownCount=" + targetDownCount + ", downTargetsList=" + downTargetsList);
                    if ("service-assembly".equals(jbiType)) {
                        if (OPERATION_SHUT_DOWN.equals(anOperation)) {
                            lifeCycleResult = this.mJac.shutdownServiceAssembly(jbiName, target);
                            result.setProperty("success-result", lifeCycleResult);
                            continue;
                        }
                        if (OPERATION_START.equals(anOperation)) {
                            lifeCycleResult = this.mJac.startServiceAssembly(jbiName, target);
                            result.setProperty("success-result", lifeCycleResult);
                            continue;
                        }
                        if (OPERATION_STOP.equals(anOperation)) {
                            lifeCycleResult = this.mJac.stopServiceAssembly(jbiName, target);
                            result.setProperty("success-result", lifeCycleResult);
                            continue;
                        }
                        result.setProperty("failure-result", I18nUtilities.getResourceString("jbi.operate.missing.state") + anOperation);
                        continue;
                    }
                    if ("binding-component".equals(jbiType) || "service-engine".equals(jbiType)) {
                        if (OPERATION_SHUT_DOWN.equals(anOperation)) {
                            lifeCycleResult = this.mJac.shutdownComponent(jbiName, target);
                            sLog.fine("OperationBean.doCommand(...), shutdownComponent jbiName=" + jbiName + ", lifeCycleResult=" + lifeCycleResult);
                            result.setProperty("success-result", lifeCycleResult);
                            continue;
                        }
                        if (OPERATION_START.equals(anOperation)) {
                            lifeCycleResult = this.mJac.startComponent(jbiName, target);
                            sLog.fine("OperationBean.doCommand(...), startComponent jbiName=" + jbiName + ", lifeCycleResult=" + lifeCycleResult);
                            result.setProperty("success-result", lifeCycleResult);
                            continue;
                        }
                        if (OPERATION_STOP.equals(anOperation)) {
                            lifeCycleResult = this.mJac.stopComponent(jbiName, target);
                            sLog.fine("OperationBean.doCommand(...), stopComponent jbiName=" + jbiName + ", lifeCycleResult=" + lifeCycleResult);
                            result.setProperty("success-result", lifeCycleResult);
                            continue;
                        }
                        result.setProperty("failure-result", I18nUtilities.getResourceString("jbi.operate.missing.state") + anOperation);
                        continue;
                    }
                    if ("shared-library".equals(jbiType)) {
                        result.setProperty("failure-result", I18nUtilities.getResourceString("jbi.operate.lib.error"));
                        continue;
                    }
                    result.setProperty("failure-result", I18nUtilities.getResourceString("jbi.operate.missing.type") + jbiType);
                }
                catch (JBIRemoteException jbiRemoteEx) {
                    jbiRemoteEx.printStackTrace(System.err);
                    JBIManagementMessage mgmtMsg = BeanUtilities.extractJBIManagementMessage((Exception)((Object)jbiRemoteEx));
                    if (mgmtMsg == null) {
                        String internalErrorMsg = I18nUtilities.getResourceString("jbi.internal.error.invalid.remote.exception");
                        result.setProperty("internal-error", internalErrorMsg);
                        result.setProperty("failure-result", internalErrorMsg);
                        sLog.fine("OperationBean.doCommand(...), catch (empty) jbiRemoteEx; mgmtMsg=null, intnernalErrorMsg=" + internalErrorMsg);
                        continue;
                    }
                    String msg = mgmtMsg.getMessage();
                    msg = msg.replaceAll("\n", "<br />");
                    result.setProperty("failure-result", msg);
                    sLog.fine("OperationBean.doCommand(...), catch (valid) jbiRemoteEx; mgmtMsg.getMessage=" + msg);
                }
                catch (Exception e) {
                    String internalErrorMsg = I18nUtilities.getResourceString("jbi.internal.error.invalid.remote.exception");
                    result.setProperty("internal-error", internalErrorMsg);
                    sLog.fine("OperationBean.doCommand(...), catch (empty) Exception; mgmtMsg=null, intnernalErrorMsg=" + internalErrorMsg);
                }
            }
            if (targetDownCount > 0) {
                Object[] args = new Object[]{downTargetsList, jbiName};
                String resultString = "";
                if (targetDownCount == 1) {
                    result.setProperty("warning-summary", I18nUtilities.getResourceString("jbi.operation.deferred.target.summary"));
                    resultString = GuiUtil.getMessage((String)I18nUtilities.getResourceString("jbi.operation.deferred.target.down.msg"), (Object[])args);
                } else {
                    result.setProperty("warning-summary", I18nUtilities.getResourceString("jbi.operation.deferred.targets.summary"));
                    resultString = GuiUtil.getMessage((String)I18nUtilities.getResourceString("jbi.operation.deferred.targets.down.msg"), (Object[])args);
                }
                result.setProperty("warning-result", resultString);
            }
        } else {
            result.setProperty("failure-result", I18nUtilities.getResourceString("jbi.missing.admin.client"));
        }
        sLog.fine("OperationBean.doCommand(" + anOperation + ", " + aRequestResponse + ", " + aTargetsList + "), result=" + result);
        return result;
    }

    public void validateField(FacesContext aContext, UIComponent aComponent, Object aValue) throws ValidatorException {
        sLog.fine("OperationBean.validateField(" + aContext + ", aComponent=" + aComponent + ", aValue=" + aValue);
        String alertDetail = "";
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Map sessionMap = (Map)facesContext.getApplication().createValueBinding("#{sessionScope}").getValue(facesContext);
        String textFieldId = aComponent.getClientId(facesContext);
        String propertyName = (String)sessionMap.get(textFieldId);
        sLog.finer("OperationBean.validateField before sessionMap=" + sessionMap);
        boolean isValid = false;
        if (aValue instanceof String && null != propertyName) {
            isValid = this.validatePropertyNameValueInRange(propertyName, (String)aValue);
        }
        sLog.fine("OperationBean.validateField(...), aValue=" + aValue + ", isValid=" + isValid);
        if (!isValid) {
            Properties alertDetailProperties = (Properties)sessionMap.get("jbiAlertDetailProperties");
            Properties propertyLabels = (Properties)sessionMap.get("jbiAlertPropertyLabels");
            if (null != alertDetailProperties) {
                Properties metadata = this.getJbiRtConfigMetadata(propertyName);
                String failedValidationRangeMessage = this.getFailedValidationRangeMessage(metadata, propertyLabels);
                alertDetailProperties.put(propertyName, failedValidationRangeMessage);
                for (Object object : alertDetailProperties.keySet()) {
                    String k = (String)object;
                    String v = alertDetailProperties.getProperty(k);
                    sLog.finer("OperationBean.validateField(...), alertDetailProperties k=" + k + ", v=" + v);
                    if ("".equals(v)) continue;
                    alertDetail = v + "<br />" + alertDetail;
                }
            }
            AlertBean alertBean = BeanUtilities.getAlertBean();
            alertBean.setAlertType("error");
            alertBean.setAlertSummary(I18nUtilities.getResourceString("jbi.configure.component.alert.summary"));
            alertBean.setAlertDetail(alertDetail);
            String msgString = textFieldId;
            sLog.fine("OperationBean.validateField(" + aContext + ", " + aComponent + ", " + aValue + "), msgString=" + msgString);
            FacesMessage facesMessage = new FacesMessage(msgString);
            throw new ValidatorException(facesMessage);
        }
        sLog.fine("OperationBean.validateField(" + aContext + ", aComponent=" + aComponent + ", aValue=" + aValue + ") validation passed");
    }

    private void showAlert(String aType, String aSummaryMessage, String aDetailsMessage) {
        sLog.fine("OperationBean.showAlert(" + aType + ", " + aSummaryMessage + ", " + aDetailsMessage + ")");
        AlertBean alertBean = BeanUtilities.getAlertBean();
        alertBean.setAlertType(aType);
        alertBean.setAlertSummary(aSummaryMessage);
        alertBean.setAlertDetail(aDetailsMessage);
    }

    private boolean validatePropertyNameValueInRange(String aPropertyName, String aValue) {
        sLog.finer("OperationBean.validatePropertyNameValueInRange(" + aPropertyName + "), " + aValue + ")");
        boolean result = false;
        Properties metadata = this.getJbiRtConfigMetadata(aPropertyName);
        try {
            int value = Integer.parseInt(aValue);
            if (null != metadata) {
                int minValue = this.getInteger(metadata, "minValue");
                int maxValue = this.getInteger(metadata, "maxValue");
                if (value >= minValue && value <= maxValue) {
                    result = true;
                }
            }
        }
        catch (NumberFormatException nfEx) {
            sLog.fine("OperationBean.validatePropertyNameValueInRange(" + aPropertyName + ", " + aValue + "), caught nfEx=" + nfEx);
        }
        sLog.fine("OperationBean.validatePropertyNameValueInRange(" + aPropertyName + ", " + aValue + "), result=" + result);
        return result;
    }

    private String getFailedValidationRangeMessage(Properties aMetadata, Properties aPropertyLabels) {
        String name;
        sLog.fine("OperationBean.getFailedValidationRangeMessage(" + aMetadata + ", " + aPropertyLabels + ")");
        String result = I18nUtilities.getResourceString("jbi.root.configuration.failed.validation.internal.error.message");
        if (null != aMetadata && null != aPropertyLabels && null != (name = (String)aMetadata.get("name"))) {
            String label = (String)aPropertyLabels.get(name);
            String minValue = (String)aMetadata.get("minValue");
            String maxValue = (String)aMetadata.get("maxValue");
            Object[] args = new Object[]{label, minValue, maxValue};
            result = GuiUtil.getMessage((String)I18nUtilities.getResourceString("jbi.root.configuration.failed.validation.range.message"), (Object[])args);
        }
        sLog.fine("OperationBean.getFailedValidationRangeMessage(" + aMetadata + "), result=" + result);
        return result;
    }

    private int getInteger(Properties aMetadata, String aKey) throws NumberFormatException {
        sLog.fine("OperationBean.getInteger(" + aMetadata + ", " + aKey + ")");
        int result = -1;
        String intString = aMetadata.getProperty(aKey);
        if (null != intString) {
            int parsedInt;
            result = parsedInt = Integer.parseInt(intString);
        }
        sLog.fine("OperationBean.getInteger(" + aMetadata + ", " + aKey + "), result=" + result);
        return result;
    }

    private Properties getJbiRtConfigMetadata(String aPropertyName) {
        Properties result = new Properties();
        sLog.fine("OperationBean.getJbiRtConfigMetadata(" + aPropertyName + ")");
        try {
            Properties metadata = this.mJac.getRuntimeConfigurationMetaData(aPropertyName);
            sLog.fine("OperationBean.getMetadata(" + aPropertyName + "), metadata=" + metadata);
            result = metadata;
        }
        catch (JBIRemoteException jbiRemoteEx) {
            jbiRemoteEx.printStackTrace();
        }
        sLog.fine("OperationBean.getJbiRtConfigMetadata(" + aPropertyName + "), result=" + result);
        return result;
    }
}

