/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mfwk.agent.appserv.mapping;

import com.sun.mfwk.agent.appserv.mapping.AS_ObjectNameNotFoundException;
import com.sun.mfwk.agent.appserv.mapping.CMM_ObjectNameNotFoundException;
import com.sun.mfwk.agent.appserv.mapping.MappingHandler;
import com.sun.mfwk.agent.appserv.mapping.MappingQueryService;
import com.sun.mfwk.agent.appserv.modeler.ObjectNameHelper;
import com.sun.mfwk.agent.appserv.util.Utils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class MappingQueryServiceImpl
implements MappingQueryService {
    private Map env = new HashMap();
    private Document doc = null;
    private NodeList AS_Mbeans = null;
    private NodeList keys = null;
    private static final String AS_MBEAN_DESCRIPTOR = "as-mbean";
    private static final String CMM_MBEAN_DESCRIPTOR = "cmm-mbean";
    private static final String AS_ATTRIBUTE_NAME = "as-name";
    private static final String CMM_ATTRIBUTE_NAME = "cmm-name";
    private static final String ATTRIBUTE_DESCRIPTOR = "attribute";
    private static final String DEF_ATTRIBUTE_DESCRIPTOR = "default-attribute";
    private static final String PROPERTY_DESCRIPTOR = "property";
    private static final String NAME = "name";
    private static final String OBJECT_NAME = "objectName";
    private static final String TYPE_STR = "type";
    private static final String J2EE_TYPE_STR = "j2eeType";
    private static final String FILTER_CLASS_NAME = "filter-class";
    private static final String FILTER_ID = "filter-id";
    private static final String FILTER_METHOD = "mappingHandler";
    private static final String TYPE = "type";
    private static final String KEY_MATCHERS = "key-matcher";
    private static final String PROPERTY_NAME = "name";
    private static final String PROPERTY_VALUE = "value";
    private static final String ATTRIBUTE_HANDLER = "attribute-handler";
    private static final String HANDLER_CLASS = "handler-class";
    public static final Class[] HANDLER_ARGS = new Class[]{String.class, Element.class, MappingQueryService.class};

    public MappingQueryServiceImpl(String uri, String dLocation, String server, String domain) throws IOException {
        this.env.put("server.name", server);
        this.env.put("domain.name", domain);
        this.doc = Utils.getDocument(uri, dLocation);
        if (this.doc == null) {
            throw new IOException("Unable to read mapping xml file");
        }
    }

    public Object getProperty(String key) {
        return this.env.get(key);
    }

    public NodeList getAS_Mbeans() {
        if (this.AS_Mbeans == null) {
            this.AS_Mbeans = this.doc.getElementsByTagName(AS_MBEAN_DESCRIPTOR);
        }
        if (this.keys == null) {
            this.keys = this.doc.getElementsByTagName(KEY_MATCHERS);
        }
        return this.AS_Mbeans;
    }

    private String getKeyProperty(String objectName, String type) throws MalformedObjectNameException {
        ObjectName on = new ObjectName(objectName);
        return on.getKeyProperty(type);
    }

    public Element getAS_Mbean(String AS_ObjectName) throws AS_ObjectNameNotFoundException {
        Element elem = null;
        Object objectType = null;
        String type = null;
        String typeKey = null;
        NodeList nodes = this.getAS_Mbeans();
        int keyLength = this.keys.getLength();
        for (int i = 0; i < keyLength; ++i) {
            String key = ((Element)this.keys.item(i)).getAttribute("key") + "=";
            type = Utils.getStringRegion(AS_ObjectName, key, ",");
            if (type == null) continue;
            typeKey = key;
            break;
        }
        if (type == null) {
            throw new AS_ObjectNameNotFoundException(AS_ObjectName, AS_ObjectName + " does not have any of the valid keys. Check the key-matcher in mapping xml");
        }
        Map map = ObjectNameHelper.getKeysAndProperties(AS_ObjectName);
        int length = nodes.getLength();
        for (int i = 0; i < length; ++i) {
            elem = (Element)nodes.item(i);
            String xmlObjectName = elem.getAttribute(OBJECT_NAME);
            String xmlType = Utils.getStringRegion(xmlObjectName, typeKey, ",");
            if (!type.equals(xmlType) || !ObjectNameHelper.keysMatch(map, xmlObjectName)) continue;
            return elem;
        }
        throw new AS_ObjectNameNotFoundException(AS_ObjectName);
    }

    public NodeList getCMM_Mbeans(String AS_ObjectName) throws AS_ObjectNameNotFoundException {
        return this.getCMM_Mbeans(AS_ObjectName, null);
    }

    public NodeList getCMM_Mbeans(String AS_ObjectName, String CMM_Type) throws AS_ObjectNameNotFoundException {
        return this.getCMM_Mbeans(this.getAS_Mbean(AS_ObjectName), AS_ObjectName, CMM_Type);
    }

    private NodeList getCMM_Mbeans(Element AS_MbeanDescriptor, String AS_ObjectName, String CMM_Type) {
        String filterClass = AS_MbeanDescriptor.getAttribute(FILTER_CLASS_NAME);
        if ("".equals(filterClass)) {
            filterClass = null;
        }
        if (filterClass == null && CMM_Type == null) {
            return AS_MbeanDescriptor.getElementsByTagName(CMM_MBEAN_DESCRIPTOR);
        }
        String id = null;
        if (filterClass != null) {
            id = this.callHandler(filterClass, AS_ObjectName, AS_MbeanDescriptor);
        }
        if (id == null && CMM_Type == null) {
            return AS_MbeanDescriptor.getElementsByTagName(CMM_MBEAN_DESCRIPTOR);
        }
        NodeList list = AS_MbeanDescriptor.getElementsByTagName(CMM_MBEAN_DESCRIPTOR);
        DocumentFragment fragment = this.doc.createDocumentFragment();
        for (int i = 0; i < list.getLength(); ++i) {
            Element elem = (Element)list.item(i);
            if (id != null && !id.equals(elem.getAttribute(FILTER_ID)) || CMM_Type != null && !CMM_Type.equals(elem.getAttribute("type"))) continue;
            fragment.appendChild(list.item(i).cloneNode(true));
        }
        return fragment.getChildNodes();
    }

    private String callHandler(String className, String AS_ObjectName, Element elem) {
        try {
            Class<?> handlerClass = Class.forName(className);
            MappingHandler handler = (MappingHandler)handlerClass.newInstance();
            return handler.mappingHandler(AS_ObjectName, elem, this);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error calling user defined handler", ex);
        }
    }

    public String getCMM_ObjectName(Element CMM_MbeanDescriptor) {
        return CMM_MbeanDescriptor.getAttribute(OBJECT_NAME);
    }

    public Map getAttributeMappings(String AS_ObjectName, String CMM_ObjectName) throws AS_ObjectNameNotFoundException, CMM_ObjectNameNotFoundException {
        NodeList CMM_Mbeans = this.getCMM_Mbeans(AS_ObjectName);
        HashMap map = new HashMap();
        int length = CMM_Mbeans.getLength();
        for (int i = 0; i < length; ++i) {
            this.getAttributeMappings((Element)CMM_Mbeans.item(i), map);
        }
        return map;
    }

    public Map getAttributeMappings(Element CMM_MbeanDescriptor) {
        return this.getAttributeMappings(CMM_MbeanDescriptor, new HashMap());
    }

    public NodeList getDefaultAttributeMappings(Element CMM_MbeanDescriptor) {
        return CMM_MbeanDescriptor.getElementsByTagName(DEF_ATTRIBUTE_DESCRIPTOR);
    }

    public boolean isAttributeHandlerDefined(Element CMM_MbeanDescriptor, String asAttr, String cmmAttr) {
        String handler = this.getAttributeHandlerClass(CMM_MbeanDescriptor, asAttr, cmmAttr);
        return handler != null;
    }

    public Map getHandlerAttributeMappings(Element CMM_MbeanDescriptor, String asAttr, String cmmAttr) {
        NodeList properties;
        Element attr = this.findAttribute(CMM_MbeanDescriptor, asAttr, cmmAttr);
        HashMap<String, String> map = new HashMap<String, String>();
        if (attr != null && (properties = attr.getElementsByTagName(PROPERTY_DESCRIPTOR)) != null) {
            int length = properties.getLength();
            for (int i = 0; i < length; ++i) {
                Element property = (Element)properties.item(i);
                map.put(property.getAttribute("name"), property.getAttribute(PROPERTY_VALUE));
            }
        }
        return map;
    }

    public String getAttributeHandlerClass(Element CMM_MbeanDescriptor, String asAttr, String cmmAttr) {
        Element e;
        NodeList attrHandler;
        String handlerClass = null;
        Element attr = this.findAttribute(CMM_MbeanDescriptor, asAttr, cmmAttr);
        if (attr != null && (attrHandler = attr.getElementsByTagName(ATTRIBUTE_HANDLER)) != null && (e = (Element)attrHandler.item(0)) != null) {
            handlerClass = e.getAttribute(HANDLER_CLASS);
        }
        return handlerClass;
    }

    private Element findAttribute(Element CMM_MbeanDescriptor, String asAttr, String cmmAttr) {
        NodeList attributes = CMM_MbeanDescriptor.getElementsByTagName(ATTRIBUTE_DESCRIPTOR);
        Element target = null;
        int length = attributes.getLength();
        for (int i = 0; i < length; ++i) {
            Element attribute = (Element)attributes.item(i);
            String asName = attribute.getAttribute(AS_ATTRIBUTE_NAME);
            String cmmName = attribute.getAttribute(CMM_ATTRIBUTE_NAME);
            if ((asName == null || !asName.equals(asAttr)) && (cmmName == null || !cmmName.equals(cmmAttr))) continue;
            target = attribute;
            break;
        }
        return target;
    }

    private Map getAttributeMappings(Element CMM_MbeanDescriptor, Map map) {
        NodeList attributes = CMM_MbeanDescriptor.getElementsByTagName(ATTRIBUTE_DESCRIPTOR);
        int length = attributes.getLength();
        for (int i = 0; i < length; ++i) {
            Element attribute = (Element)attributes.item(i);
            map.put(attribute.getAttribute(AS_ATTRIBUTE_NAME), attribute.getAttribute(CMM_ATTRIBUTE_NAME));
        }
        return map;
    }
}

