/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.tomcat5;

import java.util.ArrayList;
import org.apache.catalina.Session;
import org.apache.catalina.SessionEvent;
import org.apache.catalina.SessionListener;
import org.apache.coyote.tomcat5.CoyoteResponse;

public class SessionTracker
implements SessionListener {
    private int count;
    private String trackedSessionId;
    private CoyoteResponse response;
    private ArrayList contextNames = new ArrayList(2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionEvent(SessionEvent event) {
        if (!"destroySession".equals(event.getType())) {
            return;
        }
        Session session = event.getSession();
        SessionTracker sessionTracker = this;
        synchronized (sessionTracker) {
            if (session.getIdInternal() != null && session.getIdInternal().equals(this.trackedSessionId) && session.getManager() != null && session.getManager().getContainer() != null && this.contextNames.contains(session.getManager().getContainer().getName())) {
                --this.count;
                if (this.count == 0) {
                    this.trackedSessionId = null;
                    if (this.response != null) {
                        this.response.removeSessionCookies();
                    }
                }
            }
            session.removeSessionListener(this);
        }
    }

    public int getActiveSessions() {
        return this.count;
    }

    public String getSessionId() {
        return this.trackedSessionId;
    }

    public synchronized void track(Session session) {
        if (this.trackedSessionId == null) {
            this.trackedSessionId = session.getIdInternal();
        } else if (!this.trackedSessionId.equals(session.getIdInternal())) {
            throw new IllegalArgumentException("Should never reach here");
        }
        ++this.count;
        if (session.getManager() != null && session.getManager().getContainer() != null && session.getManager().getContainer().getName() != null) {
            this.contextNames.add(session.getManager().getContainer().getName());
        }
        session.addSessionListener(this);
    }

    public synchronized void setResponse(CoyoteResponse response) {
        this.response = response;
    }

    public synchronized void reset() {
        this.count = 0;
        this.trackedSessionId = null;
        this.contextNames.clear();
    }
}

