/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.commons.beanutils;

import com.sun.org.apache.commons.beanutils.Converter;
import com.sun.org.apache.commons.beanutils.converters.BigDecimalConverter;
import com.sun.org.apache.commons.beanutils.converters.BigIntegerConverter;
import com.sun.org.apache.commons.beanutils.converters.BooleanArrayConverter;
import com.sun.org.apache.commons.beanutils.converters.BooleanConverter;
import com.sun.org.apache.commons.beanutils.converters.ByteArrayConverter;
import com.sun.org.apache.commons.beanutils.converters.ByteConverter;
import com.sun.org.apache.commons.beanutils.converters.CharacterArrayConverter;
import com.sun.org.apache.commons.beanutils.converters.CharacterConverter;
import com.sun.org.apache.commons.beanutils.converters.ClassConverter;
import com.sun.org.apache.commons.beanutils.converters.DoubleArrayConverter;
import com.sun.org.apache.commons.beanutils.converters.DoubleConverter;
import com.sun.org.apache.commons.beanutils.converters.FloatArrayConverter;
import com.sun.org.apache.commons.beanutils.converters.FloatConverter;
import com.sun.org.apache.commons.beanutils.converters.IntegerArrayConverter;
import com.sun.org.apache.commons.beanutils.converters.IntegerConverter;
import com.sun.org.apache.commons.beanutils.converters.LongArrayConverter;
import com.sun.org.apache.commons.beanutils.converters.LongConverter;
import com.sun.org.apache.commons.beanutils.converters.ShortArrayConverter;
import com.sun.org.apache.commons.beanutils.converters.ShortConverter;
import com.sun.org.apache.commons.beanutils.converters.SqlDateConverter;
import com.sun.org.apache.commons.beanutils.converters.SqlTimeConverter;
import com.sun.org.apache.commons.beanutils.converters.SqlTimestampConverter;
import com.sun.org.apache.commons.beanutils.converters.StringArrayConverter;
import com.sun.org.apache.commons.beanutils.converters.StringConverter;
import com.sun.org.apache.commons.collections.FastHashMap;
import com.sun.org.apache.commons.logging.Log;
import com.sun.org.apache.commons.logging.LogFactory;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public class ConvertUtils {
    private static Boolean defaultBoolean = Boolean.FALSE;
    private static Byte defaultByte = new Byte(0);
    private static Character defaultCharacter = new Character(' ');
    private static Double defaultDouble = new Double(0.0);
    private static Float defaultFloat = new Float(0.0f);
    private static Integer defaultInteger = new Integer(0);
    private static Long defaultLong = new Long(0L);
    private static Short defaultShort = new Short(0);
    private static FastHashMap converters = new FastHashMap();
    private static Log log;

    public static boolean getDefaultBoolean() {
        return defaultBoolean;
    }

    public static void setDefaultBoolean(boolean newDefaultBoolean) {
        defaultBoolean = new Boolean(newDefaultBoolean);
        converters.put(Boolean.TYPE, new BooleanConverter(defaultBoolean));
        converters.put(Boolean.class, new BooleanConverter(defaultBoolean));
    }

    public static byte getDefaultByte() {
        return defaultByte;
    }

    public static void setDefaultByte(byte newDefaultByte) {
        defaultByte = new Byte(newDefaultByte);
        converters.put(Byte.TYPE, new ByteConverter(defaultByte));
        converters.put(Byte.class, new ByteConverter(defaultByte));
    }

    public static char getDefaultCharacter() {
        return defaultCharacter.charValue();
    }

    public static void setDefaultCharacter(char newDefaultCharacter) {
        defaultCharacter = new Character(newDefaultCharacter);
        converters.put(Character.TYPE, new CharacterConverter(defaultCharacter));
        converters.put(Character.class, new CharacterConverter(defaultCharacter));
    }

    public static double getDefaultDouble() {
        return defaultDouble;
    }

    public static void setDefaultDouble(double newDefaultDouble) {
        defaultDouble = new Double(newDefaultDouble);
        converters.put(Double.TYPE, new DoubleConverter(defaultDouble));
        converters.put(Double.class, new DoubleConverter(defaultDouble));
    }

    public static float getDefaultFloat() {
        return defaultFloat.floatValue();
    }

    public static void setDefaultFloat(float newDefaultFloat) {
        defaultFloat = new Float(newDefaultFloat);
        converters.put(Float.TYPE, new FloatConverter(defaultFloat));
        converters.put(Float.class, new FloatConverter(defaultFloat));
    }

    public static int getDefaultInteger() {
        return defaultInteger;
    }

    public static void setDefaultInteger(int newDefaultInteger) {
        defaultInteger = new Integer(newDefaultInteger);
        converters.put(Integer.TYPE, new IntegerConverter(defaultInteger));
        converters.put(Integer.class, new IntegerConverter(defaultInteger));
    }

    public static long getDefaultLong() {
        return defaultLong;
    }

    public static void setDefaultLong(long newDefaultLong) {
        defaultLong = new Long(newDefaultLong);
        converters.put(Long.TYPE, new LongConverter(defaultLong));
        converters.put(Long.class, new LongConverter(defaultLong));
    }

    public static short getDefaultShort() {
        return defaultShort;
    }

    public static void setDefaultShort(short newDefaultShort) {
        defaultShort = new Short(newDefaultShort);
        converters.put(Short.TYPE, new ShortConverter(defaultShort));
        converters.put(Short.class, new ShortConverter(defaultShort));
    }

    public static String convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            if (Array.getLength(value) < 1) {
                return null;
            }
            if ((value = Array.get(value, 0)) == null) {
                return null;
            }
            Converter converter = (Converter)converters.get(String.class);
            return (String)converter.convert(String.class, value);
        }
        Converter converter = (Converter)converters.get(String.class);
        return (String)converter.convert(String.class, value);
    }

    public static Object convert(String value, Class clazz) {
        Converter converter;
        if (log.isDebugEnabled()) {
            log.debug("Convert string '" + value + "' to class '" + clazz.getName() + "'");
        }
        if ((converter = (Converter)converters.get(clazz)) == null) {
            converter = (Converter)converters.get(String.class);
        }
        if (log.isTraceEnabled()) {
            log.trace("  Using converter " + converter);
        }
        return converter.convert(clazz, value);
    }

    public static Object convert(String[] values, Class clazz) {
        Converter converter;
        Class<?> type = clazz;
        if (clazz.isArray()) {
            type = clazz.getComponentType();
        }
        if (log.isDebugEnabled()) {
            log.debug("Convert String[" + values.length + "] to class '" + type.getName() + "[]'");
        }
        if ((converter = (Converter)converters.get(type)) == null) {
            converter = (Converter)converters.get(String.class);
        }
        if (log.isTraceEnabled()) {
            log.trace("  Using converter " + converter);
        }
        Object array = Array.newInstance(type, values.length);
        for (int i = 0; i < values.length; ++i) {
            Array.set(array, i, converter.convert(type, values[i]));
        }
        return array;
    }

    public static void deregister() {
        boolean[] booleanArray = new boolean[]{};
        byte[] byteArray = new byte[]{};
        char[] charArray = new char[]{};
        double[] doubleArray = new double[]{};
        float[] floatArray = new float[]{};
        int[] intArray = new int[]{};
        long[] longArray = new long[]{};
        short[] shortArray = new short[]{};
        String[] stringArray = new String[]{};
        converters.clear();
        converters.put(BigDecimal.class, new BigDecimalConverter());
        converters.put(BigInteger.class, new BigIntegerConverter());
        converters.put(Boolean.TYPE, new BooleanConverter(defaultBoolean));
        converters.put(Boolean.class, new BooleanConverter(defaultBoolean));
        converters.put(booleanArray.getClass(), new BooleanArrayConverter(booleanArray));
        converters.put(Byte.TYPE, new ByteConverter(defaultByte));
        converters.put(Byte.class, new ByteConverter(defaultByte));
        converters.put(byteArray.getClass(), new ByteArrayConverter(byteArray));
        converters.put(Character.TYPE, new CharacterConverter(defaultCharacter));
        converters.put(Character.class, new CharacterConverter(defaultCharacter));
        converters.put(charArray.getClass(), new CharacterArrayConverter(charArray));
        converters.put(Class.class, new ClassConverter());
        converters.put(Double.TYPE, new DoubleConverter(defaultDouble));
        converters.put(Double.class, new DoubleConverter(defaultDouble));
        converters.put(doubleArray.getClass(), new DoubleArrayConverter(doubleArray));
        converters.put(Float.TYPE, new FloatConverter(defaultFloat));
        converters.put(Float.class, new FloatConverter(defaultFloat));
        converters.put(floatArray.getClass(), new FloatArrayConverter(floatArray));
        converters.put(Integer.TYPE, new IntegerConverter(defaultInteger));
        converters.put(Integer.class, new IntegerConverter(defaultInteger));
        converters.put(intArray.getClass(), new IntegerArrayConverter(intArray));
        converters.put(Long.TYPE, new LongConverter(defaultLong));
        converters.put(Long.class, new LongConverter(defaultLong));
        converters.put(longArray.getClass(), new LongArrayConverter(longArray));
        converters.put(Short.TYPE, new ShortConverter(defaultShort));
        converters.put(Short.class, new ShortConverter(defaultShort));
        converters.put(shortArray.getClass(), new ShortArrayConverter(shortArray));
        converters.put(String.class, new StringConverter());
        converters.put(stringArray.getClass(), new StringArrayConverter(stringArray));
        converters.put(Date.class, new SqlDateConverter());
        converters.put(Time.class, new SqlTimeConverter());
        converters.put(Timestamp.class, new SqlTimestampConverter());
    }

    public static void deregister(Class clazz) {
        converters.remove(clazz);
    }

    public static Converter lookup(Class clazz) {
        return (Converter)converters.get(clazz);
    }

    public static void register(Converter converter, Class clazz) {
        converters.put(clazz, converter);
    }

    static {
        converters.setFast(false);
        ConvertUtils.deregister();
        converters.setFast(true);
        log = LogFactory.getLog(ConvertUtils.class);
    }
}

