/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.AvailabilityService;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.ManagerProperties;
import com.sun.enterprise.config.serverbeans.RequestProcessing;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.SessionConfig;
import com.sun.enterprise.config.serverbeans.SessionManager;
import com.sun.enterprise.config.serverbeans.SessionProperties;
import com.sun.enterprise.config.serverbeans.StoreProperties;
import com.sun.enterprise.config.serverbeans.WebContainer;
import com.sun.enterprise.config.serverbeans.WebContainerAvailability;
import com.sun.enterprise.config.serverbeans.WebModule;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.util.uuid.UuidGenerator;
import com.sun.enterprise.util.uuid.UuidGeneratorImpl;
import com.sun.enterprise.web.session.PersistenceType;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServerConfigLookup {
    protected static final String HADB_CONNECTION_URL_PREFIX = "jdbc:sun:hadb:";
    protected static final String CLUSTER_ID_PROPERTY_NAME = "cluster-id";
    protected static final String STALE_SESSION_CHECKING_ENABLED_PROPERTY_NAME = "stale-session-checking-enabled";
    protected static final String DEFAULT_CLUSTER_ID = "cluster1";
    protected static final String HADB_STORE_POOL_JNDI_NAME_PROPERTY_NAME = "store-pool-jndi-name";
    protected static final String DEFAULT_STORE_POOL_JNDI_NAME = "jdbc/hastore";
    protected static final String HADB_MGMT_ENV_PATH_PROPERTY_NAME = "hadb-mgmt-env-path";
    protected static final String HADB_DATABASE_NAME_PROPERTY_NAME = "hadb-database-name";
    protected static final String UUID_GENERATOR_CLASS_PROPERTY_NAME = "uuid-impl-class";
    protected static final String DEFAULT_UUID_GENERATOR_CLASS = "com.sun.enterprise.util.uuid.UuidGeneratorImpl";
    protected static final String EE_BUILDER_PATH_PROPERTY_NAME = "ee-builder-path";
    protected static final String DEFAULT_EE_BUILDER_PATH = "com.sun.enterprise.ee.web.initialization";
    protected static final String HADB_HEALTH_CHECK_ENABLED_PROPERTY_NAME = "hadb-health-check-enabled";
    protected static final int DEFAULT_HA_STORE_HEALTHCHECK_INTERVAL_IN_SECONDS = 5;
    protected static final String USER_NAME = "User";
    protected static final String PASSWORD = "Password";
    protected static final String HADB_AGENT_PASSWORD = "ha-agent-password";
    private static final String NATIVE_REPLICATION_ENABLED = "native_replication_enabled";
    private static final String CLUSTER_MEMBERS = "cluster_members";
    private static final String NUMBER_OF_PIPES = "number_of_pipes";
    private static final String LATENCY_COUNT = "replication_ack_enabled";
    private static final String MAX_SESSION_UNLOAD_TIME_IN_SECONDS = "max_session_unload_time_in_seconds";
    private static final String REPLICATION_MEASUREMENT_ENABLED = "replication_measurement_enabled";
    private static final String REPLICATION_MEASUREMENT_INTERVAL = "replication_measurement_interval";
    private static final String WAIT_FOR_ACK_PROPERTY = "wait_for_ack_property";
    private static final String WAIT_FOR_FAST_ACK_PROPERTY = "wait_for_fast_ack_property";
    protected static final int DEFAULT_REQUEST_PROCESSING_THREAD_COUNT = 20;
    protected ConfigContext _configContext = null;
    private static final Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.web");

    public ServerConfigLookup() {
    }

    public ServerConfigLookup(ConfigContext configContext) {
        this();
        this._configContext = configContext;
    }

    protected ServerContext getServerContext() {
        return ApplicationServer.getServerContext();
    }

    protected ConfigContext getConfigContextDynamic() {
        if (this._configContext != null) {
            return this._configContext;
        }
        return this.getConfigContext();
    }

    protected ConfigContext getConfigContext() {
        ServerContext serverCtx = this.getServerContext();
        if (serverCtx == null) {
            return null;
        }
        return serverCtx.getConfigContext();
    }

    private Server getServerBean() {
        Server serverBean = null;
        ConfigContext configCtx = this.getConfigContext();
        try {
            serverBean = ServerBeansFactory.getServerBean(configCtx);
        }
        catch (ConfigException configException) {
            // empty catch block
        }
        return serverBean;
    }

    public boolean isDAS() {
        boolean result = true;
        Server serverBean = this.getServerBean();
        ConfigContext configCtx = this.getConfigContext();
        if (serverBean != null && configCtx != null) {
            try {
                result = ServerHelper.isDAS(configCtx, serverBean);
            }
            catch (ConfigException ex) {
                // empty catch block
            }
        }
        return result;
    }

    public String getServerName() {
        String result = null;
        Server serverBean = this.getServerBean();
        if (serverBean != null) {
            result = serverBean.getName();
        }
        return result;
    }

    public String getClusterName() {
        String result = null;
        ConfigContext configCtx = this.getConfigContext();
        String serverName = this.getServerName();
        if (serverName == null) {
            return result;
        }
        boolean isClustered = false;
        try {
            isClustered = ServerHelper.isServerClustered(configCtx, serverName);
        }
        catch (ConfigException ex) {
            // empty catch block
        }
        if (!isClustered) {
            result = serverName + "_nc";
            return result;
        }
        Cluster cluster = null;
        try {
            cluster = ClusterHelper.getClusterForInstance(configCtx, serverName);
        }
        catch (ConfigException ex) {
            // empty catch block
        }
        if (cluster != null) {
            result = cluster.getName();
        }
        return result;
    }

    public ArrayList getServerNamesInCluster() {
        ArrayList result = new ArrayList();
        ConfigContext configCtx = this.getConfigContext();
        String serverName = this.getServerName();
        if (serverName == null) {
            return result;
        }
        boolean isClustered = false;
        try {
            isClustered = ServerHelper.isServerClustered(configCtx, serverName);
        }
        catch (ConfigException ex) {
            // empty catch block
        }
        if (!isClustered) {
            ArrayList instanceNamesArray = this.getClusterInstanceNamesList();
            if (!instanceNamesArray.isEmpty()) {
                result = instanceNamesArray;
            } else {
                result.add(serverName);
            }
            return result;
        }
        String clusterName = this.getClusterName();
        Server[] serversArray = null;
        try {
            serversArray = ServerHelper.getServersInCluster(configCtx, clusterName);
        }
        catch (ConfigException ex) {
            // empty catch block
        }
        for (int i = 0; i < serversArray.length; ++i) {
            Server nextServer = serversArray[i];
            result.add(nextServer.getName().trim());
        }
        return result;
    }

    ArrayList getClusterInstanceNamesList() {
        ArrayList<String> instanceNames = new ArrayList<String>();
        ServerConfigLookup lookup = new ServerConfigLookup();
        String instanceNamesString = lookup.getAvailabilityServicePropertyString(CLUSTER_MEMBERS);
        if (instanceNamesString == null) {
            return instanceNames;
        }
        String[] instancesArray = instanceNamesString.split(",");
        List<String> instancesList = Arrays.asList(instancesArray);
        for (int i = 0; i < instancesList.size(); ++i) {
            instanceNames.add(instancesList.get(i).trim());
        }
        return instanceNames;
    }

    private void displayArrayList(ArrayList list) {
        System.out.println("DISPLAY CLUSTER MEMBERS");
        for (int i = 0; i < list.size(); ++i) {
            System.out.println("clusterMember[" + i + "] = " + list.get(i));
        }
    }

    public boolean isGMSEnabled() {
        if (this.getClusterName() == null) {
            return false;
        }
        Cluster cluster = this.getCluster();
        if (cluster == null) {
            return false;
        }
        return cluster.isHeartbeatEnabled();
    }

    public Cluster getCluster() {
        ConfigContext configCtx = this.getConfigContext();
        String serverName = this.getServerName();
        boolean isClustered = false;
        try {
            isClustered = ServerHelper.isServerClustered(configCtx, serverName);
        }
        catch (ConfigException ex) {
            // empty catch block
        }
        if (!isClustered) {
            return null;
        }
        Cluster cluster = null;
        try {
            cluster = ClusterHelper.getClusterForInstance(configCtx, serverName);
        }
        catch (ConfigException ex) {
            // empty catch block
        }
        return cluster;
    }

    public int getNumberOfReplicationPipesFromConfig() {
        int numPipes = this.getNumberOfReplicationPipesPropertyFromConfig();
        if (numPipes == -1) {
            numPipes = this.getRequestProcessingThreadCountFromConfig();
        }
        if (++numPipes > 40) {
            numPipes = 41;
        }
        if (numPipes < 2) {
            numPipes = 2;
        }
        return numPipes;
    }

    public int getNumberOfReplicationPipesPropertyFromConfig() {
        int returnValue;
        int candidateReturnValue;
        block4: {
            candidateReturnValue = -1;
            returnValue = -1;
            String returnValueString = this.getAvailabilityServicePropertyString(NUMBER_OF_PIPES);
            if (returnValueString != null) {
                try {
                    candidateReturnValue = Integer.valueOf(returnValueString);
                }
                catch (NumberFormatException ex) {
                    if (!_logger.isLoggable(Level.FINEST)) break block4;
                    _logger.finest("Using Default Value = 5");
                }
            }
        }
        if (candidateReturnValue > 0) {
            returnValue = candidateReturnValue;
        }
        return returnValue;
    }

    public int getLatencyCountPropertyFromConfig() {
        int returnValue;
        int candidateReturnValue;
        block4: {
            candidateReturnValue = 0;
            returnValue = 0;
            String returnValueString = this.getAvailabilityServicePropertyString(LATENCY_COUNT);
            if (returnValueString != null) {
                try {
                    candidateReturnValue = Integer.valueOf(returnValueString);
                }
                catch (NumberFormatException ex) {
                    if (!_logger.isLoggable(Level.FINEST)) break block4;
                    _logger.finest("Using Default Value = 0");
                }
            }
        }
        if (candidateReturnValue == 1) {
            returnValue = candidateReturnValue;
        }
        return returnValue;
    }

    public int getMaxSessionUnloadTimeInSecondsPropertyFromConfig() {
        int returnValue;
        int candidateReturnValue;
        block4: {
            candidateReturnValue = 420;
            returnValue = 420;
            String returnValueString = this.getAvailabilityServicePropertyString(MAX_SESSION_UNLOAD_TIME_IN_SECONDS);
            if (returnValueString != null) {
                try {
                    candidateReturnValue = Integer.valueOf(returnValueString);
                }
                catch (NumberFormatException ex) {
                    if (!_logger.isLoggable(Level.FINEST)) break block4;
                    _logger.finest("Using Default Value = 7 * 60");
                }
            }
        }
        if (candidateReturnValue >= 0) {
            returnValue = candidateReturnValue;
        }
        return returnValue;
    }

    public int getReplicationMeasurementIntervalFromConfig() {
        int returnValue;
        int candidateReturnValue;
        block4: {
            candidateReturnValue = 1000;
            returnValue = 1000;
            String returnValueString = this.getAvailabilityServicePropertyString(REPLICATION_MEASUREMENT_INTERVAL);
            if (returnValueString != null) {
                try {
                    candidateReturnValue = Integer.valueOf(returnValueString);
                }
                catch (NumberFormatException ex) {
                    if (!_logger.isLoggable(Level.FINEST)) break block4;
                    _logger.finest("Using Default Value = 1000");
                }
            }
        }
        if (candidateReturnValue > 0) {
            returnValue = candidateReturnValue;
        }
        return returnValue;
    }

    public boolean getReplicationMeasurementEnabledFromConfig() {
        boolean returnValue = false;
        String returnValueString = this.getAvailabilityServicePropertyString(REPLICATION_MEASUREMENT_ENABLED);
        if (returnValueString != null) {
            returnValue = Boolean.valueOf(returnValueString);
        }
        return returnValue;
    }

    public boolean getWaitForAckPropertyFromConfig() {
        boolean returnValue = false;
        String returnValueString = this.getAvailabilityServicePropertyString(WAIT_FOR_ACK_PROPERTY);
        if (returnValueString != null) {
            returnValue = Boolean.valueOf(returnValueString);
        }
        return returnValue;
    }

    public boolean getWaitForFastAckPropertyFromConfig() {
        boolean returnValue = true;
        String returnValueString = this.getAvailabilityServicePropertyString(WAIT_FOR_FAST_ACK_PROPERTY);
        if (returnValueString != null) {
            returnValue = Boolean.valueOf(returnValueString);
        }
        return returnValue;
    }

    public boolean isNativeReplicationEnabledFromConfig() {
        String nativeReplicationEnabledString;
        Boolean bool;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in ServerConfigLookup>>getNativeReplicationEnabledFromConfig");
        }
        if ((bool = this.toBoolean(nativeReplicationEnabledString = this.getAvailabilityServicePropertyString(NATIVE_REPLICATION_ENABLED))) == null) {
            return true;
        }
        return bool;
    }

    private Resources getResourcesBean() {
        Resources resourcesBean = null;
        Domain domainBean = null;
        ConfigContext configCtx = this.getConfigContext();
        try {
            domainBean = ServerBeansFactory.getDomainBean(configCtx);
            if (domainBean != null) {
                resourcesBean = domainBean.getResources();
            }
        }
        catch (ConfigException ex) {
            // empty catch block
        }
        return resourcesBean;
    }

    private Applications getApplicationsBean() {
        Applications applicationsBean = null;
        Domain domainBean = null;
        ConfigContext configCtx = this.getConfigContext();
        try {
            domainBean = ServerBeansFactory.getDomainBean(configCtx);
            if (domainBean != null) {
                applicationsBean = domainBean.getApplications();
            }
        }
        catch (ConfigException ex) {
            // empty catch block
        }
        return applicationsBean;
    }

    private Applications getApplicationsBeanDynamic() {
        Applications applicationsBean = null;
        Domain domainBean = null;
        ConfigContext configCtx = this.getConfigContextDynamic();
        try {
            domainBean = ServerBeansFactory.getDomainBean(configCtx);
            if (domainBean != null) {
                applicationsBean = domainBean.getApplications();
            }
        }
        catch (ConfigException ex) {
            // empty catch block
        }
        return applicationsBean;
    }

    private Config getConfigBean() {
        Config configBean = null;
        ConfigContext configCtx = this.getConfigContext();
        try {
            configBean = ServerBeansFactory.getConfigBean(configCtx);
        }
        catch (ConfigException configException) {
            // empty catch block
        }
        return configBean;
    }

    private Config getConfigBeanDynamic() {
        Config configBean = null;
        ConfigContext configCtx = this.getConfigContextDynamic();
        try {
            configBean = ServerBeansFactory.getConfigBean(configCtx);
        }
        catch (ConfigException configException) {
            // empty catch block
        }
        return configBean;
    }

    protected HttpService getHttpService() {
        Config configBean = this.getConfigBean();
        if (configBean == null) {
            return null;
        }
        return configBean.getHttpService();
    }

    private RequestProcessing getRequestProcessing() {
        HttpService httpServiceBean = this.getHttpService();
        if (httpServiceBean == null) {
            return null;
        }
        return httpServiceBean.getRequestProcessing();
    }

    private String getRequestProcessingThreadCountStringFromConfig() {
        RequestProcessing requestProcessingBean = this.getRequestProcessing();
        if (requestProcessingBean == null) {
            return null;
        }
        return requestProcessingBean.getThreadCount();
    }

    public int getRequestProcessingThreadCountFromConfig() {
        int returnValue;
        int candidateReturnValue;
        block4: {
            candidateReturnValue = -1;
            returnValue = 20;
            String returnValueString = this.getRequestProcessingThreadCountStringFromConfig();
            if (returnValueString != null) {
                try {
                    candidateReturnValue = Integer.valueOf(returnValueString);
                }
                catch (NumberFormatException ex) {
                    if (!_logger.isLoggable(Level.FINEST)) break block4;
                    _logger.finest("Using Default Value = 20");
                }
            }
        }
        if (candidateReturnValue > 4) {
            returnValue = candidateReturnValue;
        }
        return returnValue;
    }

    protected AvailabilityService getAvailabilityService() {
        Config configBean = this.getConfigBean();
        if (configBean == null) {
            return null;
        }
        return configBean.getAvailabilityService();
    }

    protected AvailabilityService getAvailabilityServiceDynamic() {
        Config configBean = this.getConfigBeanDynamic();
        if (configBean == null) {
            return null;
        }
        return configBean.getAvailabilityService();
    }

    private WebContainerAvailability getWebContainerAvailability() {
        AvailabilityService availabilityServiceBean = this.getAvailabilityService();
        if (availabilityServiceBean == null) {
            return null;
        }
        return availabilityServiceBean.getWebContainerAvailability();
    }

    private ElementProperty[] getWebContainerAvailabilityProperties() {
        WebContainerAvailability webContainerAvailabilityBean = this.getWebContainerAvailability();
        if (webContainerAvailabilityBean == null) {
            return new ElementProperty[0];
        }
        return webContainerAvailabilityBean.getElementProperty();
    }

    protected String getWebContainerAvailabilityPropertyString(String propName) {
        String result = null;
        WebContainerAvailability wcAvailabilityBean = this.getWebContainerAvailability();
        if (wcAvailabilityBean != null && wcAvailabilityBean.sizeElementProperty() > 0) {
            ElementProperty[] props = wcAvailabilityBean.getElementProperty();
            for (int i = 0; i < props.length; ++i) {
                String name = props[i].getAttributeValue("name");
                String value = props[i].getAttributeValue("value");
                if (!name.equalsIgnoreCase(propName)) continue;
                result = value;
            }
        }
        return result;
    }

    protected String getWebContainerAvailabilityPropertyString(String propName, String defaultValue) {
        String result = null;
        WebContainerAvailability wcAvailabilityBean = this.getWebContainerAvailability();
        if (wcAvailabilityBean != null && wcAvailabilityBean.sizeElementProperty() > 0) {
            ElementProperty[] props = wcAvailabilityBean.getElementProperty();
            for (int i = 0; i < props.length; ++i) {
                String name = props[i].getAttributeValue("name");
                String value = props[i].getAttributeValue("value");
                if (!name.equalsIgnoreCase(propName)) continue;
                result = value;
            }
        }
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    protected int getWebContainerAvailabilityPropertyInt(String propName, int defaultValue) {
        int returnValue;
        block5: {
            returnValue = defaultValue;
            String returnValueString = null;
            WebContainerAvailability wcAvailabilityBean = this.getWebContainerAvailability();
            if (wcAvailabilityBean != null && wcAvailabilityBean.sizeElementProperty() > 0) {
                ElementProperty[] props = wcAvailabilityBean.getElementProperty();
                for (int i = 0; i < props.length; ++i) {
                    String name = props[i].getAttributeValue("name");
                    String value = props[i].getAttributeValue("value");
                    if (!name.equalsIgnoreCase(propName)) continue;
                    returnValueString = value;
                }
            }
            if (returnValueString != null) {
                try {
                    returnValue = Integer.valueOf(returnValueString);
                }
                catch (NumberFormatException ex) {
                    if (!_logger.isLoggable(Level.FINEST)) break block5;
                    _logger.finest("Using Default Value = " + defaultValue);
                }
            }
        }
        return returnValue;
    }

    private WebModule getWebModuleByContextRoot(String contextRoot) {
        WebModule result = null;
        Applications applicationsBean = this.getApplicationsBeanDynamic();
        if (applicationsBean == null) {
            return null;
        }
        WebModule[] webModules = applicationsBean.getWebModule();
        for (int i = 0; i < webModules.length; ++i) {
            WebModule nextWebModule = webModules[i];
            String nextContextRoot = nextWebModule.getContextRoot();
            if (nextContextRoot == null || !nextContextRoot.equalsIgnoreCase(contextRoot)) continue;
            result = nextWebModule;
        }
        return result;
    }

    private boolean getWebModuleAvailability(String contextRoot, boolean inheritedValue) {
        WebModule webModule = this.getWebModuleByContextRoot(contextRoot);
        if (webModule == null) {
            return false;
        }
        return webModule.isAvailabilityEnabled();
    }

    private J2eeApplication getJ2eeApplicationByName(String appName) {
        Object result = null;
        Applications applicationsBean = this.getApplicationsBeanDynamic();
        if (applicationsBean == null) {
            return null;
        }
        return applicationsBean.getJ2eeApplicationByName(appName);
    }

    private boolean getJ2eeApplicationAvailability(String appName, boolean inheritedValue) {
        J2eeApplication j2eeApp = this.getJ2eeApplicationByName(appName);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("ServerConfigLookup>>getJ2eeApplicationAvailability j2eeApp = " + j2eeApp);
        }
        if (j2eeApp == null) {
            return false;
        }
        return j2eeApp.isAvailabilityEnabled();
    }

    public PersistenceType getPersistenceTypeFromConfig() {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in ServerConfigLookup>>getPersistenceTypeFromConfig");
        }
        String persistenceTypeString = null;
        PersistenceType persistenceType = null;
        WebContainerAvailability webContainerAvailabilityBean = this.getWebContainerAvailability();
        if (webContainerAvailabilityBean == null) {
            return null;
        }
        persistenceTypeString = webContainerAvailabilityBean.getPersistenceType();
        if (persistenceTypeString != null) {
            persistenceType = PersistenceType.parseType(persistenceTypeString);
        }
        if (persistenceType != null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("SERVER.XML persistenceType= " + persistenceType.getType());
            }
        } else if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("SERVER.XML persistenceType missing");
        }
        return persistenceType;
    }

    public String getPersistenceFrequencyFromConfig() {
        WebContainerAvailability webContainerAvailabilityBean;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in ServerConfigLookup>>getPersistenceFrequencyFromConfig");
        }
        if ((webContainerAvailabilityBean = this.getWebContainerAvailability()) == null) {
            return null;
        }
        return webContainerAvailabilityBean.getPersistenceFrequency();
    }

    public String getPersistenceScopeFromConfig() {
        WebContainerAvailability webContainerAvailabilityBean;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in ServerConfigLookup>>getPersistenceScopeFromConfig");
        }
        if ((webContainerAvailabilityBean = this.getWebContainerAvailability()) == null) {
            return null;
        }
        return webContainerAvailabilityBean.getPersistenceScope();
    }

    public boolean getStaleSessionCheckingFromConfig() {
        String staleSessionCheckingEnabledString;
        Boolean bool;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in ServerConfigLookup>>getStaleSessionCheckingFromConfig");
        }
        if ((bool = this.toBoolean(staleSessionCheckingEnabledString = this.getWebContainerAvailabilityPropertyString(STALE_SESSION_CHECKING_ENABLED_PROPERTY_NAME, "false"))) == null) {
            return false;
        }
        return bool;
    }

    public String getClusterIdFromConfig() {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in ServerConfigLookup>>getClusterIdFromConfig");
        }
        return this.getWebContainerAvailabilityPropertyString(CLUSTER_ID_PROPERTY_NAME, DEFAULT_CLUSTER_ID);
    }

    public boolean getAvailabilityEnabledFromConfig() {
        AvailabilityService as;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in ServerConfigLookup>>getAvailabilityEnabledFromConfig");
        }
        if ((as = this.getAvailabilityService()) == null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("AvailabilityService was not defined - check domain.xml");
            }
            return false;
        }
        return as.isAvailabilityEnabled();
    }

    public boolean calculateWebAvailabilityEnabledFromConfig(String contextRoot, String j2eeAppName) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in ServerConfigLookup>>calculateWebAvailabilityEnabledFromConfig");
        }
        boolean globalAvailability = this.getAvailabilityEnabledFromConfig();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("globalAvailability = " + globalAvailability);
        }
        boolean webContainerAvailability = this.getWebContainerAvailabilityEnabledFromConfig(globalAvailability);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("webContainerAvailability = " + webContainerAvailability);
        }
        if (j2eeAppName == null || "null".equals(j2eeAppName)) {
            boolean webModuleAvailability = this.getWebModuleAvailability(contextRoot, webContainerAvailability);
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("webModuleAvailability = " + webModuleAvailability);
            }
            return globalAvailability && webContainerAvailability && webModuleAvailability;
        }
        boolean j2eeApplicationAvailability = this.getJ2eeApplicationAvailability(j2eeAppName, webContainerAvailability);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("j2eeApplicationAvailability = " + j2eeApplicationAvailability);
        }
        return globalAvailability && webContainerAvailability && j2eeApplicationAvailability;
    }

    public boolean getWebContainerAvailabilityEnabledFromConfig() {
        WebContainerAvailability was;
        boolean globalAvailabilityEnabled = this.getAvailabilityEnabledFromConfig();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in ServerConfigLookup>>getWebContainerAvailabilityEnabledFromConfig");
        }
        if ((was = this.getWebContainerAvailability()) == null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("WebContainerAvailability was not defined - check domain.xml");
            }
            return globalAvailabilityEnabled;
        }
        String wasString = was.getAvailabilityEnabled();
        Boolean bool = this.toBoolean(wasString);
        if (bool == null) {
            return globalAvailabilityEnabled;
        }
        return bool;
    }

    public boolean getWebContainerAvailabilityEnabledFromConfig(boolean inheritedValue) {
        WebContainerAvailability was;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in ServerConfigLookup>>getWebContainerAvailabilityEnabledFromConfig");
        }
        if ((was = this.getWebContainerAvailability()) == null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("WebContainerAvailability was not defined - check domain.xml");
            }
            return inheritedValue;
        }
        String wasString = was.getAvailabilityEnabled();
        Boolean bool = this.toBoolean(wasString);
        if (bool == null) {
            return inheritedValue;
        }
        return bool;
    }

    protected Boolean toBoolean(String value) {
        if (value == null) {
            return null;
        }
        if (value.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (value.equalsIgnoreCase("yes")) {
            return Boolean.TRUE;
        }
        if (value.equalsIgnoreCase("on")) {
            return Boolean.TRUE;
        }
        if (value.equalsIgnoreCase("1")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public String getStorePoolJndiNameFromConfig() {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in ServerConfigLookup>>getStorePoolJndiNameFromConfig");
        }
        String result = DEFAULT_STORE_POOL_JNDI_NAME;
        AvailabilityService as = this.getAvailabilityService();
        if (as == null) {
            return result;
        }
        String storePoolJndiName = as.getStorePoolName();
        if (storePoolJndiName != null) {
            result = storePoolJndiName;
        }
        return result;
    }

    public String getHaStorePoolJndiNameFromConfig() {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in ServerConfigLookup>>getHaStorePoolJndiNameFromConfig");
        }
        String result = this.getStorePoolJndiNameFromConfig();
        WebContainerAvailability webContainerAvailabilityBean = this.getWebContainerAvailability();
        if (webContainerAvailabilityBean == null) {
            return result;
        }
        String result2 = webContainerAvailabilityBean.getHttpSessionStorePoolName();
        if (result2 != null) {
            result = result2;
        }
        return result;
    }

    public boolean getHadbHealthCheckFromConfig() {
        AvailabilityService as = this.getAvailabilityService();
        if (as == null) {
            return false;
        }
        return as.isHaStoreHealthcheckEnabled();
    }

    public boolean getHadbHealthCheckFromConfigDynamic() {
        AvailabilityService as = this.getAvailabilityServiceDynamic();
        if (as == null) {
            return false;
        }
        return as.isHaStoreHealthcheckEnabled();
    }

    public boolean getSsoFailoverEnabledFromConfig() {
        WebContainerAvailability webContainerAvailabilityBean = this.getWebContainerAvailability();
        if (webContainerAvailabilityBean == null) {
            return false;
        }
        return webContainerAvailabilityBean.isSsoFailoverEnabled();
    }

    public String getHadbMgmtEnvPathFromConfig() {
        return this.getWebContainerAvailabilityPropertyString(HADB_MGMT_ENV_PATH_PROPERTY_NAME, null);
    }

    public String getAvailabilityServicePropertyString(String propName) {
        String result = null;
        AvailabilityService availabilityServiceBean = this.getAvailabilityService();
        if (availabilityServiceBean != null && availabilityServiceBean.sizeElementProperty() > 0) {
            ElementProperty[] props = availabilityServiceBean.getElementProperty();
            for (int i = 0; i < props.length; ++i) {
                String name = props[i].getAttributeValue("name");
                String value = props[i].getAttributeValue("value");
                if (!name.equalsIgnoreCase(propName)) continue;
                result = value;
            }
        }
        return result;
    }

    public String getHadbDatabaseNameFromConfig() {
        AvailabilityService as = this.getAvailabilityService();
        if (as == null) {
            return null;
        }
        return as.getHaStoreName();
    }

    public String getHadbDatabaseNameFromConfigDynamic() {
        AvailabilityService as = this.getAvailabilityServiceDynamic();
        if (as == null) {
            return null;
        }
        return as.getHaStoreName();
    }

    public String getHadbAgentPasswordFromConfig() {
        AvailabilityService as = this.getAvailabilityService();
        if (as == null) {
            return null;
        }
        return as.getHaAgentPassword();
    }

    public String getHaStoreHealthcheckIntervalInSecondsStringFromConfig() {
        AvailabilityService as = this.getAvailabilityService();
        if (as == null) {
            return null;
        }
        return as.getHaStoreHealthcheckIntervalInSeconds();
    }

    public int getHaStoreHealthcheckIntervalInSecondsFromConfig() {
        int returnValue;
        int candidateReturnValue;
        block4: {
            candidateReturnValue = -1;
            returnValue = 5;
            String returnValueString = this.getHaStoreHealthcheckIntervalInSecondsStringFromConfig();
            if (returnValueString != null) {
                try {
                    candidateReturnValue = Integer.valueOf(returnValueString);
                }
                catch (NumberFormatException ex) {
                    if (!_logger.isLoggable(Level.FINEST)) break block4;
                    _logger.finest("Using Default Value = 5");
                }
            }
        }
        if (candidateReturnValue > 0) {
            returnValue = candidateReturnValue;
        }
        return returnValue;
    }

    public String getHaStoreHealthcheckIntervalInSecondsStringFromConfigDynamic() {
        AvailabilityService as = this.getAvailabilityServiceDynamic();
        if (as == null) {
            return null;
        }
        return as.getHaStoreHealthcheckIntervalInSeconds();
    }

    public int getHaStoreHealthcheckIntervalInSecondsFromConfigDynamic() {
        int returnValue;
        int candidateReturnValue;
        block4: {
            candidateReturnValue = -1;
            returnValue = 5;
            String returnValueString = this.getHaStoreHealthcheckIntervalInSecondsStringFromConfigDynamic();
            if (returnValueString != null) {
                try {
                    candidateReturnValue = Integer.valueOf(returnValueString);
                }
                catch (NumberFormatException ex) {
                    if (!_logger.isLoggable(Level.FINEST)) break block4;
                    _logger.finest("Using Default Value = 5");
                }
            }
        }
        if (candidateReturnValue > 0) {
            returnValue = candidateReturnValue;
        }
        return returnValue;
    }

    public String getHadbAgentPortFromConfig() {
        AvailabilityService as = this.getAvailabilityService();
        if (as == null) {
            return null;
        }
        return as.getHaAgentPort();
    }

    public String getHadbAgentPortFromConfigDynamic() {
        AvailabilityService as = this.getAvailabilityServiceDynamic();
        if (as == null) {
            return null;
        }
        return as.getHaAgentPort();
    }

    public String getHadbAgentConnectionURLFromConfig() {
        String url = null;
        StringBuffer sb = new StringBuffer();
        String hostsString = this.getHadbAgentHostsFromConfig();
        String portString = this.getHadbAgentPortFromConfig();
        if (hostsString != null && portString != null) {
            sb.append(hostsString);
            sb.append(":");
            sb.append(portString);
            url = sb.toString();
        } else {
            url = null;
        }
        return url;
    }

    public String getHadbAgentConnectionURLFromConfigDynamic() {
        String url = null;
        StringBuffer sb = new StringBuffer();
        String hostsString = this.getHadbAgentHostsFromConfigDynamic();
        String portString = this.getHadbAgentPortFromConfigDynamic();
        if (hostsString != null && portString != null) {
            sb.append(hostsString);
            sb.append(":");
            sb.append(portString);
            url = sb.toString();
        } else {
            url = null;
        }
        return url;
    }

    public String getHadbAgentHostsFromConfig() {
        AvailabilityService as = this.getAvailabilityService();
        if (as == null) {
            return null;
        }
        return as.getHaAgentHosts();
    }

    public String getHadbAgentHostsFromConfigDynamic() {
        AvailabilityService as = this.getAvailabilityServiceDynamic();
        if (as == null) {
            return null;
        }
        return as.getHaAgentHosts();
    }

    public String getEEBuilderPathFromConfig() {
        return this.getWebContainerAvailabilityPropertyString(EE_BUILDER_PATH_PROPERTY_NAME, DEFAULT_EE_BUILDER_PATH);
    }

    public String getUuidGeneratorImplClassFromConfig() {
        String cls;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in ServerConfigLookup>>getUuidGeneratorImplClassFromConfig");
        }
        String defaultUuidGeneratorClass = DEFAULT_UUID_GENERATOR_CLASS;
        ManagerProperties mp = this.getInstanceSessionManagerManagerProperties();
        if (mp != null && (cls = mp.getSessionIdGeneratorClassname()) != null) {
            defaultUuidGeneratorClass = cls;
        }
        return this.getWebContainerAvailabilityPropertyString(UUID_GENERATOR_CLASS_PROPERTY_NAME, defaultUuidGeneratorClass);
    }

    public UuidGenerator getUuidGeneratorFromConfig() {
        UuidGenerator generator = new UuidGeneratorImpl();
        String generatorImplClassName = this.getUuidGeneratorImplClassFromConfig();
        try {
            generator = (UuidGenerator)Class.forName(generatorImplClassName).newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return generator;
    }

    public String getServerConfigValue(String xpath, String defaultValue) {
        ServerContext serverCtx;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in ServerConfigLookup>>getServerConfigValue:xpath=" + xpath + " defaultValue= " + defaultValue);
        }
        if ((serverCtx = ApplicationServer.getServerContext()) == null) {
            return defaultValue;
        }
        ConfigContext configCtx = serverCtx.getConfigContext();
        ConfigBean configBean = null;
        String returnValueString = null;
        String returnValue = defaultValue;
        try {
            configBean = configCtx.exactLookup(xpath);
        }
        catch (ConfigException ex) {
            // empty catch block
        }
        if (configBean != null) {
            returnValueString = configBean.getAttributeValue("value");
        }
        if (returnValueString != null) {
            returnValue = returnValueString;
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("RETURNED CONFIG VALUE FOR XPATH:" + xpath + " = " + returnValue);
        }
        return returnValue;
    }

    public int getServerConfigValue(String xpath, int defaultValue) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in getServerConfigValue:xpath=" + xpath + " defaultValue= " + defaultValue);
        }
        ConfigContext configCtx = this.getConfigContext();
        ConfigBean configBean = null;
        String returnValueString = null;
        int returnValue = defaultValue;
        try {
            configBean = configCtx.exactLookup(xpath);
        }
        catch (ConfigException ex) {
            // empty catch block
        }
        if (configBean != null) {
            returnValueString = configBean.getAttributeValue("value");
        }
        if (returnValueString != null) {
            try {
                returnValue = Integer.valueOf(returnValueString);
            }
            catch (NumberFormatException ex) {
                _logger.finest("Using Default Value = " + defaultValue);
            }
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("RETURNED CONFIG VALUE FOR XPATH:" + xpath + " = " + returnValue);
        }
        return returnValue;
    }

    public SessionManager getInstanceSessionManager() {
        Config configBean = this.getConfigBean();
        if (configBean == null) {
            return null;
        }
        WebContainer webContainerBean = configBean.getWebContainer();
        if (webContainerBean == null) {
            return null;
        }
        SessionConfig sessionConfigBean = webContainerBean.getSessionConfig();
        if (sessionConfigBean == null) {
            return null;
        }
        SessionManager smBean = sessionConfigBean.getSessionManager();
        return smBean;
    }

    public ManagerProperties getInstanceSessionManagerManagerProperties() {
        SessionManager smBean = this.getInstanceSessionManager();
        if (smBean == null) {
            return null;
        }
        return smBean.getManagerProperties();
    }

    public StoreProperties getInstanceSessionManagerStoreProperties() {
        SessionManager smBean = this.getInstanceSessionManager();
        if (smBean == null) {
            return null;
        }
        return smBean.getStoreProperties();
    }

    public SessionProperties getInstanceSessionProperties() {
        Config configBean = this.getConfigBean();
        if (configBean == null) {
            return null;
        }
        WebContainer webContainerBean = configBean.getWebContainer();
        if (webContainerBean == null) {
            return null;
        }
        SessionConfig sessionConfigBean = webContainerBean.getSessionConfig();
        if (sessionConfigBean == null) {
            return null;
        }
        SessionProperties spBean = sessionConfigBean.getSessionProperties();
        return spBean;
    }

    public String getConnectionUserFromConfig() {
        String user = null;
        JdbcConnectionPool pool = this.getHadbJdbcConnectionPoolFromConfig();
        if (pool == null) {
            return null;
        }
        if (pool.sizeElementProperty() > 0) {
            ElementProperty[] props = pool.getElementProperty();
            for (int i = 0; i < props.length; ++i) {
                String name = props[i].getAttributeValue("name");
                String value = props[i].getAttributeValue("value");
                if (!name.equalsIgnoreCase(USER_NAME)) continue;
                user = value;
            }
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("IN NEW getConnectionUserFromConfig: user=" + user);
        }
        return user;
    }

    public String getConnectionPasswordFromConfig() {
        String password = null;
        JdbcConnectionPool pool = this.getHadbJdbcConnectionPoolFromConfig();
        if (pool == null) {
            return null;
        }
        if (pool.sizeElementProperty() > 0) {
            ElementProperty[] props = pool.getElementProperty();
            for (int i = 0; i < props.length; ++i) {
                String name = props[i].getAttributeValue("name");
                String value = props[i].getAttributeValue("value");
                if (!name.equalsIgnoreCase(PASSWORD)) continue;
                password = value;
            }
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("IN NEW getConnectionPasswordFromConfig: password=" + password);
        }
        return password;
    }

    public String getConnectionURLFromConfig() {
        String url = null;
        StringBuffer sb = new StringBuffer();
        JdbcConnectionPool pool = this.getHadbJdbcConnectionPoolFromConfig();
        if (pool == null) {
            return null;
        }
        if (pool.sizeElementProperty() > 0) {
            ElementProperty[] props = pool.getElementProperty();
            for (int i = 0; i < props.length; ++i) {
                String name = props[i].getAttributeValue("name");
                String value = props[i].getAttributeValue("value");
                if (!name.equalsIgnoreCase("serverList")) continue;
                sb.append(HADB_CONNECTION_URL_PREFIX);
                sb.append(value);
                url = sb.toString();
            }
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("IN NEW getConnectionURLFromConfig: url=" + url);
        }
        return url;
    }

    public JdbcConnectionPool getHadbJdbcConnectionPoolFromConfig() {
        String storePoolJndiName = this.getHaStorePoolJndiNameFromConfig();
        if (storePoolJndiName == null) {
            return null;
        }
        Resources resources = this.getResourcesBean();
        JdbcResource jdbcResource = resources.getJdbcResourceByJndiName(storePoolJndiName);
        if (jdbcResource == null) {
            return null;
        }
        String poolName = jdbcResource.getPoolName();
        JdbcConnectionPool pool = resources.getJdbcConnectionPoolByName(poolName);
        return pool;
    }

    public String getHadbJdbcConnectionPoolNameFromConfig() {
        String storePoolJndiName = this.getHaStorePoolJndiNameFromConfig();
        if (storePoolJndiName == null) {
            return null;
        }
        Resources resources = this.getResourcesBean();
        JdbcResource jdbcResource = resources.getJdbcResourceByJndiName(storePoolJndiName);
        if (jdbcResource == null) {
            return null;
        }
        String poolName = jdbcResource.getPoolName();
        return poolName;
    }

    public static boolean isHADBInstalled() {
        String hadbRootDirString = System.getProperty("com.sun.aas.hadbRoot");
        if (hadbRootDirString == null) {
            return false;
        }
        File hadbRootDir = new File(hadbRootDirString);
        return hadbRootDir.exists() && hadbRootDir.isDirectory();
    }
}

