/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.sync;

public class Semaphore {
    protected long totalPermits;

    public Semaphore(long initialPermits) {
        this.totalPermits = initialPermits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Semaphore semaphore = this;
        synchronized (semaphore) {
            try {
                while (this.totalPermits <= 0L) {
                    this.wait();
                }
                --this.totalPermits;
            }
            catch (InterruptedException ie) {
                this.notify();
                throw ie;
            }
        }
    }

    public boolean attemptAcquire(long waitTime) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Semaphore semaphore = this;
        synchronized (semaphore) {
            if (this.totalPermits > 0L) {
                --this.totalPermits;
                return true;
            }
            if (waitTime <= 0L) {
                return false;
            }
            try {
                long now;
                long startTime = System.currentTimeMillis();
                long timeToWait = waitTime;
                do {
                    this.wait(timeToWait);
                    if (this.totalPermits <= 0L) continue;
                    --this.totalPermits;
                    return true;
                } while ((timeToWait = waitTime - ((now = System.currentTimeMillis()) - startTime)) > 0L);
                return false;
            }
            catch (InterruptedException ie) {
                this.notify();
                throw ie;
            }
        }
    }

    public synchronized void release() {
        ++this.totalPermits;
        this.notify();
    }
}

