/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.collection;

import com.sun.enterprise.util.collection.Bucket;
import com.sun.enterprise.util.collection.SortedArrayListBucket;

public class LongHashMap {
    int maxBuckets = 0;
    Bucket[] buckets;

    public LongHashMap() {
        this(89);
    }

    public LongHashMap(int maxBuckets) {
        this.maxBuckets = maxBuckets;
        this.buckets = new Bucket[maxBuckets];
        for (int i = 0; i < maxBuckets; ++i) {
            this.buckets[i] = new SortedArrayListBucket();
        }
    }

    public LongHashMap(Bucket[] buckets) {
        this.buckets = buckets;
        this.maxBuckets = buckets.length;
    }

    public void put(long key, Object object) {
        int index = (int)Math.abs(key % (long)this.maxBuckets);
        this.buckets[index].put(key, object);
    }

    public Object get(long key) {
        int index = (int)Math.abs(key % (long)this.maxBuckets);
        return this.buckets[index].get(key);
    }

    public Object remove(long key) {
        int index = (int)Math.abs(key % (long)this.maxBuckets);
        return this.buckets[index].remove(key);
    }

    public void print() {
        for (int i = 0; i < this.maxBuckets; ++i) {
            System.out.println("Bucket[" + i + "]: " + this.buckets[i]);
        }
    }

    public static void main(String[] args) {
        long i;
        int count = 20;
        long time = 0L;
        long t1 = 0L;
        long t2 = 0L;
        String data = "SomeData_";
        LongHashMap map = new LongHashMap();
        for (i = 0L; i < (long)count; i += 5L) {
            map.put(i, data + i);
        }
        for (i = 1L; i < (long)count; i += 3L) {
            map.put(i, data + i);
        }
        for (i = 3L; i < (long)count; i += 4L) {
            map.put(i, data + i);
        }
        for (i = -23L; i < (long)count; i += 4L) {
            map.put(i, data + i);
        }
        for (long j = -25L; j < 25L; ++j) {
            System.out.println("Key: " + j + "; val: " + map.get(j));
        }
        t2 = System.currentTimeMillis();
    }
}

