/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.collection;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class LongArrayList
implements List {
    long[] data;
    int minIndex;
    int size;
    double growFactor;

    public LongArrayList() {
        this(6, 0.5);
    }

    public LongArrayList(int initialCapacity) {
        this(initialCapacity, 0.5);
    }

    public LongArrayList(int initialCapacity, double growFactor) {
        this.data = new long[initialCapacity];
        this.growFactor = growFactor;
    }

    private LongArrayList(long[] data, int minIndex, int size, double growFactor) {
        this.data = data;
        this.minIndex = minIndex;
        this.size = size;
        this.growFactor = growFactor;
    }

    public void add(int index, Object o) {
        long val = (Long)o;
        if (this.size == this.data.length) {
            this.makeRoom(1);
        }
        System.arraycopy(this.data, index, this.data, index + 1, this.size - index);
        this.data[index] = val;
        ++this.size;
    }

    public void add(int index, long val) {
        if (this.size == this.data.length) {
            this.makeRoom(1);
        }
        System.arraycopy(this.data, index, this.data, index + 1, this.size - index);
        this.data[index] = val;
        ++this.size;
    }

    public boolean add(Object o) {
        long val = (Long)o;
        if (this.size == this.data.length) {
            this.makeRoom(1);
        }
        this.data[this.size++] = val;
        return true;
    }

    public boolean add(long val) {
        if (this.size == this.data.length) {
            this.makeRoom(1);
        }
        this.data[this.size++] = val;
        return true;
    }

    public boolean addAll(Collection coll) {
        int collSize = coll.size();
        this.makeRoom(collSize);
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            this.data[this.size++] = (Long)iter.next();
        }
        return collSize > 0;
    }

    public boolean addAll(LongArrayList coll) {
        int collSize = coll.size();
        this.makeRoom(collSize);
        LongIterator longIter = coll.longIterator();
        while (longIter.hasNext()) {
            this.data[this.size++] = longIter.nextLong();
        }
        return collSize > 0;
    }

    public boolean addAll(int index, Collection coll) {
        int collSize = coll.size();
        this.makeRoom(collSize);
        System.arraycopy(this.data, index, this.data, index + collSize, this.size - index);
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            this.data[index++] = (Long)iter.next();
        }
        this.size += collSize;
        return collSize > 0;
    }

    public boolean addAll(int index, LongArrayList coll) {
        int collSize = coll.size();
        this.makeRoom(collSize);
        System.arraycopy(this.data, index, this.data, index + collSize, this.size - index);
        LongIterator longIter = coll.longIterator();
        while (longIter.hasNext()) {
            this.data[index++] = longIter.nextLong();
        }
        this.size += collSize;
        return collSize > 0;
    }

    public void clear() {
        this.size = 0;
        this.data = new long[6];
    }

    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    public boolean contains(long val) {
        return this.indexOf(val) >= 0;
    }

    public boolean containsAll(Collection coll) {
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            if (this.contains(iter.next())) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(LongArrayList coll) {
        LongIterator iter = coll.longIterator();
        while (iter.hasNext()) {
            if (this.contains(iter.nextLong())) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(long[] array) {
        int i = array.length;
        while (i > 0) {
            if (this.contains(array[--i])) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public Object get(int index) {
        return this.data[index];
    }

    public long getValue(int index) {
        return this.data[index];
    }

    public int hashCode() {
        long hashCode = 1L;
        for (int i = 0; i < this.size; ++i) {
            hashCode = 31L * hashCode + this.data[i];
        }
        return (int)hashCode;
    }

    public int indexOf(Object o) {
        long val = (Long)o;
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != val) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(long val) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != val) continue;
            return i;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int lastIndexOf(Object o) {
        long val = (Long)o;
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.data[i] != val) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(long val) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.data[i] != val) continue;
            return i;
        }
        return -1;
    }

    public ListIterator listIterator() {
        return new LongIterator(0);
    }

    public ListIterator listIterator(int index) {
        return new LongIterator(index);
    }

    public Object remove(int index) {
        long val = this.data[index];
        if (index < this.size - 1) {
            System.arraycopy(this.data, index + 1, this.data, index, this.size - index);
        }
        --this.size;
        return val;
    }

    public long removeLong(int index) {
        long val = this.data[index];
        if (index < this.size - 1) {
            System.arraycopy(this.data, index + 1, this.data, index, this.size - index);
        }
        --this.size;
        return val;
    }

    public boolean remove(Object object) {
        long val = (Long)object;
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != val || i >= this.size - 1) continue;
            System.arraycopy(this.data, i + 1, this.data, i, this.size - i);
            --this.size;
            return true;
        }
        return false;
    }

    public boolean remove(long val) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != val || i >= this.size - 1) continue;
            System.arraycopy(this.data, i + 1, this.data, i, this.size - i);
            --this.size;
            return true;
        }
        return false;
    }

    public boolean removeAll(Collection coll) {
        boolean removed = false;
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            if (!this.remove(iter.next())) continue;
            removed = true;
        }
        return removed;
    }

    public boolean removeAll(LongArrayList coll) {
        boolean removed = false;
        LongIterator iter = coll.longIterator();
        while (iter.hasNext()) {
            if (!this.remove(iter.nextLong())) continue;
            removed = true;
        }
        return removed;
    }

    public boolean removeAll(long[] array) {
        boolean removed = false;
        for (int i = 0; i < array.length; ++i) {
            if (!this.remove(array[i])) continue;
            removed = true;
        }
        return removed;
    }

    public boolean retainAll(Collection coll) {
        return false;
    }

    public boolean retainAll(LongArrayList coll) {
        return false;
    }

    public boolean retainAll(long[] array) {
        return false;
    }

    public Object set(int index, Object o) {
        long oldVal = this.data[index];
        this.data[index] = (Long)o;
        return oldVal;
    }

    public long set(int index, long val) {
        long oldVal = this.data[index];
        this.data[index] = val;
        return oldVal;
    }

    public int size() {
        return this.size;
    }

    public List subList(int fromIndex, int toIndex) {
        return new LongArrayList(this.data, fromIndex, toIndex, this.growFactor);
    }

    public Object[] toArray() {
        Object[] array = new Long[this.size];
        for (int i = 0; i < this.size; ++i) {
            array[i] = this.data[i];
        }
        return array;
    }

    public Object[] toArray(Object[] arr) {
        Object[] array = new Long[this.size];
        for (int i = 0; i < this.size; ++i) {
            array[i] = this.data[i];
        }
        return array;
    }

    protected void makeRoom(int space) {
        if (space + this.size >= this.data.length) {
            long[] oldData = this.data;
            int newSize = this.size + space + (int)((double)this.size * this.growFactor) + 1;
            this.data = new long[newSize];
            System.arraycopy(oldData, 0, this.data, 0, oldData.length);
        }
    }

    public Iterator iterator() {
        return new LongIterator(0);
    }

    public LongIterator longIterator() {
        return new LongIterator(0);
    }

    public void print() {
        System.out.print("Data (size: " + this.size + "): ");
        for (int i = 0; i < this.size; ++i) {
            System.out.print(" " + this.data[i]);
        }
        System.out.println();
    }

    public static void main(String[] args) {
        int i;
        LongArrayList list = new LongArrayList();
        for (i = 0; i < 15; i += 2) {
            list.add(i);
        }
        for (i = 1; i < 15; i += 2) {
            list.add(i);
        }
    }

    private class LongIterator
    implements ListIterator {
        int startIndex;
        int index = 0;

        LongIterator(int startAt) {
            this.startIndex = startAt;
        }

        public void add(Object o) {
        }

        public boolean hasPrevious() {
            return this.index > this.startIndex;
        }

        public boolean hasNext() {
            return this.index < LongArrayList.this.size;
        }

        public Object previous() {
            return LongArrayList.this.data[--this.index];
        }

        public int previousIndex() {
            return this.index;
        }

        public Object next() {
            return LongArrayList.this.data[this.index++];
        }

        public int nextIndex() {
            return this.index;
        }

        public long previousLong() {
            return LongArrayList.this.data[--this.index];
        }

        public long nextLong() {
            return LongArrayList.this.data[this.index++];
        }

        public void remove() {
        }

        public void set(Object o) {
        }
    }
}

