/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.FieldDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;

public class BeanMethodCalculator {
    private static final String[] entityBeanHomeMethodsDisallowed = new String[]{"getEJBMetaData", "getHomeHandle"};
    private static final String[] entityBeanRemoteMethodsDisallowed = new String[]{"getEJBHome", "getHandle", "getPrimaryKey", "isIdentical"};
    private static final String[] entityBeanLocalHomeMethodsDisallowed = new String[0];
    private static final String[] entityBeanLocalInterfaceMethodsDisallowed = new String[]{"getEJBLocalHome", "getPrimaryKey", "isIdentical"};
    private static final String[] sessionBeanMethodsDisallowed = new String[]{"*"};
    private static final String[] sessionLocalBeanMethodsDisallowed = new String[]{"*"};
    private static Map disallowedMethodsPerInterface;

    public static Vector getPossibleCmpCmrFields(ClassLoader cl, String className) throws Exception {
        Vector<FieldDescriptor> fieldDescriptors = new Vector<FieldDescriptor>();
        Class<?> theClass = cl.loadClass(className);
        Method[] methods = theClass.getMethods();
        for (int mIndex = 0; mIndex < methods.length; ++mIndex) {
            Method next = methods[mIndex];
            String nextName = next.getName();
            int nextModifiers = next.getModifiers();
            if (!Modifier.isAbstract(nextModifiers) || !nextName.startsWith("get") || nextName.length() <= 3) continue;
            String field = nextName.substring(3, 4).toLowerCase() + nextName.substring(4);
            fieldDescriptors.add(new FieldDescriptor(field));
        }
        return fieldDescriptors;
    }

    public static Vector getMethodsFor(EjbDescriptor ejbDescriptor, ClassLoader classLoader) throws ClassNotFoundException {
        Vector methods = new Vector();
        if (ejbDescriptor.isRemoteInterfacesSupported()) {
            BeanMethodCalculator.addAllInterfaceMethodsIn(methods, classLoader.loadClass(ejbDescriptor.getHomeClassName()));
            BeanMethodCalculator.addAllInterfaceMethodsIn(methods, classLoader.loadClass(ejbDescriptor.getRemoteClassName()));
        }
        if (ejbDescriptor.isRemoteBusinessInterfacesSupported()) {
            for (String intf : ejbDescriptor.getRemoteBusinessClassNames()) {
                BeanMethodCalculator.addAllInterfaceMethodsIn(methods, classLoader.loadClass(intf));
            }
        }
        if (ejbDescriptor.isLocalInterfacesSupported()) {
            BeanMethodCalculator.addAllInterfaceMethodsIn(methods, classLoader.loadClass(ejbDescriptor.getLocalHomeClassName()));
            BeanMethodCalculator.addAllInterfaceMethodsIn(methods, classLoader.loadClass(ejbDescriptor.getLocalClassName()));
        }
        if (ejbDescriptor.isLocalBusinessInterfacesSupported()) {
            for (String intf : ejbDescriptor.getLocalBusinessClassNames()) {
                BeanMethodCalculator.addAllInterfaceMethodsIn(methods, classLoader.loadClass(intf));
            }
        }
        if (ejbDescriptor.hasWebServiceEndpointInterface()) {
            BeanMethodCalculator.addAllInterfaceMethodsIn(methods, classLoader.loadClass(ejbDescriptor.getWebServiceEndpointInterfaceName()));
        }
        return methods;
    }

    private static void addAllInterfaceMethodsIn(Collection methods, Class c) {
        methods.addAll(Arrays.asList(c.getMethods()));
    }

    public static Collection getTransactionalMethodsFor(EjbDescriptor ejbDescriptor, ClassLoader loader) throws ClassNotFoundException, NoSuchMethodException {
        boolean statefulSessionBean = false;
        Vector<MethodDescriptor> methods = new Vector<MethodDescriptor>();
        if (ejbDescriptor instanceof EjbSessionDescriptor) {
            Method[] busIntfMethods;
            Class<?> businessIntf;
            Collection potentials;
            Collection disallowedMethods;
            statefulSessionBean = ((EjbSessionDescriptor)ejbDescriptor).isStateful();
            if (ejbDescriptor.isRemoteInterfacesSupported()) {
                disallowedMethods = BeanMethodCalculator.extractDisallowedMethodsFor(EJBObject.class, sessionBeanMethodsDisallowed);
                potentials = BeanMethodCalculator.getTransactionMethodsFor(loader, ejbDescriptor.getRemoteClassName(), disallowedMethods);
                BeanMethodCalculator.transformAndAdd(potentials, "Remote", methods);
            }
            if (ejbDescriptor.isRemoteBusinessInterfacesSupported()) {
                for (String intfName : ejbDescriptor.getRemoteBusinessClassNames()) {
                    businessIntf = loader.loadClass(intfName);
                    for (Method next : busIntfMethods = businessIntf.getMethods()) {
                        methods.add(new MethodDescriptor(next, "Remote"));
                    }
                }
            }
            if (ejbDescriptor.isLocalInterfacesSupported()) {
                disallowedMethods = BeanMethodCalculator.extractDisallowedMethodsFor(EJBLocalObject.class, sessionLocalBeanMethodsDisallowed);
                potentials = BeanMethodCalculator.getTransactionMethodsFor(loader, ejbDescriptor.getLocalClassName(), disallowedMethods);
                BeanMethodCalculator.transformAndAdd(potentials, "Local", methods);
            }
            if (ejbDescriptor.isLocalBusinessInterfacesSupported()) {
                for (String intfName : ejbDescriptor.getLocalBusinessClassNames()) {
                    businessIntf = loader.loadClass(intfName);
                    for (Method next : busIntfMethods = businessIntf.getMethods()) {
                        methods.add(new MethodDescriptor(next, "Local"));
                    }
                }
            }
            if (ejbDescriptor.hasWebServiceEndpointInterface()) {
                Class<?> webServiceClass = loader.loadClass(ejbDescriptor.getWebServiceEndpointInterfaceName());
                Method[] webMethods = webServiceClass.getMethods();
                for (int i = 0; i < webMethods.length; ++i) {
                    methods.add(new MethodDescriptor(webMethods[i], "ServiceEndpoint"));
                }
            }
        } else {
            String localHomeIntf;
            String homeIntf = ejbDescriptor.getHomeClassName();
            if (homeIntf != null) {
                Class<?> home = loader.loadClass(homeIntf);
                Collection potentials = BeanMethodCalculator.getTransactionMethodsFor(EJBHome.class, home);
                BeanMethodCalculator.transformAndAdd(potentials, "Home", methods);
                String remoteIntf = ejbDescriptor.getRemoteClassName();
                Class<?> remote = loader.loadClass(remoteIntf);
                potentials = BeanMethodCalculator.getTransactionMethodsFor(EJBObject.class, remote);
                BeanMethodCalculator.transformAndAdd(potentials, "Remote", methods);
            }
            if ((localHomeIntf = ejbDescriptor.getLocalHomeClassName()) != null) {
                Class<?> home = loader.loadClass(localHomeIntf);
                Collection potentials = BeanMethodCalculator.getTransactionMethodsFor(EJBLocalHome.class, home);
                BeanMethodCalculator.transformAndAdd(potentials, "LocalHome", methods);
                String remoteIntf = ejbDescriptor.getLocalClassName();
                Class<?> remote = loader.loadClass(remoteIntf);
                potentials = BeanMethodCalculator.getTransactionMethodsFor(EJBLocalObject.class, remote);
                BeanMethodCalculator.transformAndAdd(potentials, "Local", methods);
            }
        }
        if (!statefulSessionBean) {
            Class<?> ejbClass = loader.loadClass(ejbDescriptor.getEjbClassName());
            if (ejbDescriptor.isTimedObject()) {
                methods.add(ejbDescriptor.getEjbTimeoutMethod());
            }
        }
        return methods;
    }

    private static Collection getTransactionMethodsFor(ClassLoader loader, String interfaceName, Collection disallowedMethods) throws ClassNotFoundException {
        Class<?> clazz = loader.loadClass(interfaceName);
        return BeanMethodCalculator.getTransactionMethodsFor(clazz, disallowedMethods);
    }

    private static Collection getTransactionMethodsFor(Class interfaceImpl, Collection disallowedMethods) {
        Vector<Method> v = new Vector<Method>(Arrays.asList(interfaceImpl.getMethods()));
        v.removeAll(disallowedMethods);
        return v;
    }

    private static Collection getTransactionMethodsFor(Class interfaceType, Class interfaceImpl) {
        Collection disallowedTransactionMethods = BeanMethodCalculator.getDisallowedTransactionMethodsFor(interfaceType);
        return BeanMethodCalculator.getTransactionMethodsFor(interfaceImpl, disallowedTransactionMethods);
    }

    private static Collection getDisallowedTransactionMethodsFor(Class interfaceType) {
        return BeanMethodCalculator.extractDisallowedMethodsFor(interfaceType, BeanMethodCalculator.getDisallowedMethodsNamesFor(interfaceType));
    }

    private static Collection extractDisallowedMethodsFor(Class interfaceType, String[] methodNames) {
        Vector<Method> v = new Vector<Method>();
        if (methodNames.length == 0) {
            return v;
        }
        Method[] methods = interfaceType.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (methodNames[0].equals("*")) {
                v.addElement(methods[i]);
                continue;
            }
            if (Arrays.binarySearch(methodNames, methods[i].getName()) < 0) continue;
            v.addElement(methods[i]);
        }
        return v;
    }

    private static void transformAndAdd(Collection methods, String methodIntf, Vector globalList) {
        for (Method m : methods) {
            MethodDescriptor md = new MethodDescriptor(m, methodIntf);
            globalList.add(md);
        }
    }

    private static String[] getDisallowedMethodsNamesFor(Class interfaceType) {
        return (String[])BeanMethodCalculator.getDisallowedMethodsNames().get(interfaceType);
    }

    protected static Map getDisallowedMethodsNames() {
        if (disallowedMethodsPerInterface == null) {
            disallowedMethodsPerInterface = new Hashtable();
            disallowedMethodsPerInterface.put(EJBHome.class, entityBeanHomeMethodsDisallowed);
            disallowedMethodsPerInterface.put(EJBObject.class, entityBeanRemoteMethodsDisallowed);
            disallowedMethodsPerInterface.put(EJBLocalHome.class, entityBeanLocalHomeMethodsDisallowed);
            disallowedMethodsPerInterface.put(EJBLocalObject.class, entityBeanLocalInterfaceMethodsDisallowed);
        }
        return disallowedMethodsPerInterface;
    }
}

