/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.session.stateless;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.Method;

public class StatelessCreateReturn
extends EjbTest
implements EjbCheck {
    boolean foundAtLeastOneCreate = false;
    Result result = null;
    ComponentNameConstructor compName = null;

    public Result check(EjbDescriptor descriptor) {
        String stateType;
        this.result = this.getInitializedResult();
        this.compName = this.getVerifierContext().getComponentNameConstructor();
        if (descriptor instanceof EjbSessionDescriptor && "Stateless".equals(stateType = ((EjbSessionDescriptor)descriptor).getSessionType())) {
            if (descriptor.getHomeClassName() != null && !"".equals(descriptor.getHomeClassName()) && descriptor.getRemoteClassName() != null && !"".equals(descriptor.getRemoteClassName())) {
                this.commonToBothInterfaces(descriptor.getRemoteClassName(), descriptor.getHomeClassName(), (EjbSessionDescriptor)descriptor);
            }
            if (descriptor.getLocalHomeClassName() != null && !"".equals(descriptor.getLocalHomeClassName()) && descriptor.getLocalClassName() != null && !"".equals(descriptor.getLocalClassName())) {
                this.commonToBothInterfaces(descriptor.getLocalClassName(), descriptor.getLocalHomeClassName(), (EjbSessionDescriptor)descriptor);
            }
            if (this.result.getStatus() != 1) {
                this.addGoodDetails(this.result, this.compName);
                this.result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "create method is properly defined in the remote/local home interface"));
            }
            return this.result;
        }
        return this.result;
    }

    private void commonToBothInterfaces(String remote, String home, EjbSessionDescriptor descriptor) {
        try {
            Class<?> c = Class.forName(home, false, this.getVerifierContext().getClassLoader());
            for (Method methods : c.getDeclaredMethods()) {
                Class<?> methodReturnType;
                if (!methods.getName().startsWith("create") || (methodReturnType = methods.getReturnType()).getName().equals(remote)) continue;
                this.addErrorDetails(this.result, this.compName);
                this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For Home Interface [ {0} ] Method [ {1} ]", new Object[]{home, methods.getName()}));
                this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: A Create method was found, but the return type [ {0} ] was not the Remote/Local interface", new Object[]{methodReturnType.getName()}));
            }
        }
        catch (ClassNotFoundException e) {
            Verifier.debug(e);
            this.addErrorDetails(this.result, this.compName);
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Home/Local Home interface [ {0} ] does not exist or is not loadable within bean [ {1} ]", new Object[]{home, descriptor.getName()}));
        }
    }
}

