/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.createmethod;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.Method;

public class HomeInterfaceCreateMethodReturn
extends EjbTest
implements EjbCheck {
    boolean foundAtLeastOneCreate = false;
    Result result = null;
    ComponentNameConstructor compName = null;
    boolean remote_exists = false;
    boolean local_exists = false;

    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        this.compName = this.getVerifierContext().getComponentNameConstructor();
        String local = null;
        String localHome = null;
        String remote = null;
        String home = null;
        if (descriptor instanceof EjbEntityDescriptor) {
            boolean oneFailed = false;
            if (descriptor.getHomeClassName() != null && !"".equals(descriptor.getHomeClassName()) && descriptor.getRemoteClassName() != null && !"".equals(descriptor.getRemoteClassName())) {
                this.remote_exists = true;
                home = descriptor.getHomeClassName();
                remote = descriptor.getRemoteClassName();
            }
            if (descriptor.getLocalHomeClassName() != null && !"".equals(descriptor.getLocalHomeClassName()) && descriptor.getLocalClassName() != null && !"".equals(descriptor.getLocalClassName())) {
                this.local_exists = true;
                localHome = descriptor.getLocalHomeClassName();
                local = descriptor.getLocalClassName();
            }
            oneFailed = this.commonToBothInterfaces(remote, home, local, localHome, (EjbEntityDescriptor)descriptor);
            if (!this.foundAtLeastOneCreate) {
                this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                this.result.addNaDetails(smh.getLocalString(this.getClass().getName() + ".debug3", "In Home Interface ", new Object[0]));
                this.result.addNaDetails(smh.getLocalString(this.getClass().getName() + ".notApplicable1", "No create method was found, test not applicable."));
                this.result.setStatus(3);
            } else if (oneFailed) {
                this.result.setStatus(1);
            } else {
                this.result.setStatus(0);
            }
            return this.result;
        }
        this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
        this.result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Entity", "Session"}));
        return this.result;
    }

    private boolean commonToBothInterfaces(String remote, String home, String local, String localHome, EjbEntityDescriptor descriptor) {
        boolean oneFailed = false;
        try {
            Context context = this.getVerifierContext();
            ClassLoader jcl = context.getClassLoader();
            if (this.remote_exists) {
                Class<?> c = Class.forName(home, false, this.getVerifierContext().getClassLoader());
                Class<?> rc = Class.forName(remote, false, this.getVerifierContext().getClassLoader());
                Method[] methods = c.getDeclaredMethods();
                oneFailed = this.findReturnType(methods, home, local, remote);
            }
            if (!oneFailed && this.local_exists) {
                Class<?> hc = Class.forName(localHome, false, this.getVerifierContext().getClassLoader());
                Class<?> lc = Class.forName(local, false, this.getVerifierContext().getClassLoader());
                Method[] localMethods = hc.getDeclaredMethods();
                oneFailed = this.findReturnType(localMethods, localHome, local, remote);
            }
            return oneFailed;
        }
        catch (ClassNotFoundException e) {
            Verifier.debug(e);
            this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Home interface [ {0} ] or [ {1} ]or Component interface [ {2} ] or [ {3} ] does not exist or is not loadable within bean [ {4} ]", new Object[]{home, localHome, remote, local, descriptor.getName()}));
            return false;
        }
    }

    private boolean findReturnType(Method[] methods, String home, String local, String remote) {
        boolean oneFailed = false;
        for (int i = 0; i < methods.length; ++i) {
            boolean validReturn = false;
            if (!methods[i].getName().startsWith("create")) continue;
            this.foundAtLeastOneCreate = true;
            Class<?> methodReturnType = methods[i].getReturnType();
            if (this.remote_exists && methodReturnType.getName().equals(remote)) {
                validReturn = true;
                this.result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For Home Interface [ {0} ] Method [ {1} ]", new Object[]{home, methods[i].getName()}));
                this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "The create method which returns [ {0} ] interface was found.", new Object[]{"remote"}));
            }
            if (this.local_exists && methodReturnType.getName().equals(local)) {
                validReturn = true;
                this.result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For Home Interface [ {0} ] Method [ {1} ]", new Object[]{home, methods[i].getName()}));
                this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "The create method which returns [ {0} ] interface was found.", new Object[]{"local"}));
            }
            if (validReturn) continue;
            oneFailed = true;
            this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
            this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For Home Interface [ {0} ] Method [ {1} ]", new Object[]{home, methods[i].getName()}));
            this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: A Create method was found, but the return type [ {0} ] was not the Remote/Local interface", new Object[]{methodReturnType.getName()}));
            return oneFailed;
        }
        return oneFailed;
    }
}

