/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.elements;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.types.EjbReference;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;

public class EjbReferencesElement
extends EjbTest
implements EjbCheck {
    Result result = null;
    ComponentNameConstructor compName = null;

    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        this.compName = this.getVerifierContext().getComponentNameConstructor();
        if (descriptor instanceof EjbEntityDescriptor || descriptor instanceof EjbSessionDescriptor) {
            try {
                String fName = null;
                Set<EjbReference> references = descriptor.getEjbReferenceDescriptors();
                if (references == null) {
                    this.logger.log(Level.INFO, this.getClass().getName() + ".refnull");
                    return this.result;
                }
                Iterator<EjbReference> iterator = references.iterator();
                if (iterator.hasNext()) {
                    boolean oneFailed = false;
                    fName = descriptor.getEjbBundleDescriptor().getModuleDescriptor().getArchiveUri();
                    while (iterator.hasNext()) {
                        EjbReferenceDescriptor ejbReference = (EjbReferenceDescriptor)iterator.next();
                        if (ejbReference.isLinked()) {
                            if (ejbReference.getEjbHomeInterface() == null || ejbReference.getEjbInterface() == null) continue;
                            oneFailed = this.commonToBothInterfaces(ejbReference.getEjbHomeInterface(), ejbReference.getEjbInterface(), fName);
                            continue;
                        }
                        this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                        this.result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable2", "Not Applicable: [ {0} ] must be external reference to bean outside of [ {1} ].", new Object[]{ejbReference.getName(), fName}));
                    }
                    if (oneFailed) {
                        this.result.setStatus(1);
                    } else {
                        this.result.setStatus(0);
                    }
                } else {
                    this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                    this.result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable1", "There are no ejb references to other beans within this bean [ {0} ]", new Object[]{descriptor.getName()}));
                }
                return this.result;
            }
            catch (Exception e) {
                this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedRef", "Exception occurred : [ {0} ]", new Object[]{e.getMessage()}));
                return this.result;
            }
        }
        this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
        this.result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] not called \n with a Session or Entity bean.", new Object[]{this.getClass()}));
        return this.result;
    }

    private boolean commonToBothInterfaces(String home, String remote, String fileName) {
        boolean foundHomeClassName = false;
        boolean foundRemoteClassName = false;
        boolean oneFailed = false;
        try {
            Class<?> c = Class.forName(home, false, this.getVerifierContext().getClassLoader());
            if (c != null) {
                foundHomeClassName = true;
                this.result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                this.result.passed(smh.getLocalString(this.getClass().getName() + ".passed2", "The referenced bean's home interface [ {0} ] exists and is loadable within [ {1} ].", new Object[]{home, fileName}));
            } else {
                oneFailed = true;
                this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                this.result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: [ {0} ] class cannot be found within this jar [ {1} ].", new Object[]{home, fileName}));
            }
            c = Class.forName(remote, false, this.getVerifierContext().getClassLoader());
            if (c != null) {
                foundRemoteClassName = true;
                this.result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                this.result.passed(smh.getLocalString(this.getClass().getName() + ".passed3", "The referenced bean's remote interface [ {0} ] exists and is loadable within [ {1} ].", new Object[]{remote, fileName}));
            } else {
                oneFailed = true;
                this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                this.result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: [ {0} ] class cannot be found within this jar [ {1} ].", new Object[]{this.compName, fileName}));
            }
            return oneFailed;
        }
        catch (Exception e) {
            Verifier.debug(e);
            if (!oneFailed) {
                oneFailed = true;
            }
            String classStr = "";
            if (!foundHomeClassName) {
                classStr = home;
            } else if (!foundRemoteClassName) {
                classStr = remote;
            }
            this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: class [ {0} ] cannot be found within this jar [ {1} ].", new Object[]{classStr, fileName}));
            return oneFailed;
        }
    }
}

